/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.StrictHostKeyChecking;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.X11DisplayNameGetter;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.config.ApplyJschBasedOpenSshConfig;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.config.IdentityAgent;
import com.intellij.ssh.config.OpenSSHConfig;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.ServerAlive;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.util.SmartFMap;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004\u001a\u0012\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\f\u0010\u000e\u001a\u00020\t*\u00020\tH\u0000\u001a\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010*\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0002\u001a5\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\f\u0010\u0017\u001a\u00020\u0004*\u00020\u0004H\u0002\u001a\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"/\u0010\u0002\u001a#\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00060\u00060\u0003\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "strictHostKeyCheckingMap", "Lcom/intellij/util/SmartFMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/remote/StrictHostKeyChecking;", "Lorg/jetbrains/annotations/NotNull;", "applyJschBasedOpenSshConfig", "Lcom/intellij/ssh/config/SshConnectionConfig;", "source", "config", "strictHostKeyCheckingFromOpenSshConfigOption", "strictHostKeyCheckingValue", "addDefaultPrivateKeysIfNeeded", "parseSeparated", "", "splitChar", "", "fallback", "parseSeparatedMulti", "", "([Ljava/lang/String;CLjava/util/List;)Ljava/util/List;", "unquoteSingleArgumentValue", "yesNo", "", "Lcom/intellij/ssh/config/ConfigRepository$Config;", "key", "(Lcom/intellij/ssh/config/ConfigRepository$Config;Ljava/lang/String;)Ljava/lang/Boolean;", "intellij.platform.ssh"})
@JvmName(name="ApplyJschBasedOpenSshConfig")
@SourceDebugExtension(value={"SMAP\nApplyJschBasedOpenSshConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplyJschBasedOpenSshConfig.kt\ncom/intellij/ssh/config/ApplyJschBasedOpenSshConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,310:1\n1#2:311\n1#2:326\n1#2:344\n1#2:386\n14#3:312\n14#3:333\n766#4:313\n857#4,2:314\n1603#4,9:316\n1855#4:325\n1856#4:327\n1612#4:328\n1549#4:329\n1620#4,3:330\n1002#4,2:347\n1360#4:357\n1446#4,5:358\n1789#4,3:363\n1549#4:366\n1620#4,3:367\n1360#4:370\n1446#4,5:371\n1603#4,9:376\n1855#4:385\n1856#4:387\n1612#4:388\n1549#4:393\n1620#4,3:394\n766#4:397\n857#4,2:398\n11383#5,9:334\n13309#5:343\n13310#5:345\n11392#5:346\n11065#5:349\n11400#5,3:350\n11065#5:353\n11400#5,3:354\n12720#5,3:390\n26#6:389\n10#7:400\n*S KotlinDebug\n*F\n+ 1 ApplyJschBasedOpenSshConfig.kt\ncom/intellij/ssh/config/ApplyJschBasedOpenSshConfig\n*L\n101#1:326\n129#1:344\n222#1:386\n90#1:312\n122#1:333\n100#1:313\n100#1:314,2\n101#1:316,9\n101#1:325\n101#1:327\n101#1:328\n103#1:329\n103#1:330,3\n187#1:347,2\n205#1:357\n205#1:358,5\n209#1:363,3\n216#1:366\n216#1:367,3\n218#1:370\n218#1:371,5\n222#1:376,9\n222#1:385\n222#1:387\n222#1:388\n279#1:393\n279#1:394,3\n279#1:397\n279#1:398,2\n129#1:334,9\n129#1:343\n129#1:345\n129#1:346\n197#1:349\n197#1:350,3\n201#1:353\n201#1:354,3\n262#1:390,3\n262#1:389\n310#1:400\n*E\n"})
public final class ApplyJschBasedOpenSshConfig {
    @NotNull
    private static final SmartFMap<String, StrictHostKeyChecking> strictHostKeyCheckingMap;
    @NotNull
    private static final Logger LOG;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final SshConnectionConfig applyJschBasedOpenSshConfig(@NotNull SshConnectionConfig source, @NotNull String config) {
        block105: {
            block104: {
                block103: {
                    block102: {
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                        v0 = OpenSSHConfig.parse(config).getConfig(source.getHost());
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getConfig(...)");
                        parsed = v0;
                        v1 = parsed.getValue("HostName");
                        if (v1 == null) {
                            v1 = host = source.getHost();
                        }
                        if ((v2 = parsed.getValue("User")) == null) {
                            v2 = source.getUser();
                        }
                        user = v2;
                        v3 = parsed.getValue("Port");
                        port = v3 != null && (v3 = StringsKt.toIntOrNull((String)v3)) != null ? v3.intValue() : source.getPort();
                        raw = parsed.getValue("ConnectTimeout");
                        $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$connectTimeout$1 = false;
                        if (raw == null) ** GOTO lbl-1000
                        switch (raw.hashCode()) {
                            case 3387192: {
                                if (raw.equals("none")) {
                                    v4 = null;
                                    break;
                                }
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                if ((v4 = raw) == null) ** GOTO lbl33
                                Intrinsics.checkNotNull((Object)v4);
                                v4 = StringsKt.toLongOrNull((String)raw);
                                if (v4 == null) ** GOTO lbl33
                                it = ((Number)v4).longValue();
                                $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$connectTimeout$1$1 = false;
                                v5 = Duration.ofSeconds(it);
                                v4 = v5;
                                if (v5 != null) break;
lbl33:
                                // 3 sources

                                v4 = source.getConnectTimeout();
                            }
                        }
                        connectTimeout = v4;
                        v6 = ApplyJschBasedOpenSshConfig.yesNo(parsed, "Compression");
                        compression = v6 != null ? v6.booleanValue() : source.getCompression();
                        kexAlgorithms = ApplyJschBasedOpenSshConfig.parseSeparatedMulti(parsed.getValues("KexAlgorithms"), ',', source.getKexAlgorithms());
                        hostKeyAlgorithms = ApplyJschBasedOpenSshConfig.parseSeparatedMulti(parsed.getValues("HostKeyAlgorithms"), ',', source.getHostKeyAlgorithms());
                        ciphers = ApplyJschBasedOpenSshConfig.parseSeparatedMulti(parsed.getValues("Ciphers"), ',', source.getCiphers());
                        macs = ApplyJschBasedOpenSshConfig.parseSeparatedMulti(parsed.getValues("MACs"), ',', source.getMacs());
                        $i$a$-run-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1 = false;
                        var14_18 = parsed.getValue("ServerAliveInterval");
                        v7 = var14_18;
                        if (v7 == null) ** GOTO lbl-1000
                        Intrinsics.checkNotNull((Object)v7);
                        v7 = StringsKt.toLongOrNull((String)var14_18);
                        if (v7 == null) ** GOTO lbl-1000
                        var15_20 = v7;
                        it = ((Number)var15_20).longValue();
                        $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgInterval$1 = false;
                        v7 = it > 0L != false ? var15_20 : null;
                        if (v7 != null) {
                            it = ((Number)v7).longValue();
                            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgInterval$2 = false;
                            v8 = Duration.ofSeconds(it);
                        } else lbl-1000:
                        // 3 sources

                        {
                            v8 = cfgInterval = null;
                        }
                        if ((v9 = (var20_30 = parsed.getValue("ServerAliveCountMax"))) == null) ** GOTO lbl-1000
                        Intrinsics.checkNotNull((Object)v9);
                        v9 = StringsKt.toIntOrNull((String)var20_30);
                        if (v9 != null) {
                            var15_20 = v9;
                            it = ((Number)var15_20).intValue();
                            $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgCountMax$1 = false;
                            v10 = it > 0 ? var15_20 : null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v10 = null;
                        }
                        cfgCountMax = v10;
                        if (cfgInterval != null && cfgCountMax != null) {
                            v11 = new ServerAlive(cfgInterval, cfgCountMax.intValue());
                        } else if (cfgInterval != null) {
                            v12 = source.getServerAlive();
                            v11 = new ServerAlive(cfgInterval, v12 != null ? v12.getCountMax() : 3);
                        } else if (cfgCountMax != null) {
                            v13 = source.getServerAlive();
                            v11 = v13 != null ? ServerAlive.copy$default(v13, null, cfgCountMax.intValue(), 1, null) : null;
                        } else {
                            v11 = source.getServerAlive();
                        }
                        serverAlive = v11;
                        if (!Registry.is((String)"ssh.x11.forwarding")) ** GOTO lbl-1000
                        v14 = parsed.getValue("ForwardX11");
                        if (v14 != null) {
                            v15 = v14.toLowerCase();
                            v16 = v15;
                            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"toLowerCase(...)");
                        } else {
                            v16 = null;
                        }
                        if (!Intrinsics.areEqual((Object)v16, (Object)"yes")) lbl-1000:
                        // 2 sources

                        {
                            v17 = null;
                        } else {
                            v18 = ApplyJschBasedOpenSshConfig.yesNo(parsed, "ForwardX11Trusted");
                            if (v18 != null) {
                                v19 = v18;
                            } else {
                                v20 = source.getX11Forwarding();
                                v21 = v20 != null ? Boolean.valueOf(v20.getTrusted()) : null;
                                v19 = v21 != null ? v21 : false;
                            }
                            if ((v22 = parsed.getValue("XAuthLocation")) == null) {
                                v23 = source.getX11Forwarding();
                                v22 = v23 != null ? v23.getXAuthLocation() : null;
                                if (v22 == null) {
                                    v22 = X11Forwarding.Companion.getDefaultXAuthLocation();
                                }
                            }
                            cfgCountMax = v22;
                            Intrinsics.checkNotNull((Object)cfgCountMax);
                            v24 = source.getX11Forwarding();
                            if (v24 == null || (v24 = v24.getDisplayName()) == null) {
                                v24 = X11DisplayNameGetter.Companion.getInstance().getDisplay();
                            }
                            v17 = x11Forwarding = new X11Forwarding(v19, (String)cfgCountMax, (String)v24);
                        }
                        if (!Registry.is((String)"ssh.agent.forwarding")) ** GOTO lbl-1000
                        v25 = parsed.getValue("ForwardAgent");
                        if (v25 != null) {
                            v26 = v25.toLowerCase();
                            v27 = v26;
                            Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"toLowerCase(...)");
                        } else {
                            v27 = null;
                        }
                        if (Intrinsics.areEqual((Object)v27, (Object)"yes")) {
                            v28 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v28 = false;
                        }
                        forwardAgent = v28;
                        v29 = parsed.getValue("IdentityAgent");
                        if (v29 != null) {
                            p0 = v29;
                            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$identityAgent$1 = false;
                            v30 = new IdentityAgent(p0);
                        } else {
                            v30 = null;
                        }
                        identityAgent = v30;
                        $i$a$-run-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1 = false;
                        $this$asSafely$iv = source.getHostKeyVerifier();
                        $i$f$asSafely = false;
                        v31 = $this$asSafely$iv;
                        if (!(v31 instanceof OpenSshLikeHostKeyVerifier)) {
                            v31 = null;
                        }
                        old = (OpenSshLikeHostKeyVerifier)v31;
                        v32 /* !! */  = parsed.getValue("StrictHostKeyChecking");
                        if (v32 /* !! */  == null) break block102;
                        it = v32 /* !! */ ;
                        $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$strictHostKeyChecking$1 = false;
                        v33 = ApplyJschBasedOpenSshConfig.strictHostKeyCheckingFromOpenSshConfigOption(it);
                        v32 /* !! */  = v33;
                        if (v33 != null) break block103;
                    }
                    v34 = old;
                    v32 /* !! */  = v34 != null ? v34.getStrictHostKeyChecking() : (strictHostKeyChecking = StrictHostKeyChecking.ASK);
                }
                if ((var23_45 = parsed.getValue("UserKnownHostsFile")) != null && (var24_48 = StringsKt.split$default((CharSequence)var23_45, (char[])(it = new char[]{' '}), (boolean)false, (int)0, (int)6, null)) != null) {
                    $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$strictHostKeyChecking$1 = var24_48;
                    $i$f$filter = false;
                    var26_61 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (String)element$iv$iv;
                        $i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1 = false;
                        v35 = !StringsKt.isBlank((CharSequence)it);
                        if (!v35) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $i$f$filter = (List)destination$iv$iv;
                    $i$f$mapNotNull = false;
                    destination$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    $i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1 = $this$forEach$iv$iv$iv.iterator();
                    while ($i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = $i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (String)element$iv$iv;
                        $i$a$-mapNotNull-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2 = false;
                        try {
                            $i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1 = false;
                            $i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1 = Result.constructor-impl((Object)new File(FileUtil.expandUserHome((String)StringsKt.trim((CharSequence)((CharSequence)it)).toString())));
                        }
                        catch (Throwable var39_131) {
                            $i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var39_131));
                        }
                        if ((File)(Result.isFailure-impl((Object)$i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1) != false ? null : $i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    v36 = (List)destination$iv$iv;
                } else {
                    v37 = old;
                    if (v37 != null) {
                        v36 = v37.getKnownHostsFiles();
                    } else {
                        $this$map$iv = OpenSSHConfigUtil.getDefaultKnownHostsFiles();
                        $i$f$map = false;
                        $this$mapNotNullTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = 0;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            $i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1 = (Path)item$iv$iv;
                            var42_137 = destination$iv$iv;
                            $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$3 = false;
                            var42_137.add(it.toFile());
                        }
                        v36 = (List)destination$iv$iv;
                    }
                }
                knownHostsFiles = v36;
                v38 = ApplyJschBasedOpenSshConfig.yesNo(parsed, "HashKnownHosts");
                if (v38 != null) {
                    v39 = v38;
                } else {
                    v40 = old;
                    v41 = v40 != null ? Boolean.valueOf(v40.getHashKnownHosts()) : null;
                    v39 = hashKnownHosts = v41 != null ? v41 : false;
                }
                hostKeyVerifier = ((Collection)knownHostsFiles).isEmpty() == false ? (SshHostKeyVerifier)new OpenSshLikeHostKeyVerifier(knownHostsFiles, (StrictHostKeyChecking)strictHostKeyChecking, hashKnownHosts, false, 8, null) : source.getHostKeyVerifier();
                v42 = parsed.getValue("ProxyCommand");
                if (v42 == null || (v42 = ApplyJschBasedOpenSshConfig.unquoteSingleArgumentValue(v42)) == null) break block104;
                it = it = v42;
                $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyCommand$1 = false;
                if (!(((CharSequence)it).length() > 0)) ** GOTO lbl-1000
                v43 = it.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)v43, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)v43, (Object)"none")) {
                    v44 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v44 = false;
                }
                if ((v42 = v44 != false ? it : null) != null) break block105;
            }
            if ((v45 = parsed.getValue("ProxyJump")) == null) ** GOTO lbl-1000
            p0 = v45;
            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyCommand$2 = false;
            v46 = OpenSSHConfigUtil.parseJump(p0);
            v45 = v46;
            if (v46 != null) {
                v42 = OpenSSHConfigUtil.toProxyCommand((ProxyJumpOptions)v45);
            } else lbl-1000:
            // 2 sources

            {
                $this$asSafely$iv = source.getProxyConfig();
                $i$f$asSafely = false;
                v47 = $this$asSafely$iv;
                if (!(v47 instanceof SshProxyConfig.Command)) {
                    v47 = null;
                }
                v48 = (SshProxyConfig.Command)v47;
                v42 = v48 != null ? v48.getCommand() : null;
            }
        }
        v49 = proxyCommand = v42;
        if (v49 != null) {
            it = v49;
            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyConfig$1 = false;
            v50 = new SshProxyConfig.Command(it);
        } else {
            v50 = null;
        }
        proxyConfig = v50;
        $i$a$-run-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$authMethods$1 = false;
        $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyConfig$1 = parsed.getValues("IdentityFile");
        if ($i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyConfig$1 != null) {
            it = $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyConfig$1;
            $i$f$mapNotNull = false;
            $this$asSafely$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            $this$forEach$iv$iv$iv = ((void)$this$forEach$iv$iv$iv).length;
            for ($i$f$mapTo = 0; $i$f$mapTo < $this$forEach$iv$iv$iv; ++$i$f$mapTo) {
                element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[$i$f$mapTo];
                $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                it = element$iv$iv;
                $i$a$-mapNotNull-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$authMethods$1$identityFiles$1 = false;
                try {
                    Intrinsics.checkNotNull((Object)it);
                    it = Paths.get(FileUtil.expandUserHome((String)ApplyJschBasedOpenSshConfig.unquoteSingleArgumentValue((String)it)), new String[0]);
                }
                catch (InvalidPathException err) {
                    ApplyJschBasedOpenSshConfig.LOG.warn("Wrong IdentityFile " + (String)it);
                    it = null;
                }
                if (it == null) continue;
                $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v51 = (List)destination$iv$iv;
        } else {
            v51 = CollectionsKt.emptyList();
        }
        identityFiles = v51;
        identitiesOnly = ApplyJschBasedOpenSshConfig.yesNo(parsed, "IdentitiesOnly");
        sourcePublicKey = SshConnectionConfigKt.findPublicKeyWithIndex(source.getAuthMethods());
        result = CollectionsKt.toMutableList((Collection)source.getAuthMethods());
        if (((Collection)identityFiles).isEmpty() == false && sourcePublicKey != null) {
            result.remove(((Number)sourcePublicKey.getFirst()).intValue());
        }
        v52 = sourcePublicKey;
        v53 = v52 != null ? ((Number)v52.getFirst()).intValue() : result.size();
        v54 = sourcePublicKey;
        v55 = v54 != null && (v54 = (AuthMethod.PublicKey)v54.getSecond()) != null ? v54.getAgent() : null;
        switch (v55 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v55.ordinal()]) {
            case 1: {
                v56 = AuthMethod.PublicKey.Agent.NO;
                break;
            }
            case 2: 
            case 3: {
                destination$iv$iv = identitiesOnly;
                if (Intrinsics.areEqual((Object)destination$iv$iv, (Object)true)) {
                    v56 = AuthMethod.PublicKey.Agent.ONLY_MENTIONED;
                    break;
                }
                if (Intrinsics.areEqual((Object)destination$iv$iv, (Object)false)) {
                    v56 = AuthMethod.PublicKey.Agent.ALL;
                    break;
                }
                if (destination$iv$iv == null) {
                    v56 = ((AuthMethod.PublicKey)sourcePublicKey.getSecond()).getAgent();
                    break;
                }
                throw new NoWhenBranchMatchedException();
            }
            case -1: {
                v56 = AuthMethod.PublicKey.Agent.ALL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        result.add(v53, new AuthMethod.PublicKey(identityFiles, v56));
        ((Collection)result).add(AuthMethod.Password.INSTANCE);
        if (!Intrinsics.areEqual((Object)ApplyJschBasedOpenSshConfig.yesNo(parsed, "ChallengeResponseAuthentication"), (Object)false)) {
            ((Collection)result).add(AuthMethod.KeyboardInteractive.INSTANCE);
        }
        v57 = ApplyJschBasedOpenSshConfig.yesNo(parsed, "GSSAPIAuthentication");
        if (v57 != null) {
            it = v57;
            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$authMethods$1$1 = false;
            if (it) {
                result.add(0, AuthMethod.GssApi.INSTANCE);
                v58 = Unit.INSTANCE;
            } else {
                v58 = result.remove(AuthMethod.GssApi.INSTANCE);
            }
        } else {
            v58 = null;
        }
        if ((v59 = ($i$f$mapNotNull = parsed.getValue("PreferredAuthentications"))) == null) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)v59);
        v59 = ApplyJschBasedOpenSshConfig.parseSeparated($i$f$mapNotNull, ',');
        if (v59 != null) {
            preferredAuthentications = v59;
            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$authMethods$1$2 = false;
            $this$sortBy$iv = result;
            $i$f$sortBy = 0;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(preferredAuthentications){
                    final /* synthetic */ List $preferredAuthentications$inlined;
                    {
                        this.$preferredAuthentications$inlined = list2;
                    }

                    public final int compare(T a, T b) {
                        AuthMethod it = (AuthMethod)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(it)) + Integer.MAX_VALUE + 1);
                        it = (AuthMethod)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(it)) + Integer.MAX_VALUE + 1));
                    }
                });
            }
            v60 = Unit.INSTANCE;
        } else lbl-1000:
        // 2 sources

        {
            v60 = null;
        }
        authMethods = AuthMethods.Companion.create(result);
        v61 = ApplyJschBasedOpenSshConfig.yesNo(parsed, "ClearAllForwardings");
        v62 = clearAllForwarding = v61 != null ? v61 : false;
        if (clearAllForwarding) {
            v63 = source.getInitialLocalTcpForwardings();
        } else {
            v64 = source.getInitialLocalTcpForwardings();
            v65 = parsed.getValues("LocalForward");
            if (v65 != null) {
                $this$mapNotNullTo$iv$iv = v65;
                var44_138 = v64;
                $i$f$map = false;
                preferredAuthentications = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                $i$f$mapTo = false;
                $this$forEach$iv$iv$iv = ((void)$this$mapTo$iv$iv).length;
                for ($i$f$sortBy = 0; $i$f$sortBy < $this$forEach$iv$iv$iv; ++$i$f$sortBy) {
                    element$iv$iv = item$iv$iv = $this$mapTo$iv$iv[$i$f$sortBy];
                    var45_139 = destination$iv$iv;
                    $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$initialLocalTcpForwardings$1 = false;
                    var45_139.add(OpenSSHConfigUtil.parseOpenSshConfigForwardInfo((String)p0));
                }
                v64 = var44_138;
                v66 = (List)destination$iv$iv;
            } else {
                v66 = CollectionsKt.emptyList();
            }
            v63 = initialLocalTcpForwardings = CollectionsKt.plus((Collection)v64, (Iterable)v66);
        }
        if (clearAllForwarding) {
            v67 = source.getInitialRemoteTcpForwardings();
        } else {
            v68 = source.getInitialRemoteTcpForwardings();
            v69 = parsed.getValues("RemoteForward");
            if (v69 != null) {
                $i$f$map = v69;
                var44_138 = v68;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                $i$f$mapTo = 0;
                item$iv$iv = ((void)$this$mapTo$iv$iv).length;
                for ($this$forEach$iv$iv$iv = 0; $this$forEach$iv$iv$iv < item$iv$iv; ++$this$forEach$iv$iv$iv) {
                    $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$initialLocalTcpForwardings$1 = item$iv$iv = $this$mapTo$iv$iv[$this$forEach$iv$iv$iv];
                    var45_139 = destination$iv$iv;
                    $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$initialRemoteTcpForwardings$1 = false;
                    var45_139.add(OpenSSHConfigUtil.parseOpenSshConfigForwardInfo((String)p0));
                }
                v68 = var44_138;
                v70 = (List)destination$iv$iv;
            } else {
                v70 = CollectionsKt.emptyList();
            }
            v67 = initialRemoteTcpForwardings = CollectionsKt.plus((Collection)v68, (Iterable)v70);
        }
        if ((v71 /* !! */  = parsed.getValues("SendEnv")) == null || (v71 /* !! */  = ArraysKt.toList((Object[])v71 /* !! */ )) == null) {
            v71 /* !! */  = CollectionsKt.emptyList();
        }
        $this$map$iv = (Iterable)v71 /* !! */ ;
        $i$f$flatMap = false;
        $i$f$map = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            rawConcat = (String)element$iv$iv;
            $i$a$-flatMap-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$1 = false;
            Intrinsics.checkNotNull((Object)rawConcat);
            v72 = UtilKt.argvSplit(rawConcat, true);
            if (v72 == null) {
                v72 = CollectionsKt.emptyList();
            }
            list$iv$iv = v72;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = new LinkedHashSet<E>();
        $i$f$fold = false;
        accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            element$iv$iv = (String)element$iv;
            set = accumulator$iv;
            $i$a$-fold-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$2 = false;
            if (StringsKt.startsWith$default((String)raw, (String)"-", (boolean)false, (int)2, null)) {
                v73 = (Collection)set;
                v74 = raw.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)v74, (String)"substring(...)");
                v73.remove(v74);
            } else {
                ((Collection)set).add(raw);
            }
            accumulator$iv = set;
        }
        $this$fold$iv = (Iterable)accumulator$iv;
        $i$f$map = false;
        $i$f$fold = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (E item$iv$iv : $this$mapTo$iv$iv) {
            set = (String)item$iv$iv;
            var44_138 = destination$iv$iv;
            $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$3 = false;
            var44_138.add(new EnvironmentVariable.Inherit((String)p0));
        }
        v75 = (List)destination$iv$iv;
        v76 /* !! */  = parsed.getValues("SetEnv");
        if (v76 /* !! */  == null || (v76 /* !! */  = ArraysKt.toList((Object[])v76 /* !! */ )) == null) {
            v76 /* !! */  = CollectionsKt.emptyList();
        }
        $this$map$iv = (Iterable)v76 /* !! */ ;
        var44_138 = v75;
        $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (E element$iv$iv : $this$flatMapTo$iv$iv) {
            rawConcat = (String)element$iv$iv;
            $i$a$-flatMap-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$4 = false;
            Intrinsics.checkNotNull((Object)rawConcat);
            v77 = UtilKt.argvSplit(rawConcat, true);
            if (v77 == null) {
                v77 = CollectionsKt.emptyList();
            }
            list$iv$iv = v77;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var31_105 = $this$forEach$iv$iv$iv.iterator();
        while (var31_105.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var31_105.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            raw = (String)element$iv$iv;
            $i$a$-mapNotNull-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$5 = false;
            err /* !! */  = new char[]{'='};
            it = err /* !! */  = (char[])StringsKt.split$default((CharSequence)raw, (char[])err /* !! */ , (boolean)false, (int)2, (int)2, null);
            $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$5$1 = false;
            if ((it.size() == 2 != false ? err /* !! */  : null) == null) {
                v78 = null;
            } else {
                var40_134 = var40_134;
                name = (String)var40_134.get(0);
                value = (String)var40_134.get(1);
                v78 = new EnvironmentVariable.Certain(name, value);
            }
            if (v78 == null) continue;
            it$iv$iv = v78;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        environmentVariables = CollectionsKt.plus((Collection)var44_138, (Iterable)((List)destination$iv$iv));
        var24_48 = AuthMethods.Companion.create(authMethods);
        return new SshConnectionConfig((AuthMethods)var24_48, ciphers, compression, (Duration)connectTimeout, forwardAgent, environmentVariables, host, hostKeyAlgorithms, hostKeyVerifier, identityAgent, initialLocalTcpForwardings, initialRemoteTcpForwardings, kexAlgorithms, macs, port, proxyConfig, serverAlive, user, x11Forwarding);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final SshConnectionConfig addDefaultPrivateKeysIfNeeded(@NotNull SshConnectionConfig $this$addDefaultPrivateKeysIfNeeded) {
        SshConnectionConfig sshConnectionConfig;
        Intrinsics.checkNotNullParameter((Object)$this$addDefaultPrivateKeysIfNeeded, (String)"<this>");
        AuthMethod.PublicKey publicKey = SshConnectionConfigKt.findPublicKey($this$addDefaultPrivateKeysIfNeeded.getAuthMethods());
        if (publicKey != null) {
            AuthMethod.PublicKey it = publicKey;
            boolean bl = false;
            Object[] objectArray = new String[]{"id_rsa", "id_dsa", "id_ecdsa", "id_ed25519", "id_xmss"};
            Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
            File file = Ssh.getHomeSshDirectory().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            List defaultPrivateKeys2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)sequence, (Function1)((Function1)new Function1<String, File>((Object)file){

                @NotNull
                public final File invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return FilesKt.resolve((File)((File)this.receiver), (String)p0);
                }
            })), (Function1)addDefaultPrivateKeysIfNeeded.1.defaultPrivateKeys.2.INSTANCE));
            SshConnectionConfig sshConnectionConfig2 = SshConnectionConfig.copy$default($this$addDefaultPrivateKeysIfNeeded, $this$addDefaultPrivateKeysIfNeeded.getAuthMethods().plus(new AuthMethod.PublicKey(defaultPrivateKeys2, null, 2, null)), null, false, null, false, null, null, null, null, null, null, null, null, null, 0, null, null, null, null, 524286, null);
            if (sshConnectionConfig2 != null) {
                sshConnectionConfig = sshConnectionConfig2;
                return sshConnectionConfig;
            }
        }
        sshConnectionConfig = $this$addDefaultPrivateKeysIfNeeded;
        return sshConnectionConfig;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> parseSeparatedMulti(String[] $this$parseSeparatedMulti, char splitChar, List<String> fallback) {
        String[] stringArray = $this$parseSeparatedMulti;
        if ($this$parseSeparatedMulti == null) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        }
        String[] $this$fold$iv = stringArray;
        boolean $i$f$fold = false;
        List<String> accumulator$iv = fallback;
        int n = $this$fold$iv.length;
        for (int i = 0; i < n; ++i) {
            void str;
            String element$iv;
            String string = element$iv = $this$fold$iv[i];
            List<String> acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = ApplyJschBasedOpenSshConfig.parseSeparated((String)str, splitChar, acc);
        }
        return accumulator$iv;
    }

    private static final List<String> parseSeparated(String $this$parseSeparated, char splitChar, List<String> fallback) {
        List<String> list2;
        Object object = $this$parseSeparated;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            list2 = fallback;
        } else if (StringsKt.startsWith$default((String)$this$parseSeparated, (String)"+", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 43;
            list2 = CollectionsKt.plus((Collection)fallback, (Iterable)ApplyJschBasedOpenSshConfig.parseSeparated(StringsKt.trimStart((String)$this$parseSeparated, (char[])object), splitChar, CollectionsKt.emptyList()));
        } else if (StringsKt.startsWith$default((String)$this$parseSeparated, (String)"-", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 43;
            list2 = CollectionsKt.minus((Iterable)fallback, (Iterable)ApplyJschBasedOpenSshConfig.parseSeparated(StringsKt.trimStart((String)$this$parseSeparated, (char[])object), splitChar, CollectionsKt.emptyList()));
        } else if (StringsKt.startsWith$default((String)$this$parseSeparated, (String)"^", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 94;
            list2 = CollectionsKt.plus((Collection)ApplyJschBasedOpenSshConfig.parseSeparated(StringsKt.trimStart((String)$this$parseSeparated, (char[])object), splitChar, CollectionsKt.emptyList()), (Iterable)fallback);
        } else {
            List<String> list3;
            List<String> it = list3 = ApplyJschBasedOpenSshConfig.parseSeparated($this$parseSeparated, splitChar);
            boolean bl = false;
            list2 = !((Collection)it).isEmpty() ? list3 : null;
            if (list2 == null) {
                list2 = fallback;
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> parseSeparated(String $this$parseSeparated, char splitChar) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        char[] cArray = new char[]{splitChar};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$parseSeparated, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Boolean yesNo(ConfigRepository.Config $this$yesNo, String key) {
        String string;
        String string2 = $this$yesNo.getValue(key);
        if (string2 != null) {
            String string3 = string2.toLowerCase();
            v2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            v2 = string = null;
        }
        return Intrinsics.areEqual((Object)string, (Object)"yes") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)string, (Object)"no") ? Boolean.valueOf(false) : null);
    }

    private static final StrictHostKeyChecking strictHostKeyCheckingFromOpenSshConfigOption(String strictHostKeyCheckingValue) {
        CharSequence charSequence = strictHostKeyCheckingValue;
        if (!(charSequence == null || charSequence.length() == 0)) {
            StrictHostKeyChecking result2;
            String string = strictHostKeyCheckingValue.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            StrictHostKeyChecking strictHostKeyChecking = result2 = (StrictHostKeyChecking)strictHostKeyCheckingMap.get((Object)string);
            if (strictHostKeyChecking != null) {
                return strictHostKeyChecking;
            }
            Set set = strictHostKeyCheckingMap.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            LOG.warn("Unexpected StrictHostKeyChecking=" + strictHostKeyCheckingValue + ". Accepted values are: " + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null) + ".");
        }
        return StrictHostKeyChecking.ASK;
    }

    private static final String unquoteSingleArgumentValue(String $this$unquoteSingleArgumentValue) {
        String string = StringUtil.unquoteString((String)$this$unquoteSingleArgumentValue, (char)'\"');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        return string;
    }

    static {
        SmartFMap smartFMap = SmartFMap.emptyMap().plus((Object)"yes", (Object)StrictHostKeyChecking.YES).plus((Object)"accept-new", (Object)StrictHostKeyChecking.ACCEPT_NEW).plus((Object)"no", (Object)StrictHostKeyChecking.NO).plus((Object)"off", (Object)StrictHostKeyChecking.NO).plus((Object)"ask", (Object)StrictHostKeyChecking.ASK).plus((Object)"true", (Object)StrictHostKeyChecking.YES).plus((Object)"false", (Object)StrictHostKeyChecking.NO);
        Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"plus(...)");
        strictHostKeyCheckingMap = smartFMap;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshConnectionConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthMethod.PublicKey.Agent.values().length];
            try {
                nArray[AuthMethod.PublicKey.Agent.NO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethod.PublicKey.Agent.ONLY_MENTIONED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethod.PublicKey.Agent.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

