/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendLazyTooltipHighlightInfoRequester;
import com.jetbrains.rdclient.document.DocumentExKt;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0014\u0010\u000f\u001a\u00020\b*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendLazyTooltipHighlightInfoRequester;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "()V", "getTargetOffset", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseMoved", "", "e", "selectRangeForTooltipPrecalculation", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "startTooltipPrecalculation", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "range", "intellij.rd.client"})
public final class FrontendLazyTooltipHighlightInfoRequester
implements EditorMouseMotionListener {
    public void mouseMoved(@NotNull EditorMouseEvent e) {
        block4: {
            MarkupModelEx model;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Registry.is((String)"ide.disable.editor.tooltips")) {
                return;
            }
            int offset = this.getTargetOffset(e);
            if (offset == -1) {
                return;
            }
            Editor editor2 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            if (DocumentExKt.getTextControlId(editor2) == null) {
                return;
            }
            Document document = e.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document2, (Project)e.getEditor().getProject(), (boolean)false);
            MarkupModelEx markupModelEx = model = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
            if (markupModelEx != null) {
                this.startTooltipPrecalculation(markupModelEx, new TextRange(offset, offset));
            }
            Editor editor3 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
            TextRange range2 = this.selectRangeForTooltipPrecalculation(editor3, offset);
            MarkupModelEx markupModelEx2 = model;
            if (markupModelEx2 == null) break block4;
            this.startTooltipPrecalculation(markupModelEx2, range2);
        }
    }

    private final void startTooltipPrecalculation(MarkupModelEx $this$startTooltipPrecalculation, TextRange range2) {
        $this$startTooltipPrecalculation.processRangeHighlightersOverlappingWith(range2.getStartOffset(), range2.getEndOffset(), arg_0 -> FrontendLazyTooltipHighlightInfoRequester.startTooltipPrecalculation$lambda$0(startTooltipPrecalculation.1.INSTANCE, arg_0));
    }

    private final TextRange selectRangeForTooltipPrecalculation(Editor editor2, int offset) {
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(offset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition cursorLogicalPosition = logicalPosition;
        int firstLineToPrecalculate = Math.max(cursorLogicalPosition.line - 1, 0);
        int lastLineToPrecalculate = cursorLogicalPosition.line + 2;
        LogicalPosition startPosition = new LogicalPosition(firstLineToPrecalculate, 0);
        LogicalPosition endPosition = new LogicalPosition(lastLineToPrecalculate, 0);
        int startOffset = editor2.logicalPositionToOffset(startPosition);
        int endOffset = editor2.logicalPositionToOffset(endPosition);
        return new TextRange(startOffset, endOffset);
    }

    private final int getTargetOffset(EditorMouseEvent event) {
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Point point = event.getMouseEvent().getPoint();
        if (editor3 instanceof EditorEx && editor3.getProject() != null && event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().getModifiers() == 0 && EditorUtil.isPointOverText((Editor)editor3, (Point)point) && ((EditorEx)editor3).getFoldingModel().getFoldingPlaceholderAt(point) == null) {
            LogicalPosition logicalPosition = editor3.xyToLogicalPosition(point);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            return editor3.logicalPositionToOffset(logicalPosition2);
        }
        return -1;
    }

    private static final boolean startTooltipPrecalculation$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

