/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import com.jetbrains.cloudconfig.auth.AuthProvider;
import com.jetbrains.cloudconfig.auth.NoAuthProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

public class Configuration {
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private int chunkSize = -1;
    private boolean followRedirects = false;
    private AuthProvider authProvider = NoAuthProvider.INSTANCE;
    private Proxy proxy;

    public Configuration connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public Configuration readTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public Configuration chunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public Configuration followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    public Configuration auth(AuthProvider provider) {
        this.authProvider = provider;
        return this;
    }

    public Configuration proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)(this.proxy != null ? url.openConnection(this.proxy) : url.openConnection());
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setInstanceFollowRedirects(this.followRedirects);
        if (this.chunkSize > 0) {
            connection.setChunkedStreamingMode(this.chunkSize);
        }
        this.authProvider.authenticate(connection);
        return connection;
    }
}

