/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.profile.FileAndModule;
import org.jetbrains.qodana.staticAnalysis.profile.ProblemCounters;
import org.jetbrains.qodana.staticAnalysis.profile.SanityInspectionGroupKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014J\"\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u0014J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010#\u001a\u00020\u0014J\u001a\u0010$\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014J\u0006\u0010%\u001a\u00020\u001aR\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters;", "", "project", "Lcom/intellij/openapi/project/Project;", "inspectionToolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "_maxPerFile", "", "_maxPerModule", "_maxPerProject", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInspection/ex/InspectionToolWrapper;III)V", "getInspectionToolWrapper", "()Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "maxPerFile", "maxPerModule", "maxPerProject", "perFile", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/qodana/staticAnalysis/profile/FileAndModule;", "perModule", "", "perProject", "Ljava/util/concurrent/atomic/AtomicInteger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addProblem", "", "relativePath", "module", "constructServiceMessage", "Lorg/jdom/Element;", "file", "message", "constructServiceMessages", "", "id", "isThresholdReached", "wasAnyThresholdReached", "intellij.qodana"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nSanityInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n187#2,3:275\n187#2,3:278\n766#3:281\n857#3,2:282\n1549#3:284\n1620#3,3:285\n766#3:288\n857#3,2:289\n1549#3:291\n1620#3,3:292\n766#3:295\n857#3,2:296\n1549#3:298\n1620#3,3:299\n*S KotlinDebug\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters\n*L\n184#1:275,3\n185#1:278,3\n201#1:281\n201#1:282,2\n201#1:284\n201#1:285,3\n203#1:288\n203#1:289,2\n204#1:291\n204#1:292,3\n217#1:295\n217#1:296,2\n218#1:298\n218#1:299,3\n*E\n"})
public final class ProblemCounters {
    @NotNull
    private final Project project;
    @NotNull
    private final InspectionToolWrapper<?, ?> inspectionToolWrapper;
    @NotNull
    private final ConcurrentHashMap<FileAndModule, Integer> perFile;
    @NotNull
    private final ConcurrentHashMap<String, Integer> perModule;
    @NotNull
    private final AtomicInteger perProject;
    private final int maxPerFile;
    private final int maxPerModule;
    private final int maxPerProject;

    public ProblemCounters(@NotNull Project project2, @NotNull InspectionToolWrapper<?, ?> inspectionToolWrapper, int _maxPerFile, int _maxPerModule, int _maxPerProject) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(inspectionToolWrapper, (String)"inspectionToolWrapper");
        this.project = project2;
        this.inspectionToolWrapper = inspectionToolWrapper;
        this.perFile = new ConcurrentHashMap();
        this.perModule = new ConcurrentHashMap();
        this.perProject = new AtomicInteger(0);
        this.maxPerFile = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerFile);
        this.maxPerModule = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerModule);
        this.maxPerProject = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerProject);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final InspectionToolWrapper<?, ?> getInspectionToolWrapper() {
        return this.inspectionToolWrapper;
    }

    public final boolean addProblem(@Nullable String relativePath, @Nullable String module2) {
        int currentPerModule2;
        Integer n;
        int currentPerFile2;
        Integer n2;
        if (relativePath != null) {
            String string = module2;
            if (string == null) {
                string = "";
            }
            if ((n2 = this.perFile.compute(new FileAndModule(relativePath, string), addProblem.currentPerFile.1.INSTANCE)) == null) {
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        if ((currentPerFile2 = ((Number)n2).intValue()) > this.maxPerFile) {
            return true;
        }
        if (module2 != null) {
            n = this.perModule.compute(module2, addProblem.currentPerModule.1.INSTANCE);
            if (n == null) {
                n = -1;
            }
        } else {
            n = -1;
        }
        if ((currentPerModule2 = ((Number)n).intValue()) > this.maxPerModule) {
            return true;
        }
        int currentPerProject = this.perProject.incrementAndGet();
        return currentPerFile2 >= this.maxPerFile || currentPerModule2 >= this.maxPerModule || currentPerProject >= this.maxPerProject;
    }

    public final boolean isThresholdReached(@Nullable String relativePath, @Nullable String module2) {
        if (this.perProject.get() >= this.maxPerProject) {
            return true;
        }
        if (module2 != null) {
            Integer n = this.perModule.get(module2);
            if (n == null) {
                n = 0;
            }
            if (((Number)n).intValue() >= this.maxPerModule) {
                return true;
            }
        }
        if (relativePath != null) {
            Integer n;
            String string = module2;
            if (string == null) {
                string = "";
            }
            if ((n = this.perFile.get(new FileAndModule(relativePath, string))) == null) {
                n = 0;
            }
            if (((Number)n).intValue() >= this.maxPerFile) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean wasAnyThresholdReached() {
        boolean bl;
        Map.Entry it;
        Map.Entry element$iv;
        Iterator iterator;
        boolean bl2;
        if (this.perProject.get() >= this.maxPerProject) return true;
        Map $this$any$iv = this.perModule;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            bl2 = false;
        } else {
            iterator = $this$any$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv = iterator.next();
                boolean bl3 = false;
                if (((Number)it.getValue()).intValue() >= this.maxPerModule) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = this.perFile;
        $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        iterator = $this$any$iv.entrySet().iterator();
        do {
            if (!iterator.hasNext()) return false;
            it = element$iv = iterator.next();
            boolean bl5 = false;
            if (((Number)it.getValue()).intValue() >= this.maxPerFile) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Element> constructServiceMessages(@NotNull String id) {
        List problems2;
        String message;
        Object[] objectArray;
        Integer counter;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        boolean $i$f$filter;
        Collection<Element> collection;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.perProject.get() >= this.maxPerProject) {
            Object[] objectArray2 = new Object[]{id, this.perProject.get(), this.maxPerProject};
            String string = QodanaBundle.message("inspection.message.inspection.suppressed.on.project", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message2 = string;
            return CollectionsKt.listOf((Object)this.constructServiceMessage(null, null, message2));
        }
        List result = new ArrayList();
        List reportedModules = new ArrayList();
        int moduleThreshold = this.maxPerModule;
        if (moduleThreshold > 0) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry entry;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Set<Map.Entry<String, Integer>> set = this.perModule.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable iterable = set;
            collection = reportedModules;
            boolean $i$f$filter2 = false;
            void var7_11 = $this$filter$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                Integer v = (Integer)entry.getValue();
                Intrinsics.checkNotNull((Object)v);
                if (!(v >= moduleThreshold)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                entry = (Map.Entry)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                String k = (String)entry.getKey();
                Intrinsics.checkNotNull((Object)k);
                collection2.add(k);
            }
            collection.addAll((List)destination$iv$iv2);
            Set<Map.Entry<String, Integer>> set2 = this.perModule.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
            Iterable $i$f$map22 = set2;
            $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry entry2 = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry2);
                Integer v = (Integer)entry2.getValue();
                Intrinsics.checkNotNull((Object)v);
                if (!(v >= moduleThreshold)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map.Entry entry3 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry3);
                String module2 = (String)entry3.getKey();
                counter = (Integer)entry3.getValue();
                objectArray = new Object[]{id, module2, counter, moduleThreshold};
                Intrinsics.checkNotNullExpressionValue((Object)QodanaBundle.message("inspection.message.inspection.suppressed.on.module", objectArray), (String)"message(...)");
                collection.add(this.constructServiceMessage(null, module2, message));
            }
            problems2 = (List)destination$iv$iv;
            result.addAll(problems2);
        }
        Set<Map.Entry<FileAndModule, Integer>> set = this.perFile.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        $this$map$iv = set;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            FileAndModule k = (FileAndModule)entry.getKey();
            Integer v = (Integer)entry.getValue();
            Intrinsics.checkNotNull((Object)v);
            if (!(v >= this.maxPerFile && !reportedModules.contains(k.getModule()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            FileAndModule file = (FileAndModule)entry.getKey();
            counter = (Integer)entry.getValue();
            objectArray = new Object[]{id, file.getFile(), counter, this.maxPerFile};
            Intrinsics.checkNotNullExpressionValue((Object)QodanaBundle.message("inspection.message.inspection.suppressed.on.file", objectArray), (String)"message(...)");
            collection.add(this.constructServiceMessage(file.getFile(), file.getModule(), message));
        }
        problems2 = (List)destination$iv$iv;
        result.addAll(problems2);
        return result;
    }

    @NotNull
    public final Element constructServiceMessage(@Nullable String file, @Nullable String module2, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Element element2 = new Element("problem");
        if (file != null) {
            element2.addContent(new Element("file").addContent(file));
        }
        if (module2 != null) {
            element2.addContent(new Element("module").addContent(module2));
        }
        Element problem_class = new Element("problem_class").setAttribute("severity", "ERROR").setAttribute("id", "QodanaServiceMessage").setAttribute("attribute_key", "-").addContent("Qodana service message");
        element2.addContent(problem_class);
        Element entry_point = new Element("entry_point");
        if (file != null) {
            entry_point.setAttribute("TYPE", "file");
            entry_point.setAttribute("FQNAME", file);
        } else if (module2 != null) {
            entry_point.setAttribute("TYPE", "module");
            entry_point.setAttribute("FQNAME", module2);
        } else {
            entry_point.setAttribute("TYPE", "project");
            entry_point.setAttribute("FQNAME", this.project.getName());
        }
        element2.addContent(entry_point);
        element2.addContent(new Element("description").addContent(message));
        return element2;
    }
}

