/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.script;

import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaScriptConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaInspectionApplication;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaRunContext;
import org.jetbrains.qodana.staticAnalysis.script.QodanaApplicationScript;
import org.jetbrains.qodana.staticAnalysis.script.UnvalidatedParameters;

@ApiStatus.Internal
public interface QodanaApplicationScriptFactory {
    public static final ExtensionPointName<QodanaApplicationScriptFactory> EP_NAME = ExtensionPointName.create((String)"org.intellij.qodana.qodanaScriptFactory");

    @NotNull
    public String getScriptName();

    @NotNull
    public QodanaApplicationScript createScript(@NotNull QodanaInspectionApplication var1, @NotNull QodanaRunContext var2, @NotNull UnvalidatedParameters var3);

    @NotNull
    public Map<String, String> parseParameters(@NotNull String var1);

    @Nullable
    public static QodanaApplicationScriptFactory findFactory(@NotNull QodanaInspectionApplication qodanaApplication, @NotNull String scriptName) {
        if (qodanaApplication == null) {
            QodanaApplicationScriptFactory.$$$reportNull$$$0(0);
        }
        if (scriptName == null) {
            QodanaApplicationScriptFactory.$$$reportNull$$$0(1);
        }
        String scriptToExecute = scriptName;
        if (qodanaApplication.getConfig().getAnalyzeChanges()) {
            qodanaApplication.reportMessage(1, "Consider using '--script local-changes' instead of '--changes'");
            scriptToExecute = "local-changes";
        }
        for (QodanaApplicationScriptFactory factory : EP_NAME.getExtensionList()) {
            if (!QodanaApplicationScriptFactory.isMatchingName(scriptToExecute, factory)) continue;
            return factory;
        }
        return null;
    }

    @Nullable
    public static QodanaScriptConfig parseConfigFromArgument(@NotNull String argument) {
        if (argument == null) {
            QodanaApplicationScriptFactory.$$$reportNull$$$0(2);
        }
        for (QodanaApplicationScriptFactory factory : EP_NAME.getExtensionList()) {
            String scriptName = factory.getScriptName();
            if (!argument.startsWith(scriptName)) continue;
            String afterName = argument.substring(scriptName.length());
            if (afterName.isEmpty()) {
                return new QodanaScriptConfig(scriptName, factory.parseParameters(""));
            }
            if (!afterName.startsWith(":")) continue;
            String parameters = afterName.substring(1);
            if (parameters.isEmpty()) {
                throw new QodanaException("Script parameters in '--script " + argument + "' must not be empty");
            }
            return new QodanaScriptConfig(scriptName, factory.parseParameters(parameters));
        }
        return null;
    }

    private static boolean isMatchingName(@NotNull String scriptName, @NotNull QodanaApplicationScriptFactory factory) {
        if (scriptName == null) {
            QodanaApplicationScriptFactory.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            QodanaApplicationScriptFactory.$$$reportNull$$$0(4);
        }
        return scriptName.toLowerCase(Locale.ROOT).equals(factory.getScriptName().toLowerCase(Locale.ROOT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qodanaApplication";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/qodana/staticAnalysis/script/QodanaApplicationScriptFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseConfigFromArgument";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatchingName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

