/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/kinference/ndarray/arrays/Strides;", "", "shape", "", "([I)V", "linearSize", "", "getLinearSize", "()I", "getShape", "()[I", "strides", "getStrides", "equals", "", "other", "hashCode", "index", "offset", "transpose", "permutations", "Companion", "ndarray-api"})
@SourceDebugExtension(value={"SMAP\nStrides.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strides.kt\nio/kinference/ndarray/arrays/Strides\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n13201#2,7:57\n12895#2,4:64\n1#3:68\n*S KotlinDebug\n*F\n+ 1 Strides.kt\nio/kinference/ndarray/arrays/Strides\n*L\n7#1:57,7\n15#1:64,4\n*E\n"})
public final class Strides {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] shape;
    @NotNull
    private final int[] strides;
    private final int linearSize;
    @NotNull
    private static final Strides EMPTY = new Strides(new int[0]);

    /*
     * WARNING - void declaration
     */
    public Strides(@NotNull int[] shape) {
        void $this$foldRightIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.shape = shape;
        this.strides = new int[this.shape.length];
        int[] nArray = this.shape;
        boolean initial$iv = true;
        boolean $i$f$foldRightIndexed = false;
        int index$iv = ArraysKt.getLastIndex((int[])$this$foldRightIndexed$iv);
        boolean accumulator$iv = initial$iv;
        while (index$iv >= 0) {
            void i;
            void acc;
            boolean bl = accumulator$iv;
            void var8_8 = $this$foldRightIndexed$iv[index$iv];
            int index = index$iv--;
            boolean bl2 = false;
            this.strides[index] = acc;
            accumulator$iv = acc * i;
        }
        this.linearSize = this.shape.length == 0 ? 1 : this.strides[0] * this.shape[0];
    }

    @NotNull
    public final int[] getShape() {
        return this.shape;
    }

    @NotNull
    public final int[] getStrides() {
        return this.strides;
    }

    /*
     * WARNING - void declaration
     */
    public final int offset(@NotNull int[] index) {
        void $this$foldIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        int[] nArray = index;
        int initial$iv = 0;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n = index$iv++;
            void var10_10 = element$iv;
            int n2 = accumulator$iv;
            int ind = n;
            boolean bl = false;
            accumulator$iv = acc + i * this.strides[ind];
        }
        return accumulator$iv;
    }

    @NotNull
    public final int[] index(int offset) {
        if (!(0 <= offset ? offset < this.linearSize : false)) {
            boolean $i$a$-require-Strides$index$22 = false;
            String $i$a$-require-Strides$index$22 = "Offset " + offset + " out of buffer bounds: (0, " + (this.linearSize - 1) + ")";
            throw new IllegalArgumentException($i$a$-require-Strides$index$22.toString());
        }
        int[] res2 = new int[this.shape.length];
        int current = offset;
        int[] nArray = this.strides;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            int stride = nArray[i];
            res2[index] = current / stride;
            current %= stride;
        }
        return res2;
    }

    @NotNull
    public final Strides transpose(@NotNull int[] permutations) {
        Intrinsics.checkNotNullParameter((Object)permutations, (String)"permutations");
        int[] newShape = new int[this.shape.length];
        int n = permutations.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            int axis2 = permutations[i];
            newShape[i2] = this.shape[axis2];
        }
        return new Strides(newShape);
    }

    public final int getLinearSize() {
        return this.linearSize;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strides)) {
            return false;
        }
        return Arrays.equals(this.shape, ((Strides)other).shape);
    }

    public int hashCode() {
        return Arrays.hashCode(this.shape);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/kinference/ndarray/arrays/Strides$Companion;", "", "()V", "EMPTY", "Lio/kinference/ndarray/arrays/Strides;", "getEMPTY", "()Lio/kinference/ndarray/arrays/Strides;", "ndarray-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Strides getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

