/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.pointers.IntPointerKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0002\u0010\fJ,\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0000J\u0016\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\"\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u00032\b\b\u0002\u0010\"\u001a\u00020\u0003J\u0011\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0086\u0002J\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030&2\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000J\u0010\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u0003J\u0019\u0010,\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0086\u0002J\u0006\u0010-\u001a\u00020\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006/"}, d2={"Lio/kinference/ndarray/arrays/tiled/IntTiledArray;", "", "size", "", "blockSize", "(II)V", "blocks", "", "", "([[I)V", "init", "Lkotlin/Function1;", "(IILkotlin/jvm/functions/Function1;)V", "getBlockSize", "()I", "getBlocks", "()[[I", "[[I", "blocksNum", "getBlocksNum", "getSize", "copyInto", "", "dest", "destOffset", "srcStart", "srcEnd", "copyOf", "copyOfRange", "fromIndex", "toIndex", "fill", "value", "from", "to", "get", "i", "indexFor", "Lkotlin/Pair;", "plus", "other", "pointer", "Lio/kinference/ndarray/arrays/pointers/IntPointer;", "startIndex", "set", "toArray", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nIntTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntTiledArray.kt\nio/kinference/ndarray/arrays/tiled/IntTiledArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IntPointer.kt\nio/kinference/ndarray/arrays/pointers/IntPointerKt\n*L\n1#1,183:1\n1#2:184\n1#2:186\n1#2:218\n1019#3:185\n1021#3,30:187\n1019#3:217\n1021#3,30:219\n*S KotlinDebug\n*F\n+ 1 IntTiledArray.kt\nio/kinference/ndarray/arrays/tiled/IntTiledArray\n*L\n142#1:186\n148#1:218\n142#1:185\n142#1:187,30\n148#1:217\n148#1:219,30\n*E\n"})
public final class IntTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private final int[][] blocks;

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final int[][] getBlocks() {
        return this.blocks;
    }

    public IntTiledArray(int size2, int blockSize) {
        if (blockSize != 0 && !(size2 % blockSize == 0)) {
            boolean bl = false;
            String string = "Size must divide blockSize";
            throw new IllegalArgumentException(string.toString());
        }
        this.blocksNum = blockSize == 0 ? 0 : size2 / blockSize;
        int n = 0;
        int n2 = this.blocksNum;
        int[][] nArrayArray = new int[n2][];
        IntTiledArray intTiledArray = this;
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[blockSize];
        }
        intTiledArray.blocks = nArrayArray;
        this.blockSize = blockSize;
        this.size = size2;
    }

    public IntTiledArray(@NotNull int[][] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = ((Object[])blocks).length == 0 ? 0 : ((int[])ArraysKt.first((Object[])((Object[])blocks))).length;
        this.blocksNum = ((Object[])blocks).length;
        this.size = this.blocksNum * this.blockSize;
    }

    public IntTiledArray(int size2, int blockSize, @NotNull Function1<? super Integer, Integer> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(size2, blockSize);
        int count = 0;
        int[][] nArray = this.blocks;
        int n = ((Object[])nArray).length;
        for (int i = 0; i < n; ++i) {
            int[] block = nArray[i];
            for (int idx = 0; idx < blockSize; ++idx) {
                block[idx] = ((Number)init.invoke((Object)count++)).intValue();
            }
        }
    }

    @NotNull
    public final IntPointer pointer(int startIndex2) {
        return new IntPointer(this, startIndex2);
    }

    public static /* synthetic */ IntPointer pointer$default(IntTiledArray intTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return intTiledArray.pointer(n);
    }

    @NotNull
    public final int[] toArray() {
        if (this.size == 0) {
            return new int[0];
        }
        int[] array = new int[this.size];
        int offset = 0;
        int[][] nArray = this.blocks;
        int n = ((Object[])nArray).length;
        for (int i = 0; i < n; ++i) {
            int[] block = nArray[i];
            ArraysKt.copyInto$default((int[])block, (int[])array, (int)offset, (int)0, (int)0, (int)12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    public final int get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx][blockOff];
    }

    public final void set(int i, int value) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx][blockOff] = value;
    }

    @NotNull
    public final IntTiledArray copyOf() {
        IntTiledArray copyArray = new IntTiledArray(this.size, this.blockSize);
        int n = this.blocksNum;
        for (int blockNum = 0; blockNum < n; ++blockNum) {
            int[] thisBlock = this.blocks[blockNum];
            int[] destBlock = copyArray.blocks[blockNum];
            ArraysKt.copyInto$default((int[])thisBlock, (int[])destBlock, (int)0, (int)0, (int)0, (int)14, null);
        }
        return copyArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull IntTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        IntPointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        IntPointer thisPtr = new IntPointer(this, srcStart);
        IntPointer intPointer = destPtr = new IntPointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!IntPointerKt.isCompatibleBySize((IntPointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-IntPointerKt$accept$3$iv22 = false;
            String $i$a$-require-IntPointerKt$accept$3$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-IntPointerKt$accept$3$iv22.toString());
        }
        if (IntPointerKt.isCompatibleWith((IntPointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            int[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                int[] srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    int cfr_ignored_0 = dstBlock$iv[index$iv];
                    int n2 = srcBlock$iv[index$iv];
                    int n3 = index$iv++;
                    int[] nArray = dstBlock$iv;
                    boolean bl = false;
                    void var20_26 = src;
                    nArray[n3] = var20_26;
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                int src = thisPtr.getAndIncrement();
                void var18_23 = $this$accept$iv;
                boolean bl = false;
                int n = src;
                var18_23.set(n);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(IntTiledArray intTiledArray, IntTiledArray intTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = intTiledArray.size;
        }
        intTiledArray.copyInto(intTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntTiledArray plus(@NotNull IntTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntPointer thisPtr = new IntPointer(this, 0, 2, null);
        IntPointer destPtr = new IntPointer(other, 0, 2, null);
        IntPointer intPointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!IntPointerKt.isCompatibleBySize((IntPointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-IntPointerKt$accept$3$iv22 = false;
            String $i$a$-require-IntPointerKt$accept$3$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-IntPointerKt$accept$3$iv22.toString());
        }
        if (IntPointerKt.isCompatibleWith((IntPointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            int[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                int[] srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    int n2 = srcBlock$iv[index$iv];
                    int n3 = dstBlock$iv[index$iv];
                    int n4 = index$iv++;
                    int[] nArray = dstBlock$iv;
                    boolean bl = false;
                    void var18_25 = src + dst;
                    nArray[n4] = var18_25;
                }
            }
        } else {
            while (end$iv > 0) {
                int dst = destPtr.getAndIncrement();
                int src = $this$accept$iv.get();
                void var16_22 = $this$accept$iv;
                boolean bl = false;
                int n = src + dst;
                var16_22.set(n);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final int[] copyOfRange(int fromIndex, int toIndex) {
        int[] array = new int[toIndex - fromIndex];
        IntPointer pointer = new IntPointer(this, fromIndex);
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = pointer.getAndIncrement();
        }
        return array;
    }

    public final void fill(int value, int from, int to) {
        if (from == to) {
            return;
        }
        IntPointer pointer = new IntPointer(this, from);
        for (int count = to - from; count > 0; count -= this.blockSize) {
            int[] block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            ArraysKt.fill((int[])block, (int)value, (int)offset, (int)Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(IntTiledArray intTiledArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = intTiledArray.size;
        }
        intTiledArray.fill(n, n2, n3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002J\"\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\u000e"}, d2={"Lio/kinference/ndarray/arrays/tiled/IntTiledArray$Companion;", "", "()V", "invoke", "Lio/kinference/ndarray/arrays/tiled/IntTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "init", "Lkotlin/Function1;", "", "array", "", "shape", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nIntTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntTiledArray.kt\nio/kinference/ndarray/arrays/tiled/IntTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntTiledArray invoke(@NotNull Strides strides2) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new IntTiledArray(strides2.getLinearSize(), blockSize);
        }

        @NotNull
        public final IntTiledArray invoke(@NotNull Strides strides2, @NotNull Function1<? super Integer, Integer> init) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new IntTiledArray(strides2.getLinearSize(), blockSize, init);
        }

        @NotNull
        public final IntTiledArray invoke(@NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return this.invoke(new Strides(shape));
        }

        @NotNull
        public final IntTiledArray invoke(@NotNull int[] shape, @NotNull Function1<? super Integer, Integer> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(new Strides(shape), init);
        }

        @NotNull
        public final IntTiledArray invoke(@NotNull Strides strides2, @NotNull int[] array) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            int countBlocks = array.length / blockSize;
            int n = 0;
            int[][] nArrayArray = new int[countBlocks][];
            while (n < countBlocks) {
                int n2 = n++;
                nArrayArray[n2] = new int[blockSize];
            }
            int[][] blocksArray = nArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                ArraysKt.copyInto$default((int[])array, (int[])blocksArray[blockNum], (int)0, (int)(blockNum * blockSize), (int)((blockNum + 1) * blockSize), (int)2, null);
            }
            return new IntTiledArray(blocksArray);
        }

        @NotNull
        public final IntTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, Integer> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-IntTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-IntTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-IntTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            int[][] nArrayArray = new int[blocksNum][];
            while (n < blocksNum) {
                int n2 = n++;
                nArrayArray[n2] = new int[blockSize];
            }
            int[][] blocks = nArrayArray;
            int n3 = ((Object[])blocks).length;
            for (n = 0; n < n3; ++n) {
                int[] block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block[idx] = ((Number)init.invoke((Object)count++)).intValue();
                }
            }
            return new IntTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

