/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.intellij.plugins.markdown.editor.tables.TableUtils$special$;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u001f\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0015\u0010)\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b*J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004H\u0007J\u0011\u0010/\u001a\u000200*\u00020\u001aH\u0000\u00a2\u0006\u0002\b1J\u0012\u00102\u001a\u000203*\u00020\u00052\u0006\u00104\u001a\u00020\u0004J\"\u00105\u001a\b\u0012\u0004\u0012\u00020\u001006*\u00020\u00052\u0006\u00107\u001a\u00020\u00042\b\b\u0002\u00108\u001a\u00020\u0014J\u0018\u00109\u001a\b\u0012\u0004\u0012\u00020006*\u00020\u00052\u0006\u00107\u001a\u00020\u0004R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\n\u001a\u00020\u000b*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\u0004*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0015\u0010\u0016\u001a\u00020\u0014*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0015\u0010\u0017\u001a\u00020\u0004*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006:"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableUtils;", "", "()V", "columnsCount", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "getColumnsCount", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;)I", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;)I", "columnsIndices", "Lkotlin/ranges/IntRange;", "getColumnsIndices", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;)Lkotlin/ranges/IntRange;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;)Lkotlin/ranges/IntRange;", "firstNonWhitespaceOffset", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "getFirstNonWhitespaceOffset", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;)I", "isHeaderRow", "", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;)Z", "isLast", "lastNonWhitespaceOffset", "getLastNonWhitespaceOffset", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "getSeparatorRow", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;)Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "findCell", "element", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "findCellIndex", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "findRow", "findRowOrSeparator", "findSeparatorRow", "findTable", "isFormattingOnTypeEnabledForTables", "isFormattingOnTypeEnabledForTables$intellij_markdown_core", "isProbablyInsideTableCell", "document", "Lcom/intellij/openapi/editor/Document;", "caretOffset", "calculateActualTextRange", "Lcom/intellij/openapi/util/TextRange;", "calculateActualTextRange$intellij_markdown_core", "getColumnAlignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "columnIndex", "getColumnCells", "", "index", "withHeader", "getColumnTextRanges", "intellij.markdown.core"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nTableUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableUtils.kt\norg/intellij/plugins/markdown/editor/tables/TableUtils\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,192:1\n61#2:193\n61#2:194\n61#2:195\n61#2:196\n1603#3,9:197\n1855#3:206\n1856#3:208\n1612#3:209\n1549#3:210\n1620#3,3:211\n1#4:207\n1#4:214\n473#5:215\n1268#5,3:216\n151#6,6:219\n163#6,6:225\n151#6,6:231\n163#6,6:237\n*S KotlinDebug\n*F\n+ 1 TableUtils.kt\norg/intellij/plugins/markdown/editor/tables/TableUtils\n*L\n38#1:193\n49#1:194\n60#1:195\n71#1:196\n106#1:197,9\n106#1:206\n106#1:208\n106#1:209\n110#1:210\n110#1:211,3\n106#1:207\n118#1:215\n127#1:216,3\n143#1:219,6\n146#1:225,6\n183#1:231,6\n184#1:237,6\n*E\n"})
public final class TableUtils {
    @NotNull
    public static final TableUtils INSTANCE = new TableUtils();

    private TableUtils() {
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableCell findCell(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement element2 = psiElement;
        IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
        if (PsiUtilsKt.hasType(element2, iElementType) && !(element2 instanceof MarkdownTableSeparatorRow) && Intrinsics.areEqual((Object)element2.getText(), (Object)"|")) {
            PsiElement psiElement2 = element2.getPrevSibling();
            return psiElement2 instanceof MarkdownTableCell ? (MarkdownTableCell)psiElement2 : null;
        }
        return TableUtils.findCell(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableCell findCell(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableCell)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableCell.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTable findTable(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement element2 = psiElement;
        return TableUtils.findTable(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTable findTable(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTable)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTable.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableSeparatorRow findSeparatorRow(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement element2 = psiElement;
        return TableUtils.findSeparatorRow(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableSeparatorRow findSeparatorRow(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableSeparatorRow)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableSeparatorRow.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableRow findRow(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement element2 = psiElement;
        return TableUtils.findRow(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableRow findRow(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableRow)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableRow.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findRowOrSeparator(@NotNull PsiFile file, int offset) {
        MarkdownTableRow row;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MarkdownTableRow markdownTableRow = row = TableUtils.findRow(file, offset);
        return markdownTableRow != null ? (PsiElement)markdownTableRow : (PsiElement)TableUtils.findSeparatorRow(file, offset);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findRowOrSeparator(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownTableRow markdownTableRow = TableUtils.findRow(element2);
        return markdownTableRow != null ? (PsiElement)markdownTableRow : (PsiElement)TableUtils.findSeparatorRow(element2);
    }

    @JvmStatic
    @Nullable
    public static final Integer findCellIndex(@NotNull PsiFile file, int offset) {
        PsiElement parent;
        Object v4;
        block2: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
            PsiElement element2 = psiElement;
            IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
            if (PsiUtilsKt.hasType(element2, iElementType) && !(element2 instanceof MarkdownTableSeparatorRow) && Intrinsics.areEqual((Object)element2.getText(), (Object)"|")) {
                PsiElement psiElement2 = element2.getPrevSibling();
                MarkdownTableCell markdownTableCell = psiElement2 instanceof MarkdownTableCell ? (MarkdownTableCell)psiElement2 : null;
                return markdownTableCell != null ? Integer.valueOf(markdownTableCell.getColumnIndex()) : null;
            }
            Sequence sequence = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                IElementType iElementType2 = MarkdownElementTypes.TABLE_CELL;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"TABLE_CELL");
                if (!(PsiUtilsKt.hasType(it, iElementType2) || it instanceof MarkdownTableSeparatorRow)) continue;
                v4 = e;
                break block2;
            }
            v4 = null;
        }
        PsiElement psiElement = parent = (PsiElement)v4;
        return psiElement instanceof MarkdownTableSeparatorRow ? ((MarkdownTableSeparatorRow)parent).getColumnIndexFromOffset(offset) : (psiElement instanceof MarkdownTableCell ? Integer.valueOf(((MarkdownTableCell)parent).getColumnIndex()) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownTableCell> getColumnCells(@NotNull MarkdownTable $this$getColumnCells, int index, boolean withHeader) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getColumnCells, (String)"<this>");
        List<MarkdownTableRow> list2 = $this$getColumnCells.getRows(withHeader);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRows(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MarkdownTableCell it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownTableRow it = (MarkdownTableRow)element$iv$iv;
            boolean bl2 = false;
            if (it.getCell(index) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getColumnCells$default(TableUtils tableUtils, MarkdownTable markdownTable, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return tableUtils.getColumnCells(markdownTable, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> getColumnTextRanges(@NotNull MarkdownTable $this$getColumnTextRanges, int index) {
        ArrayList<TextRange> result2;
        block1: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getColumnTextRanges, (String)"<this>");
            Iterable $this$map$iv = this.getColumnCells($this$getColumnTextRanges, index, true);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTextRange());
            }
            List cells = (List)destination$iv$iv;
            result2 = new ArrayList<TextRange>(cells.size() + 1);
            result2.addAll(cells);
            MarkdownTableSeparatorRow markdownTableSeparatorRow = this.getSeparatorRow($this$getColumnTextRanges);
            if (markdownTableSeparatorRow == null) break block1;
            MarkdownTableSeparatorRow it = markdownTableSeparatorRow;
            boolean bl = false;
            result2.add(it.getTextRange());
        }
        return result2;
    }

    @Nullable
    public final MarkdownTableSeparatorRow getSeparatorRow(@NotNull MarkdownTable $this$separatorRow) {
        Intrinsics.checkNotNullParameter((Object)$this$separatorRow, (String)"<this>");
        PsiElement psiElement = $this$separatorRow.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)special$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (MarkdownTableSeparatorRow)SequencesKt.firstOrNull((Sequence)sequence);
    }

    public final boolean isHeaderRow(@NotNull MarkdownTableRow $this$isHeaderRow) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isHeaderRow, (String)"<this>");
            Sequence sequence = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)$this$isHeaderRow), (boolean)false, (boolean)false);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!(it instanceof MarkdownTableRow)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 == null;
    }

    public final boolean isLast(@NotNull MarkdownTableRow $this$isLast) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isLast, (String)"<this>");
            Sequence sequence = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)$this$isLast), (boolean)true, (boolean)false);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!(it instanceof MarkdownTableRow)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 == null;
    }

    public final int getColumnsCount(@NotNull MarkdownTableRow $this$columnsCount) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$columnsCount, (String)"<this>");
        PsiElement psiElement = $this$columnsCount.getFirstChild();
        if (psiElement != null && (psiElement = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true)) != null) {
            PsiElement $this$count$iv = psiElement;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof MarkdownTableCell) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        } else {
            n = 0;
        }
        return n;
    }

    public final int getColumnsCount(@NotNull MarkdownTable $this$columnsCount) {
        Intrinsics.checkNotNullParameter((Object)$this$columnsCount, (String)"<this>");
        MarkdownTableRow markdownTableRow = $this$columnsCount.getHeaderRow();
        return markdownTableRow != null ? this.getColumnsCount(markdownTableRow) : 0;
    }

    @NotNull
    public final IntRange getColumnsIndices(@NotNull MarkdownTable $this$columnsIndices) {
        Intrinsics.checkNotNullParameter((Object)$this$columnsIndices, (String)"<this>");
        return RangesKt.until((int)0, (int)this.getColumnsCount($this$columnsIndices));
    }

    @NotNull
    public final IntRange getColumnsIndices(@NotNull MarkdownTableRow $this$columnsIndices) {
        Intrinsics.checkNotNullParameter((Object)$this$columnsIndices, (String)"<this>");
        return RangesKt.until((int)0, (int)this.getColumnsCount($this$columnsIndices));
    }

    @NotNull
    public final MarkdownTableSeparatorRow.CellAlignment getColumnAlignment(@NotNull MarkdownTable $this$getColumnAlignment, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getColumnAlignment, (String)"<this>");
        MarkdownTableSeparatorRow markdownTableSeparatorRow = this.getSeparatorRow($this$getColumnAlignment);
        MarkdownTableSeparatorRow.CellAlignment cellAlignment = markdownTableSeparatorRow != null ? markdownTableSeparatorRow.getCellAlignment(columnIndex) : null;
        Intrinsics.checkNotNull((Object)((Object)cellAlignment));
        return cellAlignment;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFirstNonWhitespaceOffset(@NotNull MarkdownTableCell $this$firstNonWhitespaceOffset) {
        int n;
        int n2;
        block1: {
            void $this$indexOfFirst$iv;
            Intrinsics.checkNotNullParameter((Object)$this$firstNonWhitespaceOffset, (String)"<this>");
            int n3 = UtilsKt.getStartOffset((PsiElement)((PsiElement)$this$firstNonWhitespaceOffset));
            String string = $this$firstNonWhitespaceOffset.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = string;
            n2 = n3;
            boolean $i$f$indexOfFirst = false;
            int n4 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n4; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != ' ')) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int n5 = n;
        return n2 + RangesKt.coerceAtLeast((int)n5, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public final int getLastNonWhitespaceOffset(@NotNull MarkdownTableCell $this$lastNonWhitespaceOffset) {
        int n;
        int n2;
        block2: {
            void $this$indexOfLast$iv;
            Intrinsics.checkNotNullParameter((Object)$this$lastNonWhitespaceOffset, (String)"<this>");
            int n3 = UtilsKt.getStartOffset((PsiElement)((PsiElement)$this$lastNonWhitespaceOffset));
            String string = $this$lastNonWhitespaceOffset.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = string;
            n2 = n3;
            boolean $i$f$indexOfLast = false;
            int n4 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n4) {
                do {
                    int index$iv = n4--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it != ' ')) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n4);
            }
            n = -1;
        }
        int n5 = n;
        return n2 + RangesKt.coerceAtLeast((int)n5, (int)0);
    }

    @JvmStatic
    public static final boolean isProbablyInsideTableCell(@NotNull Document document, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (caretOffset == 0) {
            return false;
        }
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text2 = charSequence;
        int lineNumber = document.getLineNumber(caretOffset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        boolean leftBarFound = false;
        int offset = caretOffset - 1;
        if (lineStartOffset <= offset) {
            while (true) {
                if (text2.charAt(offset) == '|') {
                    leftBarFound = true;
                    break;
                }
                if (offset == lineStartOffset) break;
                --offset;
            }
        }
        for (offset = caretOffset; offset < lineEndOffset; ++offset) {
            if (text2.charAt(offset) != '|') continue;
            return leftBarFound;
        }
        return false;
    }

    public final boolean isFormattingOnTypeEnabledForTables$intellij_markdown_core(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getReformatTablesOnType() && !CodeStyle.getSettings((PsiFile)file).getExcludedFiles().contains(file);
    }

    @NotNull
    public final TextRange calculateActualTextRange$intellij_markdown_core(@NotNull MarkdownTableSeparatorRow $this$calculateActualTextRange) {
        int n;
        int first;
        block4: {
            int n2;
            int n3;
            String text2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$calculateActualTextRange, (String)"<this>");
                String string = $this$calculateActualTextRange.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                text2 = string;
                CharSequence $this$indexOfFirst$iv = text2;
                boolean $i$f$indexOfFirst = false;
                n3 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n3; ++index$iv) {
                    char it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it) && it != '>')) continue;
                    n2 = index$iv;
                    break block3;
                }
                n2 = -1;
            }
            first = n2;
            CharSequence $this$indexOfLast$iv = text2;
            boolean $i$f$indexOfLast = false;
            n3 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n3) {
                do {
                    int index$iv = n3--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    n = index$iv;
                    break block4;
                } while (0 <= n3);
            }
            n = -1;
        }
        int last = n;
        int end = last == -1 ? $this$calculateActualTextRange.getTextLength() : last + 1;
        TextRange textRange = new TextRange(RangesKt.coerceAtLeast((int)first, (int)0), end).shiftRight($this$calculateActualTextRange.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        return textRange;
    }
}

