/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownBlocks;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.EmphasisFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownRangedFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownWrappingFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fJ@\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fJ\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownBlocks;", "", "()V", "emphasisLikeElements", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "create", "Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "align", "Lkotlin/Function1;", "Lcom/intellij/formatting/Alignment;", "Lkotlin/sequences/Sequence;", "nodes", "filterFromWhitespaces", "sequence", "isInsideBlockquote", "", "shouldWrapInsideBlockquote", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownBlocks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownBlocks.kt\norg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownBlocks\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,75:1\n1247#2,2:76\n*S KotlinDebug\n*F\n+ 1 MarkdownBlocks.kt\norg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownBlocks\n*L\n54#1:76,2\n*E\n"})
public final class MarkdownBlocks {
    @NotNull
    public static final MarkdownBlocks INSTANCE = new MarkdownBlocks();
    @NotNull
    private static final TokenSet emphasisLikeElements;

    private MarkdownBlocks() {
    }

    @NotNull
    public final Sequence<MarkdownFormattingBlock> create(@NotNull Sequence<? extends ASTNode> nodes, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Function1<? super ASTNode, ? extends Alignment> align) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter(align, (String)"align");
        return SequencesKt.map(this.filterFromWhitespaces(nodes), (Function1)((Function1)new Function1<ASTNode, MarkdownFormattingBlock>(settings, spacing, align){
            final /* synthetic */ CodeStyleSettings $settings;
            final /* synthetic */ SpacingBuilder $spacing;
            final /* synthetic */ Function1<ASTNode, Alignment> $align;
            {
                this.$settings = $settings;
                this.$spacing = $spacing;
                this.$align = $align;
                super(1);
            }

            @NotNull
            public final MarkdownFormattingBlock invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MarkdownBlocks.INSTANCE.create(it, this.$settings, this.$spacing, this.$align);
            }
        }));
    }

    @NotNull
    public final MarkdownFormattingBlock create(@NotNull ASTNode node, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Function1<? super ASTNode, ? extends Alignment> align) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter(align, (String)"align");
        IElementType iElementType = node.getElementType();
        return ((MarkdownTokenTypeSets.LIST_MARKERS.contains(iElementType) ? true : MarkdownTokenTypeSets.WHITE_SPACES.contains(iElementType)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BLOCK_QUOTE)) ? (MarkdownFormattingBlock)MarkdownRangedFormattingBlock.Companion.trimmed(node, settings, spacing, (Alignment)align.invoke((Object)node), null) : (emphasisLikeElements.contains(iElementType) ? (MarkdownFormattingBlock)new EmphasisFormattingBlock(settings, spacing, node, (Alignment)align.invoke((Object)node)) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) ? (this.isInsideBlockquote(node) && !this.shouldWrapInsideBlockquote(settings) ? new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), null, 16, null) : (MarkdownFormattingBlock)new MarkdownWrappingFormattingBlock(settings, spacing, node, (Alignment)align.invoke((Object)node), null, 16, null)) : new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), null, 16, null)));
    }

    private final boolean isInsideBlockquote(ASTNode node) {
        boolean bl;
        block1: {
            Sequence<ASTNode> $this$any$iv = AstUtilsKt.parents(node, false);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                IElementType iElementType = MarkdownTokenTypeSets.BLOCK_QUOTE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"BLOCK_QUOTE");
                if (!AstUtilsKt.hasType(it, iElementType)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean shouldWrapInsideBlockquote(CodeStyleSettings settings) {
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(MarkdownCustomCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        MarkdownCustomCodeStyleSettings customSettings = (MarkdownCustomCodeStyleSettings)customCodeStyleSettings;
        return customSettings.WRAP_TEXT_IF_LONG && customSettings.WRAP_TEXT_INSIDE_BLOCKQUOTES;
    }

    @NotNull
    public final Sequence<ASTNode> filterFromWhitespaces(@NotNull Sequence<? extends ASTNode> sequence) {
        Intrinsics.checkNotNullParameter(sequence, (String)"sequence");
        return SequencesKt.filter(sequence, (Function1)filterFromWhitespaces.1.INSTANCE);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{MarkdownElementTypes.EMPH, MarkdownElementTypes.STRONG, MarkdownElementTypes.STRIKETHROUGH};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        emphasisLikeElements = tokenSet;
    }
}

