/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexAuthException;
import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.download.SharedIndexDownloadJson;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.download.SharedIndexListLookup;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexNetworkCache;
import com.intellij.indexing.shared.download.SharedIndexNetworkCacheScope;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0004\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JX\u0010\u0016\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102/\u0010\u0019\u001a+\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u0001H\u00180\u001a\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006$"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup;", "", "()V", "cache", "com/intellij/indexing/shared/download/SharedIndexLookup$cache$1", "Lcom/intellij/indexing/shared/download/SharedIndexLookup$cache$1;", "cacheSize", "", "downloadIndexList", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indexUrl", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "invalidateCaches", "", "lookupSharedIndex", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "lookupSharedIndexWithoutCache", "ourVersion", "T", "matchItem", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "url", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "parseIndexList", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "CacheEntry", "Companion", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexLookup.kt\ncom/intellij/indexing/shared/download/SharedIndexLookup\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n*L\n1#1,191:1\n43#2,3:192\n56#2:222\n26#3:195\n12#3,4:196\n27#3,14:200\n18#3,2:214\n42#3,6:216\n*S KotlinDebug\n*F\n+ 1 SharedIndexLookup.kt\ncom/intellij/indexing/shared/download/SharedIndexLookup\n*L\n87#1:192,3\n113#1:222\n97#1:195\n97#1:196,4\n97#1:200,14\n97#1:214,2\n97#1:216,6\n*E\n"})
public final class SharedIndexLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final cache.1 cache = new SharedIndexNetworkCache<SharedIndexLookupRequest, CacheEntry>(){

        @NotNull
        protected Instant getCreated(@NotNull CacheEntry $this$created) {
            Intrinsics.checkNotNullParameter((Object)$this$created, (String)"<this>");
            return $this$created.getComputed();
        }
    };

    @Nullable
    public final SharedIndexLookupResult lookupSharedIndex(@NotNull SharedIndexLookupRequest request, @NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        CacheEntry cacheEntry = (CacheEntry)this.cache.lookupOrCompute(request, indicator, (Function1)new Function1<CacheEntry, Boolean>(ideVersion){
            final /* synthetic */ SharedIndexInfrastructureVersion $ideVersion;
            {
                this.$ideVersion = $ideVersion;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CacheEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)((Object)it.getIdeVersion()), (Object)((Object)this.$ideVersion));
            }
        }, (Function1)new Function1<SharedIndexNetworkCacheScope, CacheEntry>(this, request, ideVersion, indicator){
            final /* synthetic */ SharedIndexLookup this$0;
            final /* synthetic */ SharedIndexLookupRequest $request;
            final /* synthetic */ SharedIndexInfrastructureVersion $ideVersion;
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$ideVersion = $ideVersion;
                this.$indicator = $indicator;
                super(1);
            }

            @Nullable
            public final CacheEntry invoke(@NotNull SharedIndexNetworkCacheScope $this$lookupOrCompute) {
                SharedIndexLookupResult sharedIndexLookupResult;
                Intrinsics.checkNotNullParameter((Object)$this$lookupOrCompute, (String)"$this$lookupOrCompute");
                try {
                    sharedIndexLookupResult = SharedIndexLookup.access$lookupSharedIndexWithoutCache(this.this$0, this.$request, this.$ideVersion, this.$indicator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    if (t instanceof SharedIndexAuthException) {
                        throw t;
                    }
                    this.$indicator.checkCanceled();
                    SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to lookup shared index for " + this.$request + ". " + t.getMessage(), t);
                    sharedIndexLookupResult = null;
                }
                SharedIndexLookupResult result2 = sharedIndexLookupResult;
                return new CacheEntry(this.$ideVersion, $this$lookupOrCompute.getNow(), result2);
            }
        });
        return cacheEntry != null ? cacheEntry.getValue() : null;
    }

    private final SharedIndexLookupResult lookupSharedIndexWithoutCache(SharedIndexLookupRequest request, SharedIndexInfrastructureVersion ourVersion, ProgressIndicator indicator) {
        return (SharedIndexLookupResult)this.lookupSharedIndexWithoutCache(request, indicator, (Function2)new Function2<String, List<? extends SharedIndexLookupResult>, SharedIndexLookupResult>(ourVersion){
            final /* synthetic */ SharedIndexInfrastructureVersion $ourVersion;
            {
                this.$ourVersion = $ourVersion;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final SharedIndexLookupResult invoke(@NotNull String string, @NotNull List<SharedIndexLookupResult> results) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(results, (String)"results");
                SharedIndexLookupResult bestSuitableIndex = SharedIndexMetadata.Companion.selectBestSuitableIndex(this.$ourVersion, results);
                if (bestSuitableIndex == null && SharedIndexDownloadLoggerKt.getDownloadLogger().isTraceEnabled()) {
                    void $this$invoke_u24lambda_u240;
                    StringBuilder stringBuilder;
                    SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = this.$ourVersion;
                    StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                    Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                    boolean bl = false;
                    StringBuilder stringBuilder3 = $this$invoke_u24lambda_u240.append("Among " + results.size() + " candidate indexes no one is compatible with current IDE");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                    StringBuilder stringBuilder4 = $this$invoke_u24lambda_u240.append("Current IDE version:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                    StringBuilder stringBuilder5 = $this$invoke_u24lambda_u240.append("    " + sharedIndexInfrastructureVersion);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
                    StringBuilder stringBuilder6 = $this$invoke_u24lambda_u240.append("Candidates:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
                    Iterator<SharedIndexLookupResult> iterator = results.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        int index2 = n++;
                        SharedIndexLookupResult result2 = iterator.next();
                        StringBuilder stringBuilder7 = $this$invoke_u24lambda_u240.append(index2 + 1 + ") Result : " + result2);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder8 = $this$invoke_u24lambda_u240.append(index2 + 1 + ") Version: " + result2.getIndexVersion());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
                    }
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    logger.trace(string2);
                }
                return bestSuitableIndex;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final <T> T lookupSharedIndexWithoutCache(@NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator, @NotNull Function2<? super String, ? super List<SharedIndexLookupResult>, ? extends T> matchItem) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(matchItem, (String)"matchItem");
        boolean $i$f$service22 = false;
        Class<SharedIndexListLookup> serviceClass$iv = SharedIndexListLookup.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        List<String> urlsToProcess = ((SharedIndexListLookup)object).collectUrlsToProcess(request, indicator);
        if (urlsToProcess.isEmpty()) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No shared indexes are found for " + request + ".");
            return null;
        }
        indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.checking", new Object[0]));
        Collection $i$f$service22 = urlsToProcess;
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv.pushState();
        try {
            void $this$forEachWithProgress$iv;
            boolean bl = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv = $this$forEachWithProgress$iv.size();
            Iterator iterator = $this$forEachWithProgress$iv.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                void subIndicator;
                int i$iv = n++;
                Object y$iv = iterator.next();
                indicator.checkCanceled();
                double lowerBound$iv = (double)i$iv / size$iv;
                double upperBound$iv = (double)(i$iv + 1) / size$iv;
                indicator.setFraction(lowerBound$iv);
                String prevText$iv = indicator.getText();
                String prevText2$iv = indicator.getText2();
                ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv, (double)upperBound$iv);
                String url = (String)y$iv;
                boolean bl2 = false;
                subIndicator.setText2(url);
                char[] cArray = new char[]{'/'};
                String indexUrl = StringsKt.trim((String)url, (char[])cArray) + "/index.json.xz";
                List<SharedIndexLookupResult> results = this.downloadIndexList(request, indexUrl, (ProgressIndicator)subIndicator);
                subIndicator.checkCanceled();
                Object object2 = matchItem.invoke((Object)url, results);
                if (object2 != null) {
                    Object best = object2;
                    boolean bl3 = false;
                    SharedIndexDownloadLoggerKt.getDownloadLogger().info("Selected pre-built shared index " + best + " from " + url + " for " + request);
                    Object object3 = best;
                    return (T)object3;
                }
                indicator.setText(prevText$iv);
                indicator.setText2(prevText2$iv);
            }
            indicator.setFraction(1.0);
        }
        finally {
            $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
            $this$withPushPop$iv$iv.popState();
        }
        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No suitable shared indexes are found for " + request + ". The following " + urlsToProcess.size() + " URLs were tried: " + CollectionsKt.joinToString$default((Iterable)urlsToProcess, null, null, null, (int)0, null, null, (int)63, null));
        return null;
    }

    public final void invalidateCaches() {
        boolean $i$f$serviceIfCreated = false;
        Application application = ApplicationManager.getApplication();
        SharedIndexListLookup sharedIndexListLookup = (SharedIndexListLookup)(application != null ? application.getServiceIfCreated(SharedIndexListLookup.class) : null);
        if (sharedIndexListLookup != null) {
            sharedIndexListLookup.invalidateCaches();
        }
        this.cache.invalidateCaches();
    }

    @VisibleForTesting
    public final int cacheSize() {
        return this.cache.cacheSize();
    }

    @VisibleForTesting
    @NotNull
    public final List<SharedIndexLookupResult> downloadIndexList(@NotNull SharedIndexLookupRequest request, @NotNull String indexUrl, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ObjectNode objectNode = SharedIndexDownloadJson.INSTANCE.downloadJsonXz(request, indexUrl, indicator);
        if (objectNode == null) {
            return CollectionsKt.emptyList();
        }
        ObjectNode json = objectNode;
        return this.parseIndexList(json, indexUrl, request);
    }

    @VisibleForTesting
    @NotNull
    public final List<SharedIndexLookupResult> parseIndexList(@NotNull ObjectNode json, @NotNull String indexUrl, @NotNull SharedIndexLookupRequest request) {
        String listVersion;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        JsonNode jsonNode = json.get("list_version");
        String string = listVersion = jsonNode != null ? jsonNode.asText() : null;
        if (!Intrinsics.areEqual((Object)listVersion, (Object)"1")) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().trace("Index data version mismatch. The current version is " + listVersion + " in " + indexUrl + " for " + request);
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode2 = json.get("entries");
        ArrayNode arrayNode = jsonNode2 instanceof ArrayNode ? (ArrayNode)jsonNode2 : null;
        if (arrayNode == null) {
            SharedIndexLookup $this$parseIndexList_u24lambda_u242 = this;
            boolean bl = false;
            SharedIndexDownloadLoggerKt.getDownloadLogger().trace("Index data format is incomplete. Missing 'entries' element in " + indexUrl + " for " + request);
            return CollectionsKt.emptyList();
        }
        ArrayNode entries = arrayNode;
        Iterator iterator = entries.elements();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<JsonNode, SharedIndexLookupResult>(indexUrl, this, request){
            final /* synthetic */ String $indexUrl;
            final /* synthetic */ SharedIndexLookup this$0;
            final /* synthetic */ SharedIndexLookupRequest $request;
            {
                this.$indexUrl = $indexUrl;
                this.this$0 = $receiver;
                this.$request = $request;
                super(1);
            }

            @Nullable
            public final SharedIndexLookupResult invoke(JsonNode node) {
                Object $this$invoke_u24lambda_u241;
                if (!(node instanceof ObjectNode)) {
                    return null;
                }
                JsonNode jsonNode = node.get("url");
                String string = jsonNode != null ? jsonNode.asText() : null;
                if (string == null) {
                    return null;
                }
                String string2 = SharedIndexLookup.Companion.resolveRelativeUrl(this.$indexUrl, string);
                if (string2 == null) {
                    return null;
                }
                String url = string2;
                JsonNode jsonNode2 = node.get("sha256");
                String string3 = jsonNode2 != null ? jsonNode2.asText() : null;
                if (string3 == null) {
                    return null;
                }
                String sha = string3;
                JsonNode jsonNode3 = node.get("size");
                if (jsonNode3 == null) {
                    return null;
                }
                long size = jsonNode3.asLong();
                Object object = node.get("metadata");
                ObjectNode objectNode = object instanceof ObjectNode ? (ObjectNode)object : null;
                if (objectNode == null) {
                    return null;
                }
                ObjectNode indexVersionJson = objectNode;
                object = this.this$0;
                try {
                    SharedIndexLineup sharedIndexLineup;
                    $this$invoke_u24lambda_u241 = object;
                    boolean bl = false;
                    JsonNode jsonNode4 = node.get("lineup");
                    ObjectNode objectNode2 = jsonNode4 instanceof ObjectNode ? (ObjectNode)jsonNode4 : null;
                    if (objectNode2 != null) {
                        ObjectNode it = objectNode2;
                        boolean bl2 = false;
                        String string4 = it.get("name").asText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asText(...)");
                        sharedIndexLineup = new SharedIndexLineup(string4, it.get("creationStamp").asLong(), it.get("indexedFileCount").asInt());
                    } else {
                        sharedIndexLineup = null;
                    }
                    $this$invoke_u24lambda_u241 = Result.constructor-impl(sharedIndexLineup);
                }
                catch (Throwable bl) {
                    $this$invoke_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object = $this$invoke_u24lambda_u241;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Object it = $this$invoke_u24lambda_u241 = throwable;
                    boolean bl = false;
                    SharedIndexDownloadLoggerKt.getDownloadLogger().info((Throwable)it);
                }
                SharedIndexLineup lineup = (SharedIndexLineup)(Result.isFailure-impl((Object)object) ? null : object);
                JsonNode jsonNode5 = node.get("format");
                SharedIndexCompression sharedIndexCompression = SharedIndexCompression.Companion.findByType(jsonNode5 != null ? jsonNode5.asText() : null);
                if (sharedIndexCompression == null) {
                    return null;
                }
                SharedIndexCompression compression = sharedIndexCompression;
                SharedIndexMetadata sharedIndexMetadata = SharedIndexMetadata.Companion.tryReadSharedIndexMetadata(indexVersionJson);
                if (sharedIndexMetadata == null) {
                    return null;
                }
                SharedIndexMetadata indexVersion = sharedIndexMetadata;
                return new SharedIndexLookupResult(this.$request, url, sha, size, compression, indexVersion, lineup);
            }
        })));
    }

    public static final /* synthetic */ SharedIndexLookupResult access$lookupSharedIndexWithoutCache(SharedIndexLookup $this, SharedIndexLookupRequest request, SharedIndexInfrastructureVersion ourVersion, ProgressIndicator indicator) {
        return $this.lookupSharedIndexWithoutCache(request, ourVersion, indicator);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup$CacheEntry;", "", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "computed", "Ljava/time/Instant;", "value", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "(Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;Ljava/time/Instant;Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;)V", "getComputed", "()Ljava/time/Instant;", "getIdeVersion", "()Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "getValue", "()Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared"})
    private static final class CacheEntry {
        @NotNull
        private final SharedIndexInfrastructureVersion ideVersion;
        @NotNull
        private final Instant computed;
        @Nullable
        private final SharedIndexLookupResult value;

        public CacheEntry(@NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull Instant computed, @Nullable SharedIndexLookupResult value) {
            Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            this.ideVersion = ideVersion;
            this.computed = computed;
            this.value = value;
        }

        @NotNull
        public final SharedIndexInfrastructureVersion getIdeVersion() {
            return this.ideVersion;
        }

        @NotNull
        public final Instant getComputed() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexLookupResult getValue() {
            return this.value;
        }

        @NotNull
        public final SharedIndexInfrastructureVersion component1() {
            return this.ideVersion;
        }

        @NotNull
        public final Instant component2() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexLookupResult component3() {
            return this.value;
        }

        @NotNull
        public final CacheEntry copy(@NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull Instant computed, @Nullable SharedIndexLookupResult value) {
            Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            return new CacheEntry(ideVersion, computed, value);
        }

        public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion, Instant instant, SharedIndexLookupResult sharedIndexLookupResult, int n, Object object) {
            if ((n & 1) != 0) {
                sharedIndexInfrastructureVersion = cacheEntry.ideVersion;
            }
            if ((n & 2) != 0) {
                instant = cacheEntry.computed;
            }
            if ((n & 4) != 0) {
                sharedIndexLookupResult = cacheEntry.value;
            }
            return cacheEntry.copy(sharedIndexInfrastructureVersion, instant, sharedIndexLookupResult);
        }

        @NotNull
        public String toString() {
            return "CacheEntry(ideVersion=" + this.ideVersion + ", computed=" + this.computed + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result2 = this.ideVersion.hashCode();
            result2 = result2 * 31 + this.computed.hashCode();
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheEntry)) {
                return false;
            }
            CacheEntry cacheEntry = (CacheEntry)other;
            if (!Intrinsics.areEqual((Object)((Object)this.ideVersion), (Object)((Object)cacheEntry.ideVersion))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.computed, (Object)cacheEntry.computed)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)cacheEntry.value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup$Companion;", "", "()V", "resolveRelativeUrl", "", "indexUrl", "relative", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String resolveRelativeUrl(@NotNull String indexUrl, @NotNull String relative) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
            Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
            if (StringsKt.startsWith$default((String)relative, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"https://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"file:/", (boolean)false, (int)2, null)) {
                return relative;
            }
            try {
                object = new char[]{'/'};
                object = URI.create(StringsKt.trimEnd((String)indexUrl, (char[])object)).resolve(relative).toURL().toExternalForm();
            }
            catch (Throwable t) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to resolve relative URL " + relative + " with base " + indexUrl);
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

