/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.composite.CompositeInvertedIndexBase;
import com.intellij.indexing.shared.platform.impl.EmptyIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.HashBasedMapReduceIndex;
import com.intellij.indexing.shared.platform.impl.HashSuppliedIndexedFile;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.events.VfsEventsMerger;
import com.intellij.util.indexing.impl.MapReduceIndex;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeInvertedIndex<Key, Value, FileIndexMetaData>
extends CompositeInvertedIndexBase<Key, Value, FileIndexMetaData> {
    private static final Key<Ref<@Nullable FileContent>> INDEXED_HASH_KEY = Key.create((String)"indexed.file.shared.index.metadata.hash");
    private static final Logger LOG = Logger.getInstance(CompositeInvertedIndex.class);
    @NotNull
    private final SharedIndexChunkConfiguration mySharedIndexChunkConfiguration;
    @NotNull
    private final FileContentHashIndex myHashIndex;

    public CompositeInvertedIndex(@NotNull ID<Key, Value> id, @NotNull UpdatableIndex<Key, Value, FileContent, FileIndexMetaData> baseIndex) throws IOException {
        if (id == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(0);
        }
        if (baseIndex == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(1);
        }
        super(id, baseIndex);
        this.mySharedIndexChunkConfiguration = SharedIndexChunkConfiguration.getInstance();
        this.myHashIndex = id instanceof StubIndexKey ? FileContentHashIndex.getFileContentHashIndex(StubUpdatingIndex.INDEX_ID) : FileContentHashIndex.createFileContentHashIndex(this.myId);
    }

    public boolean tryIndexWithoutContent(int inputId, @NotNull IndexedFile indexedFile) {
        FileContent hashSuppliedIndexedFile;
        Ref hashSuppliedIndexedFileRef;
        if (indexedFile == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(2);
        }
        if ((hashSuppliedIndexedFileRef = (Ref)indexedFile.getUserData(INDEXED_HASH_KEY)) == null) {
            long hashId = this.mySharedIndexChunkConfiguration.tryEnumerateContentHash(indexedFile);
            hashSuppliedIndexedFileRef = new Ref();
            if (hashId != FileContentHashIndexExtension.NULL_HASH_ID) {
                hashSuppliedIndexedFileRef.set((Object)new HashSuppliedIndexedFile(indexedFile, hashId));
            }
            indexedFile.putUserData(INDEXED_HASH_KEY, (Object)hashSuppliedIndexedFileRef);
        }
        if ((hashSuppliedIndexedFile = (FileContent)hashSuppliedIndexedFileRef.get()) == null) {
            return false;
        }
        Computable sharedIndexUpdate = this.myHashIndex.mapInputAndPrepareUpdate(inputId, hashSuppliedIndexedFile);
        long hashId = CompositeInvertedIndex.getHashId((MapReduceIndex.IndexUpdateComputable)sharedIndexUpdate);
        if (hashId == FileContentHashIndexExtension.NULL_HASH_ID) {
            VfsEventsMerger.tryLog((String)"cant_indexed_without_content", (IndexedFile)indexedFile, () -> "id=" + this.myId);
            return false;
        }
        VfsEventsMerger.tryLog((String)"indexed_without_content", (IndexedFile)indexedFile, () -> "id=" + this.myId);
        boolean baseIndexUpdateResult = (Boolean)this.updateBaseIndex(inputId, null).compute();
        boolean sharedIndexUpdateResult = (Boolean)sharedIndexUpdate.compute();
        return baseIndexUpdateResult && sharedIndexUpdateResult;
    }

    @Override
    @NotNull
    protected Computable<Boolean> removeFromSecondaryIndex(int inputId) {
        Computable computable = this.myHashIndex.mapInputAndPrepareUpdate(inputId, null);
        if (computable == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(3);
        }
        return computable;
    }

    @Override
    protected void getSecondaryIndexData(@NotNull Key key, Consumer<? super ValueContainer<Value>> dataConsumer) throws StorageException {
        if (key == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(4);
        }
        this.mySharedIndexChunkConfiguration.processSharedIndexes(this.myId, index2 -> {
            dataConsumer.accept((Object)index2.getData(key));
            return true;
        });
    }

    @Override
    @NotNull
    protected CompositeInvertedIndexBase.IndexInfrastructureUpdate tryToMapWithSecondaryIndex(int inputId, @NotNull FileContent content) {
        if (content == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(5);
        }
        Computable sharedIndexUpdate = this.myHashIndex.mapInputAndPrepareUpdate(inputId, content);
        long hashId = CompositeInvertedIndex.getHashId((MapReduceIndex.IndexUpdateComputable)sharedIndexUpdate);
        int chunkId = FileContentHashIndexExtension.getChunkId(hashId);
        boolean hasSharedIndex = this.mySharedIndexChunkConfiguration.hasSharedIndex(this.myId, chunkId);
        if (this.myId == StubUpdatingIndex.INDEX_ID) {
            VfsEventsMerger.tryLog((String)"stub_shared_index_mapping", (IndexedFile)content, () -> "hash_id=" + hashId + ",has_shared_index=" + hasSharedIndex);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Shared index " + this.myId.getName() + " for file " + content.getFileName() + (String)(hasSharedIndex ? " is found in chunk " + chunkId : "is not found"));
        }
        return new CompositeInvertedIndexBase.IndexInfrastructureUpdate(hasSharedIndex, (Computable<Boolean>)sharedIndexUpdate);
    }

    public boolean isDirty() {
        return this.myBaseIndex.isDirty() || this.myHashIndex.isDirty();
    }

    private static long getHashId(MapReduceIndex.IndexUpdateComputable sharedIndexUpdate) {
        Map map = sharedIndexUpdate.getInputData().getKeyValues();
        return FileContentHashIndexExtension.getHashId(map);
    }

    @Override
    @Nullable
    protected Map<Key, Value> getSecondaryIndexFileData(int fileId) throws StorageException {
        long hashId = this.hasAnyAttachedChunk() ? this.myHashIndex.getHashId(fileId) : FileContentHashIndexExtension.NULL_HASH_ID;
        int chunkId = FileContentHashIndexExtension.getChunkId(hashId);
        if (hashId != FileContentHashIndexExtension.NULL_HASH_ID && this.mySharedIndexChunkConfiguration.hasSharedIndex(this.myId, chunkId)) {
            int internalHashId = FileContentHashIndexExtension.getInternalHashId(hashId);
            Map sharedFileData = this.mySharedIndexChunkConfiguration.querySharedIndex(this.myId, chunkId, index2 -> {
                if (!CompositeInvertedIndex.doesSharedIndexHaveForwardIndex(index2)) {
                    VirtualFile vFile = PersistentFS.getInstance().findFileById(fileId);
                    if (vFile != null) {
                        FileBasedIndex.getInstance().requestReindex(vFile);
                    }
                    LOG.error("Shared index chunk for " + this.getExtension().getName() + " doesn't have forward index. Index data might be incomplete");
                    return Collections.emptyMap();
                }
                return index2.getIndexedFileData(internalHashId);
            });
            if (sharedFileData != null) {
                return sharedFileData;
            }
            throw new StorageException(String.format("File data for %d hasn't been found although chunk %d is attached with index %s", fileId, chunkId, this.myId.getName()));
        }
        return null;
    }

    @Override
    protected boolean processAllKeysBySecondaryIndex(@NotNull Processor<? super Key> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(7);
        }
        return this.mySharedIndexChunkConfiguration.processSharedIndexes(this.myId, index2 -> index2.processAllKeys(processor, scope, idFilter));
    }

    @Override
    protected void disposeSecondaryIndex() {
        if (!(this.myId instanceof StubIndexKey)) {
            this.myHashIndex.dispose();
        }
    }

    @Override
    protected void flushSecondaryIndex() throws StorageException {
        this.myHashIndex.flush();
    }

    @Override
    protected void clearSecondaryIndex() {
        this.myHashIndex.clear();
    }

    @NotNull
    public FileContentHashIndex getHashIndex() {
        FileContentHashIndex fileContentHashIndex = this.myHashIndex;
        if (fileContentHashIndex == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(8);
        }
        return fileContentHashIndex;
    }

    private boolean hasAnyAttachedChunk() {
        return !this.mySharedIndexChunkConfiguration.processSharedIndexes(this.myId, index2 -> false);
    }

    private static boolean doesSharedIndexHaveForwardIndex(@NotNull UpdatableIndex<?, ?, FileContent, ?> index2) {
        if (index2 == null) {
            CompositeInvertedIndex.$$$reportNull$$$0(9);
        }
        if (index2 instanceof EmptyIndex || index2.getExtension() instanceof SingleEntryFileBasedIndexExtension) {
            return true;
        }
        return ((HashBasedMapReduceIndex)index2).hasForwardIndex();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/CompositeInvertedIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/CompositeInvertedIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromSecondaryIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryIndexWithoutContent";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSecondaryIndexData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryToMapWithSecondaryIndex";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeysBySecondaryIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doesSharedIndexHaveForwardIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }
}

