/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Streams;

class ElementsSatisfyingConsumer<E> {
    private final List<E> elements;

    ElementsSatisfyingConsumer(Iterable<? extends E> actual, Consumer<? super E> assertions) {
        this(ElementsSatisfyingConsumer.filterByPassingAssertions(actual, assertions));
    }

    private ElementsSatisfyingConsumer(List<E> elements) {
        this.elements = elements;
    }

    List<E> getElements() {
        return this.elements;
    }

    ElementsSatisfyingConsumer<E> withoutElement(E element2) {
        ArrayList<E> listWithoutElement = new ArrayList<E>(this.elements);
        listWithoutElement.remove(element2);
        return new ElementsSatisfyingConsumer<E>(listWithoutElement);
    }

    private static <E> List<E> filterByPassingAssertions(Iterable<? extends E> actual, Consumer<? super E> assertions) {
        return Streams.stream(actual).filter(Iterables.byPassingAssertions(assertions)).collect(Collectors.toList());
    }
}

