/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.BackupCmd;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.cloud.api.collections.CreateAliasCmd;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.cloud.api.collections.CreateShardCmd;
import org.apache.solr.cloud.api.collections.CreateSnapshotCmd;
import org.apache.solr.cloud.api.collections.DeleteAliasCmd;
import org.apache.solr.cloud.api.collections.DeleteBackupCmd;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.cloud.api.collections.DeleteNodeCmd;
import org.apache.solr.cloud.api.collections.DeleteReplicaCmd;
import org.apache.solr.cloud.api.collections.DeleteShardCmd;
import org.apache.solr.cloud.api.collections.DeleteSnapshotCmd;
import org.apache.solr.cloud.api.collections.MaintainRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.MigrateCmd;
import org.apache.solr.cloud.api.collections.MoveReplicaCmd;
import org.apache.solr.cloud.api.collections.OverseerRoleCmd;
import org.apache.solr.cloud.api.collections.OverseerStatusCmd;
import org.apache.solr.cloud.api.collections.ReindexCollectionCmd;
import org.apache.solr.cloud.api.collections.RenameCmd;
import org.apache.solr.cloud.api.collections.ReplaceNodeCmd;
import org.apache.solr.cloud.api.collections.RestoreCmd;
import org.apache.solr.cloud.api.collections.SetAliasPropCmd;
import org.apache.solr.cloud.api.collections.SplitShardCmd;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollApiCmds {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static class ModifyCollectionCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public ModifyCollectionCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            String collectionName = message.getStr("collection");
            String configName = (String)message.getProperties().get("collection.configName");
            if (configName != null) {
                CollectionHandlingUtils.validateConfigOrThrowSolrException(this.ccc.getCoreContainer().getConfigSetService(), configName);
                String collPath = "/collections/" + collectionName;
                if (this.ccc.getSolrCloudManager().getDistribStateManager().hasData(collPath)) {
                    this.ccc.getSolrCloudManager().getDistribStateManager().setData(collPath, Utils.toJSON(Map.of("configName", configName)), -1);
                }
            }
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.CollectionModifyCollection, message, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate((MapWriter)message);
            }
            try {
                this.ccc.getZkStateReader().waitForState(collectionName, 30L, TimeUnit.SECONDS, c -> {
                    if (c == null) {
                        return false;
                    }
                    for (Map.Entry updateEntry : message.getProperties().entrySet()) {
                        String updateKey = (String)updateEntry.getKey();
                        if (updateKey.equals("collection.configName")) {
                            updateKey = "configName";
                        }
                        if (!(updateKey.equals("collection") || updateKey.equals("operation") || updateKey.equals("async") || updateEntry.getValue() == null || updateEntry.getValue().equals(c.get(updateKey)))) {
                            return false;
                        }
                        if (updateEntry.getValue() != null || !c.containsKey(updateKey)) continue;
                        return false;
                    }
                    return true;
                });
            }
            catch (InterruptedException | TimeoutException e) {
                SolrZkClient.checkInterrupted((Throwable)e);
                log.debug("modifyCollection(ClusterState={}, ZkNodeProps={}, NamedList={})", new Object[]{clusterState, message, results, e});
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to modify collection", (Throwable)e);
            }
            if (message.keySet().contains("readOnly") || configName != null) {
                new ReloadCollectionCmd(this.ccc).call(clusterState, new ZkNodeProps(new String[]{"name", collectionName}), results);
            }
        }
    }

    public static class BalanceShardsUniqueCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public BalanceShardsUniqueCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            if (StringUtils.isBlank((CharSequence)message.getStr("collection")) || StringUtils.isBlank((CharSequence)message.getStr("property"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'collection' and 'property' parameters are required for the BALANCESHARDUNIQUE operation, no action taken");
            }
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("operation", CollectionParams.CollectionAction.BALANCESHARDUNIQUE.toLower());
            m.putAll(message.getProperties());
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.BalanceShardsUnique, new ZkNodeProps(m), this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate(Utils.toJSON(m));
            }
        }
    }

    public static class DeleteReplicaPropCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public DeleteReplicaPropCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            CollectionHandlingUtils.checkRequired(message, "collection", "shard", "replica", "property");
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("operation", CollectionParams.CollectionAction.DELETEREPLICAPROP.toLower());
            propMap.putAll(message.getProperties());
            ZkNodeProps m = new ZkNodeProps(propMap);
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.ReplicaDeleteReplicaProperty, m, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate((MapWriter)m);
            }
        }
    }

    public static class AddReplicaPropCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public AddReplicaPropCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            CollectionHandlingUtils.checkRequired(message, "collection", "shard", "replica", "property", "property.value");
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICAPROP.toLower());
            propMap.putAll(message.getProperties());
            ZkNodeProps m = new ZkNodeProps(propMap);
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.ReplicaAddReplicaProperty, m, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate((MapWriter)m);
            }
        }
    }

    public static class RebalanceLeadersCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public RebalanceLeadersCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            CollectionHandlingUtils.checkRequired(message, "collection", "shard", "core", "election_node", "core_node_name", "node_name", "rejoinAtHead");
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("collection", new String[]{message.getStr("collection")});
            params.set("shard", new String[]{message.getStr("shard")});
            params.set("rejoinAtHead", new String[]{message.getStr("rejoinAtHead")});
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION.toString()});
            params.set("core", new String[]{message.getStr("core")});
            params.set("core_node_name", new String[]{message.getStr("core_node_name")});
            params.set("election_node", new String[]{message.getStr("election_node")});
            params.set("node_name", new String[]{message.getStr("node_name")});
            String baseUrl = this.ccc.getZkStateReader().getBaseUrlForNodeName(message.getStr("node_name"));
            ShardRequest sreq = new ShardRequest();
            sreq.nodeName = message.getStr("core");
            params.set("qt", new String[]{this.ccc.getAdminPath()});
            sreq.purpose = 1;
            sreq.shards = new String[]{baseUrl};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            ShardHandler shardHandler = this.ccc.newShardHandler();
            shardHandler.submit(sreq, baseUrl, sreq.params);
        }
    }

    public static class ReloadCollectionCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public ReloadCollectionCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
            String asyncId = message.getStr("async");
            CollectionHandlingUtils.collectionCmd(message, params, results, Replica.State.ACTIVE, asyncId, Collections.emptySet(), this.ccc, clusterState);
        }
    }

    public static class MockOperationCmd
    implements CollectionApiCommand {
        @Override
        @SuppressForbidden(reason="Needs currentTimeMillis for mock requests")
        public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws InterruptedException {
            Thread.sleep(message.getInt("sleep", Integer.valueOf(1)).intValue());
            if (log.isInfoEnabled()) {
                log.info("MOCK_TASK_EXECUTED time {} data {}", (Object)System.currentTimeMillis(), (Object)Utils.toJSONString((Object)message));
            }
            results.add("MOCK_FINISHED", (Object)System.currentTimeMillis());
        }
    }

    protected static class CommandMap {
        private final Map<CollectionParams.CollectionAction, CollectionApiCommand> commandMap;

        CommandMap(CollectionCommandContext ccc, OverseerNodePrioritizer overseerPrioritizer) {
            this(overseerPrioritizer, ccc);
            assert (!ccc.isDistributedCollectionAPI());
        }

        CommandMap(CollectionCommandContext ccc) {
            this(null, ccc);
            assert (ccc.isDistributedCollectionAPI());
        }

        private CommandMap(OverseerNodePrioritizer overseerPrioritizer, CollectionCommandContext ccc) {
            this.commandMap = new ImmutableMap.Builder().put((Object)CollectionParams.CollectionAction.REPLACENODE, (Object)new ReplaceNodeCmd(ccc)).put((Object)CollectionParams.CollectionAction.DELETENODE, (Object)new DeleteNodeCmd(ccc)).put((Object)CollectionParams.CollectionAction.BACKUP, (Object)new BackupCmd(ccc)).put((Object)CollectionParams.CollectionAction.RESTORE, (Object)new RestoreCmd(ccc)).put((Object)CollectionParams.CollectionAction.DELETEBACKUP, (Object)new DeleteBackupCmd(ccc)).put((Object)CollectionParams.CollectionAction.CREATESNAPSHOT, (Object)new CreateSnapshotCmd(ccc)).put((Object)CollectionParams.CollectionAction.DELETESNAPSHOT, (Object)new DeleteSnapshotCmd(ccc)).put((Object)CollectionParams.CollectionAction.SPLITSHARD, (Object)new SplitShardCmd(ccc)).put((Object)CollectionParams.CollectionAction.ADDROLE, (Object)new OverseerRoleCmd(ccc, CollectionParams.CollectionAction.ADDROLE, overseerPrioritizer)).put((Object)CollectionParams.CollectionAction.REMOVEROLE, (Object)new OverseerRoleCmd(ccc, CollectionParams.CollectionAction.REMOVEROLE, overseerPrioritizer)).put((Object)CollectionParams.CollectionAction.MOCK_COLL_TASK, (Object)new MockOperationCmd()).put((Object)CollectionParams.CollectionAction.MOCK_SHARD_TASK, (Object)new MockOperationCmd()).put((Object)CollectionParams.CollectionAction.MOCK_REPLICA_TASK, (Object)new MockOperationCmd()).put((Object)CollectionParams.CollectionAction.CREATESHARD, (Object)new CreateShardCmd(ccc)).put((Object)CollectionParams.CollectionAction.MIGRATE, (Object)new MigrateCmd(ccc)).put((Object)CollectionParams.CollectionAction.CREATE, (Object)new CreateCollectionCmd(ccc)).put((Object)CollectionParams.CollectionAction.MODIFYCOLLECTION, (Object)new ModifyCollectionCmd(ccc)).put((Object)CollectionParams.CollectionAction.ADDREPLICAPROP, (Object)new AddReplicaPropCmd(ccc)).put((Object)CollectionParams.CollectionAction.DELETEREPLICAPROP, (Object)new DeleteReplicaPropCmd(ccc)).put((Object)CollectionParams.CollectionAction.BALANCESHARDUNIQUE, (Object)new BalanceShardsUniqueCmd(ccc)).put((Object)CollectionParams.CollectionAction.REBALANCELEADERS, (Object)new RebalanceLeadersCmd(ccc)).put((Object)CollectionParams.CollectionAction.RELOAD, (Object)new ReloadCollectionCmd(ccc)).put((Object)CollectionParams.CollectionAction.DELETE, (Object)new DeleteCollectionCmd(ccc)).put((Object)CollectionParams.CollectionAction.CREATEALIAS, (Object)new CreateAliasCmd(ccc)).put((Object)CollectionParams.CollectionAction.DELETEALIAS, (Object)new DeleteAliasCmd(ccc)).put((Object)CollectionParams.CollectionAction.ALIASPROP, (Object)new SetAliasPropCmd(ccc)).put((Object)CollectionParams.CollectionAction.MAINTAINROUTEDALIAS, (Object)new MaintainRoutedAliasCmd(ccc)).put((Object)CollectionParams.CollectionAction.OVERSEERSTATUS, (Object)new OverseerStatusCmd(ccc)).put((Object)CollectionParams.CollectionAction.DELETESHARD, (Object)new DeleteShardCmd(ccc)).put((Object)CollectionParams.CollectionAction.DELETEREPLICA, (Object)new DeleteReplicaCmd(ccc)).put((Object)CollectionParams.CollectionAction.ADDREPLICA, (Object)new AddReplicaCmd(ccc)).put((Object)CollectionParams.CollectionAction.MOVEREPLICA, (Object)new MoveReplicaCmd(ccc)).put((Object)CollectionParams.CollectionAction.REINDEXCOLLECTION, (Object)new ReindexCollectionCmd(ccc)).put((Object)CollectionParams.CollectionAction.RENAME, (Object)new RenameCmd(ccc)).build();
        }

        CollectionApiCommand getActionCommand(CollectionParams.CollectionAction action) {
            return this.commandMap.get(action);
        }
    }

    protected static interface CollectionApiCommand {
        public void call(ClusterState var1, ZkNodeProps var2, NamedList<Object> var3) throws Exception;
    }
}

