/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.solr.api.ContainerPluginsRegistry;
import org.apache.solr.cloud.ClusterSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSingletons {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, ClusterSingleton> singletonMap = new ConcurrentHashMap<String, ClusterSingleton>();
    private final Supplier<Boolean> runSingletons;
    private final Consumer<Runnable> asyncRunner;
    private final ContainerPluginsRegistry.PluginRegistryListener pluginListener;
    public static final int DEFAULT_WAIT_TIMEOUT_SEC = 60;
    private final CountDownLatch readyLatch = new CountDownLatch(1);

    public ClusterSingletons(final Supplier<Boolean> runSingletons, Consumer<Runnable> asyncRunner) {
        this.runSingletons = runSingletons;
        this.asyncRunner = asyncRunner;
        this.pluginListener = new ContainerPluginsRegistry.PluginRegistryListener(){

            @Override
            public void added(ContainerPluginsRegistry.ApiInfo plugin) {
                if (plugin == null || plugin.getInstance() == null) {
                    return;
                }
                Object instance = plugin.getInstance();
                if (instance instanceof ClusterSingleton) {
                    ClusterSingleton singleton = (ClusterSingleton)instance;
                    ClusterSingletons.this.singletonMap.put(singleton.getName(), singleton);
                    if (ClusterSingletons.this.isReady() && ((Boolean)runSingletons.get()).booleanValue()) {
                        try {
                            singleton.start();
                        }
                        catch (Exception exc) {
                            log.warn("Exception starting ClusterSingleton {}: {}", (Object)plugin, (Object)exc);
                        }
                    }
                }
            }

            @Override
            public void deleted(ContainerPluginsRegistry.ApiInfo plugin) {
                if (plugin == null || plugin.getInstance() == null) {
                    return;
                }
                Object instance = plugin.getInstance();
                if (instance instanceof ClusterSingleton) {
                    ClusterSingleton singleton = (ClusterSingleton)instance;
                    singleton.stop();
                    ClusterSingletons.this.singletonMap.remove(singleton.getName());
                }
            }

            @Override
            public void modified(ContainerPluginsRegistry.ApiInfo old, ContainerPluginsRegistry.ApiInfo replacement) {
                this.added(replacement);
                this.deleted(old);
            }
        };
    }

    public ContainerPluginsRegistry.PluginRegistryListener getPluginRegistryListener() {
        return this.pluginListener;
    }

    public Map<String, ClusterSingleton> getSingletons() {
        return this.singletonMap;
    }

    public boolean isReady() {
        return this.readyLatch.getCount() == 0L;
    }

    public void setReady() {
        this.readyLatch.countDown();
    }

    public void waitUntilReady(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        boolean await = this.readyLatch.await(timeout, timeUnit);
        if (!await) {
            throw new TimeoutException("Timed out waiting for ClusterSingletons to become ready.");
        }
    }

    public void startClusterSingletons() {
        Runnable initializer = () -> {
            try {
                this.waitUntilReady(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted initialization of ClusterSingleton-s");
                return;
            }
            catch (TimeoutException te) {
                log.warn("Timed out during initialization of ClusterSingleton-s (waited {} sec)", (Object)60);
                return;
            }
            if (!this.runSingletons.get().booleanValue()) {
                return;
            }
            this.singletonMap.forEach((name, singleton) -> {
                if (!this.runSingletons.get().booleanValue()) {
                    return;
                }
                try {
                    singleton.start();
                }
                catch (Exception e) {
                    log.warn("Exception starting ClusterSingleton {}: {}", singleton, (Object)e);
                }
            });
        };
        if (!this.isReady()) {
            this.asyncRunner.accept(initializer);
        } else {
            initializer.run();
        }
    }

    public void stopClusterSingletons() {
        this.readyLatch.countDown();
        this.singletonMap.forEach((name, singleton) -> singleton.stop());
    }
}

