/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.lucene.index.IndexCommit;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/cores/{coreName}/snapshots")
public class CoreSnapshotAPI
extends CoreAdminAPIBase {
    @Inject
    public CoreSnapshotAPI(SolrQueryRequest request, SolrQueryResponse response, CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker) {
        super(coreContainer, coreAdminAsyncTracker, request, response);
    }

    @POST
    @Path(value="/{snapshotName}")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public CreateSnapshotResponse createSnapshot(@Parameter(description="The name of the core to snapshot.", required=true) @PathParam(value="coreName") String coreName, @Parameter(description="The name to associate with the core snapshot.", required=true) @PathParam(value="snapshotName") String snapshotName, @Parameter(description="The id to associate with the async task.") @QueryParam(value="async") String taskId) throws Exception {
        CreateSnapshotResponse response = this.instantiateJerseyResponse(CreateSnapshotResponse.class);
        return this.handlePotentiallyAsynchronousTask(response, coreName, taskId, "createSnapshot", () -> {
            try (SolrCore core = this.coreContainer.getCore(coreName);){
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + coreName);
                }
                String indexDirPath = core.getIndexDir();
                IndexDeletionPolicyWrapper delPol = core.getDeletionPolicy();
                IndexCommit ic = delPol.getAndSaveLatestCommit();
                try {
                    if (null == ic) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No index commits to snapshot in core " + coreName);
                    }
                    SolrSnapshotMetaDataManager mgr = core.getSnapshotMetaDataManager();
                    mgr.snapshot(snapshotName, indexDirPath, ic.getGeneration());
                    response.core = core.getName();
                    response.commitName = snapshotName;
                    response.indexDirPath = indexDirPath;
                    response.generation = ic.getGeneration();
                    response.files = ic.getFileNames();
                }
                catch (IOException e) {
                    throw new CoreAdminAPIBase.CoreAdminAPIBaseException(e);
                }
                finally {
                    delPol.releaseCommitPoint(ic);
                }
            }
            return response;
        });
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.CORE_READ_PERM)
    public ListSnapshotsResponse listSnapshots(@Parameter(description="The name of the core for which to retrieve snapshots.", required=true) @PathParam(value="coreName") String coreName) throws Exception {
        ListSnapshotsResponse response = this.instantiateJerseyResponse(ListSnapshotsResponse.class);
        return this.handlePotentiallyAsynchronousTask(response, coreName, null, "listSnapshots", () -> {
            try (SolrCore core = this.coreContainer.getCore(coreName);){
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + coreName);
                }
                SolrSnapshotMetaDataManager mgr = core.getSnapshotMetaDataManager();
                HashMap<String, SnapshotInformation> result = new HashMap<String, SnapshotInformation>();
                for (String name : mgr.listSnapshots()) {
                    Optional<SolrSnapshotMetaDataManager.SnapshotMetaData> metadata = mgr.getSnapshotMetaData(name);
                    if (!metadata.isPresent()) continue;
                    SnapshotInformation snapshotInformation = new SnapshotInformation(metadata.get().getGenerationNumber(), metadata.get().getIndexDirPath());
                    result.put(name, snapshotInformation);
                }
                response.snapshots = result;
            }
            return response;
        });
    }

    @DELETE
    @Path(value="/{snapshotName}")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public DeleteSnapshotResponse deleteSnapshot(@Parameter(description="The name of the core for which to delete a snapshot.", required=true) @PathParam(value="coreName") String coreName, @Parameter(description="The name of the core snapshot to delete.", required=true) @PathParam(value="snapshotName") String snapshotName, @Parameter(description="The id to associate with the async task.") @QueryParam(value="async") String taskId) throws Exception {
        DeleteSnapshotResponse response = this.instantiateJerseyResponse(DeleteSnapshotResponse.class);
        return this.handlePotentiallyAsynchronousTask(response, coreName, taskId, "deleteSnapshot", () -> {
            SolrCore core = this.coreContainer.getCore(coreName);
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + coreName);
            }
            try {
                try {
                    core.deleteNamedSnapshot(snapshotName);
                }
                catch (IOException e) {
                    throw new CoreAdminAPIBase.CoreAdminAPIBaseException(e);
                }
                response.coreName = coreName;
                response.commitName = snapshotName;
            }
            finally {
                core.close();
            }
            return response;
        });
    }

    public static class DeleteSnapshotResponse
    extends SolrJerseyResponse {
        @Schema(description="The name of the core.")
        @JsonProperty(value="core")
        public String coreName;
        @Schema(description="The name of the deleted snapshot.")
        @JsonProperty(value="snapshotName")
        public String commitName;
    }

    public static class SnapshotInformation
    implements JacksonReflectMapWriter {
        @Schema(description="The generation value for the snapshot.")
        @JsonProperty(value="generation")
        public final long generationNumber;
        @Schema(description="The path to the directory containing the index files.")
        @JsonProperty(value="indexDirPath")
        public final String indexDirPath;

        public SnapshotInformation(long generationNumber, String indexDirPath) {
            this.generationNumber = generationNumber;
            this.indexDirPath = indexDirPath;
        }
    }

    public static class ListSnapshotsResponse
    extends SolrJerseyResponse {
        @Schema(description="The collection of snapshots found for the requested core.")
        @JsonProperty(value="snapshots")
        public Map<String, SnapshotInformation> snapshots;
    }

    public static class CreateSnapshotResponse
    extends SolrJerseyResponse {
        @Schema(description="The name of the core.")
        @JsonProperty(value="core")
        public String core;
        @Schema(description="The name of the created snapshot.")
        @JsonProperty(value="snapshotName")
        public String commitName;
        @Schema(description="The path to the directory containing the index files.")
        @JsonProperty(value="indexDirPath")
        public String indexDirPath;
        @Schema(description="The generation value for the created snapshot.")
        @JsonProperty(value="generation")
        public Long generation;
        @Schema(description="The list of index filenames contained within the created snapshot.")
        @JsonProperty(value="files")
        public Collection<String> files;
    }
}

