/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="cluster/nodes/{sourceNodeName}/replace/")
public class ReplaceNodeAPI
extends AdminAPIBase {
    @Inject
    public ReplaceNodeAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse replaceNode(@Parameter(description="The name of the node to be replaced.", required=true) @PathParam(value="sourceNodeName") String sourceNodeName, @RequestBody(description="Contains user provided parameters", required=true) ReplaceNodeRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkNodeProps remoteMessage = this.createRemoteMessage(sourceNodeName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.REPLACENODE, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
        return response;
    }

    public ZkNodeProps createRemoteMessage(String nodeName, ReplaceNodeRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("sourceNode", nodeName);
        if (requestBody != null) {
            this.insertIfValueNotNull(remoteMessage, "targetNode", requestBody.targetNodeName);
            this.insertIfValueNotNull(remoteMessage, "waitForFinalState", requestBody.waitForFinalState);
            this.insertIfValueNotNull(remoteMessage, "async", requestBody.async);
        }
        remoteMessage.put("operation", CollectionParams.CollectionAction.REPLACENODE.toLower());
        return new ZkNodeProps(remoteMessage);
    }

    private void insertIfValueNotNull(Map<String, Object> dest, String key, Object value) {
        if (value != null) {
            dest.put(key, value);
        }
    }

    public static class ReplaceNodeRequestBody
    implements JacksonReflectMapWriter {
        @Schema(description="The target node where replicas will be copied. If this parameter is not provided, Solr will identify nodes automatically based on policies or number of cores in each node.")
        @JsonProperty(value="targetNodeName")
        public String targetNodeName;
        @Schema(description="If true, the request will complete only when all affected replicas become active. If false, the API will return the status of the single action, which may be before the new replica is online and active.")
        @JsonProperty(value="waitForFinalState")
        public Boolean waitForFinalState = false;
        @Schema(description="Request ID to track this action which will be processed asynchronously.")
        @JsonProperty(value="async")
        public String async;

        public ReplaceNodeRequestBody() {
        }

        public ReplaceNodeRequestBody(String targetNodeName, Boolean waitForFinalState, String async) {
            this.targetNodeName = targetNodeName;
            this.waitForFinalState = waitForFinalState;
            this.async = async;
        }
    }
}

