/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Locale;
import org.apache.solr.common.SolrException;
import org.semver4j.Semver;

public final class SolrVersion
implements Comparable<SolrVersion> {
    private final Semver version;
    public static final String LATEST_STRING = "9.2.0";
    public static final SolrVersion LATEST = SolrVersion.valueOf("9.2.0");

    public static SolrVersion valueOf(String version) {
        return new SolrVersion(new Semver(version));
    }

    public static SolrVersion forIntegers(int major, int minor, int patch) {
        return new SolrVersion(new Semver(String.format(Locale.ROOT, "%d.%d.%d", major, minor, patch)));
    }

    public String toString() {
        return this.version.toString();
    }

    public boolean greaterThan(SolrVersion other) {
        return this.version.isGreaterThan(other.version);
    }

    public boolean greaterThanOrEqualTo(SolrVersion other) {
        return this.version.isGreaterThanOrEqualTo(other.version);
    }

    public boolean lessThan(SolrVersion other) {
        return this.version.isLowerThan(other.version);
    }

    public boolean lessThanOrEqualTo(SolrVersion other) {
        return this.version.isLowerThanOrEqualTo(other.version);
    }

    public boolean satisfies(String semVerExpression) {
        return this.version.satisfies(semVerExpression);
    }

    public int getMajorVersion() {
        return this.version.getMajor();
    }

    public int getMinorVersion() {
        return this.version.getMinor();
    }

    public int getPatchVersion() {
        return this.version.getPatch();
    }

    public String getPrereleaseVersion() {
        return String.join((CharSequence)".", this.version.getPreRelease());
    }

    private SolrVersion(Semver version) {
        this.version = version;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @Override
    public int compareTo(SolrVersion other) {
        return this.version.compareTo(other.version);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SolrVersion)) {
            return false;
        }
        return this.compareTo((SolrVersion)other) == 0;
    }

    public static class InvalidSemVerExpressionException
    extends SolrException {
        public InvalidSemVerExpressionException(Exception exception, String expression) {
            super(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Invalid SemVer expression: %s", expression), (Throwable)exception);
        }
    }
}

