/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import java.util.AbstractMap;
import java.util.Map;

public final class ObdDecoder {
    private static final int MODE_CURRENT = 1;
    private static final int MODE_FREEZE_FRAME = 2;
    private static final int MODE_CODES = 3;

    private ObdDecoder() {
    }

    public static Map.Entry<String, Object> decode(int mode, String value) {
        switch (mode) {
            case 1: 
            case 2: {
                return ObdDecoder.decodeData(Integer.parseInt(value.substring(0, 2), 16), Long.parseLong(value.substring(2), 16), true);
            }
            case 3: {
                return ObdDecoder.decodeCodes(value);
            }
        }
        return null;
    }

    private static Map.Entry<String, Object> createEntry(String key, Object value) {
        return new AbstractMap.SimpleEntry<String, Object>(key, value);
    }

    public static Map.Entry<String, Object> decodeCodes(String value) {
        StringBuilder codes = new StringBuilder();
        for (int i = 0; i < value.length() / 4; ++i) {
            int numValue = Integer.parseInt(value.substring(i * 4, (i + 1) * 4), 16);
            codes.append(' ').append(ObdDecoder.decodeCode(numValue));
        }
        if (codes.length() > 0) {
            return ObdDecoder.createEntry("dtcs", codes.toString().trim());
        }
        return null;
    }

    public static String decodeCode(int value) {
        char prefix;
        switch (value >> 14) {
            case 1: {
                prefix = 'C';
                break;
            }
            case 2: {
                prefix = 'B';
                break;
            }
            case 3: {
                prefix = 'U';
                break;
            }
            default: {
                prefix = 'P';
            }
        }
        return String.format("%c%04X", Character.valueOf(prefix), value & 0x3FFF);
    }

    public static Map.Entry<String, Object> decodeData(int pid, long value, boolean convert) {
        switch (pid) {
            case 4: {
                return ObdDecoder.createEntry("engineLoad", convert ? value * 100L / 255L : value);
            }
            case 5: {
                return ObdDecoder.createEntry("coolantTemp", convert ? value - 40L : value);
            }
            case 11: {
                return ObdDecoder.createEntry("mapIntake", value);
            }
            case 12: {
                return ObdDecoder.createEntry("rpm", convert ? value / 4L : value);
            }
            case 13: {
                return ObdDecoder.createEntry("obdSpeed", value);
            }
            case 15: {
                return ObdDecoder.createEntry("intakeTemp", convert ? value - 40L : value);
            }
            case 17: {
                return ObdDecoder.createEntry("throttle", convert ? value * 100L / 255L : value);
            }
            case 33: {
                return ObdDecoder.createEntry("milDistance", value);
            }
            case 47: {
                return ObdDecoder.createEntry("fuel", convert ? value * 100L / 255L : value);
            }
            case 49: {
                return ObdDecoder.createEntry("clearedDistance", value);
            }
        }
        return null;
    }
}

