/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class ScoutSpeakToChiefMessage
extends AttributeMessage {
    public static final String TAG = "scoutSpeakToChief";
    private static final String RESULT_TAG = "result";
    private static final String SETTLEMENT_TAG = "settlement";
    private static final String UNIT_TAG = "unit";

    public ScoutSpeakToChiefMessage(Unit unit, IndianSettlement is, String result) {
        super(TAG, UNIT_TAG, unit.getId(), SETTLEMENT_TAG, is.getId(), RESULT_TAG, result);
    }

    public ScoutSpeakToChiefMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, SETTLEMENT_TAG, RESULT_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Unit unit = this.getUnit(game);
        IndianSettlement is = this.getSettlement(game);
        String result = this.getResult();
        this.igc(freeColClient).scoutSpeakToChiefHandler(unit, is, result);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        IndianSettlement is;
        ServerUnit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String settlementId = this.getStringAttribute(SETTLEMENT_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, ServerUnit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.hasAbility("model.ability.speakWithChief")) {
            return serverPlayer.clientError("Unit lacks ability to speak to chief: " + unitId);
        }
        try {
            is = unit.getAdjacentSettlement(settlementId, IndianSettlement.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Unit.MoveType type = unit.getMoveType(is.getTile());
        if (type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT) {
            return serverPlayer.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        return this.igc(freeColServer).scoutSpeakToChief(serverPlayer, unit, is);
    }

    public Unit getUnit(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(UNIT_TAG), Unit.class);
    }

    public IndianSettlement getSettlement(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(SETTLEMENT_TAG), IndianSettlement.class);
    }

    public String getResult() {
        String result = this.getStringAttribute(RESULT_TAG);
        return result == null ? "" : result;
    }
}

