/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.user;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.guacamole.auth.ldap.ConnectedLDAPConfiguration;
import org.apache.guacamole.auth.ldap.user.UserLDAPConfiguration;
import org.apache.guacamole.net.auth.AbstractAuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;

public class LDAPAuthenticatedUser
extends AbstractAuthenticatedUser {
    @Inject
    private AuthenticationProvider authProvider;
    private Credentials credentials;
    private Map<String, String> tokens;
    private Set<String> effectiveGroups;
    private Dn bindDn;
    private ConnectedLDAPConfiguration config;

    public void init(UserLDAPConfiguration config, Credentials credentials, Map<String, String> tokens, Set<String> effectiveGroups) {
        this.config = config;
        this.credentials = credentials;
        this.tokens = Collections.unmodifiableMap(tokens);
        this.effectiveGroups = effectiveGroups;
        this.bindDn = config.getBindDN();
        this.setIdentifier(config.getGuacamoleUsername());
    }

    public Map<String, String> getTokens() {
        return this.tokens;
    }

    public Dn getBindDn() {
        return this.bindDn;
    }

    public ConnectedLDAPConfiguration getLDAPConfiguration() {
        return this.config;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authProvider;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Set<String> getEffectiveUserGroups() {
        return this.effectiveGroups;
    }

    public void invalidate() {
        this.config.close();
    }
}

