/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.package.version;

import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u001f\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u000fH\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/security/package/version/SingleVersion;", "", "value", "", "(Ljava/lang/String;)V", "releaseDate", "Ljava/util/Date;", "(Ljava/lang/String;Ljava/util/Date;)V", "getReleaseDate", "()Ljava/util/Date;", "getValue", "()Ljava/lang/String;", "checkIfAnyVersion", "", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "hashCode", "majorVersion", "toString", "model"})
public final class SingleVersion
implements Comparable<SingleVersion> {
    @NotNull
    private final String value;
    @Nullable
    private final Date releaseDate;

    public SingleVersion(@NotNull String value, @Nullable Date releaseDate) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.releaseDate = releaseDate;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    public SingleVersion(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(value, null);
    }

    @Override
    public int compareTo(@NotNull SingleVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this.value, (Object)other.value)) {
            return 0;
        }
        String[] stringArray = new String[]{"."};
        List myVersions = StringsKt.split$default((CharSequence)this.value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"."};
        List otherVersions = StringsKt.split$default((CharSequence)other.value, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        for (Pair pair : CollectionsKt.zip((Iterable)myVersions, (Iterable)otherVersions)) {
            String myVersion = (String)pair.component1();
            String otherVersion = (String)pair.component2();
            Integer myInt = StringsKt.toIntOrNull((String)myVersion);
            Integer otherInt = StringsKt.toIntOrNull((String)otherVersion);
            if (myInt != null && otherInt != null) {
                if (Intrinsics.areEqual((Object)myInt, (Object)otherInt)) continue;
                return Intrinsics.compare((int)myInt, (int)otherInt);
            }
            if (Intrinsics.areEqual((Object)myVersion, (Object)otherVersion)) continue;
            return myVersion.compareTo(otherVersion);
        }
        return Intrinsics.compare((int)myVersions.size(), (int)otherVersions.size());
    }

    @NotNull
    public final String majorVersion() {
        String[] stringArray = new String[]{"."};
        List myVersions = StringsKt.split$default((CharSequence)this.value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return (String)CollectionsKt.first((List)myVersions);
    }

    public final boolean checkIfAnyVersion() {
        return Intrinsics.areEqual((Object)this.value, (Object)"*");
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @Nullable
    public final Date component2() {
        return this.releaseDate;
    }

    @NotNull
    public final SingleVersion copy(@NotNull String value, @Nullable Date releaseDate) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new SingleVersion(value, releaseDate);
    }

    public static /* synthetic */ SingleVersion copy$default(SingleVersion singleVersion, String string, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            string = singleVersion.value;
        }
        if ((n & 2) != 0) {
            date = singleVersion.releaseDate;
        }
        return singleVersion.copy(string, date);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleVersion)) {
            return false;
        }
        SingleVersion singleVersion = (SingleVersion)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)singleVersion.value)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.releaseDate, (Object)singleVersion.releaseDate);
    }
}

