/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenLegacyModuleImporter;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDataWithDependencies;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportData;
import org.jetbrains.idea.maven.importing.tree.SplittedMainAndTestModules;
import org.jetbrains.idea.maven.importing.tree.dependency.AttachedJarDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.BaseDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.LibraryDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.MavenImportDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.ModuleDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.SystemDependency;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceModuleImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;

public class MavenModuleImportDependencyProvider {
    public static final int INITIAL_CAPACITY_TEST_DEPENDENCY_LIST = 4;
    @NotNull
    private final Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId;
    @NotNull
    private final Set<String> dependencyTypesFromSettings;
    @NotNull
    private final MavenProjectsTree myProjectTree;

    public MavenModuleImportDependencyProvider(@NotNull Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId, @NotNull MavenImportingSettings importingSettings, @NotNull MavenProjectsTree projectTree) {
        if (moduleImportDataByMavenId == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(0);
        }
        if (importingSettings == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(1);
        }
        if (projectTree == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(2);
        }
        this.moduleImportDataByMavenId = moduleImportDataByMavenId;
        this.dependencyTypesFromSettings = importingSettings.getDependencyTypesAsSet();
        this.myProjectTree = projectTree;
    }

    @NotNull
    public MavenModuleImportDataWithDependencies getDependencies(MavenProjectImportData importData) {
        MavenProject mavenProject2 = importData.getMavenProject();
        ArrayList mainDependencies = new ArrayList(mavenProject2.getDependencies().size());
        ArrayList testDependencies = new ArrayList(4);
        MavenModuleImportDependencyProvider.addMainDependencyToTestModule(importData, testDependencies);
        boolean hasSeparateTestModule = importData.getSplittedMainAndTestModules() != null;
        for (MavenArtifact artifact : mavenProject2.getDependencies()) {
            for (MavenImportDependency<?> dependency : this.getDependency(artifact, mavenProject2)) {
                if (hasSeparateTestModule && dependency.getScope() == DependencyScope.TEST) {
                    testDependencies.add(dependency);
                    continue;
                }
                mainDependencies.add(dependency);
            }
        }
        return new MavenModuleImportDataWithDependencies(importData, mainDependencies, testDependencies);
    }

    private static void addMainDependencyToTestModule(MavenProjectImportData importData, List<MavenImportDependency<?>> testDependencies) {
        if (importData.getSplittedMainAndTestModules() != null) {
            testDependencies.add(new ModuleDependency(importData.getSplittedMainAndTestModules().getMainData().getModuleName(), DependencyScope.COMPILE, false));
        }
    }

    @NotNull
    private List<MavenImportDependency<?>> getDependency(MavenArtifact artifact, MavenProject mavenProject2) {
        String dependencyType = artifact.getType();
        if (!this.dependencyTypesFromSettings.contains(dependencyType) && !mavenProject2.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) {
            List<MavenImportDependency<?>> list = Collections.emptyList();
            if (list == null) {
                MavenModuleImportDependencyProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        DependencyScope scope = MavenLegacyModuleImporter.selectScope(artifact.getScope());
        MavenProject depProject = this.myProjectTree.findProject(artifact.getMavenId());
        if (depProject != null) {
            if (depProject == mavenProject2) {
                List<MavenImportDependency<?>> list = Collections.emptyList();
                if (list == null) {
                    MavenModuleImportDependencyProvider.$$$reportNull$$$0(4);
                }
                return list;
            }
            MavenProjectImportData mavenProjectImportData = this.moduleImportDataByMavenId.get(depProject.getMavenId());
            if (mavenProjectImportData == null || this.myProjectTree.isIgnored(depProject)) {
                List<MavenImportDependency<?>> list = List.of(new BaseDependency(MavenLegacyModuleImporter.createCopyForLocalRepo(artifact, mavenProject2), scope));
                if (list == null) {
                    MavenModuleImportDependencyProvider.$$$reportNull$$$0(5);
                }
                return list;
            }
            ArrayList result2 = new ArrayList();
            boolean isTestJar = "test-jar".equals(dependencyType) || "tests".equals(artifact.getClassifier());
            String moduleName = MavenModuleImportDependencyProvider.getModuleName(mavenProjectImportData, isTestJar);
            ContainerUtil.addIfNotNull(result2, (Object)MavenModuleImportDependencyProvider.createAttachArtifactDependency(depProject, scope, artifact));
            String classifier = artifact.getClassifier();
            if (classifier != null && MavenLegacyModuleImporter.IMPORTED_CLASSIFIERS.contains(classifier) && !isTestJar && !"system".equals(artifact.getScope()) && !"false".equals(System.getProperty("idea.maven.classifier.dep"))) {
                result2.add(new LibraryDependency(MavenLegacyModuleImporter.createCopyForLocalRepo(artifact, mavenProject2), mavenProject2, scope));
            }
            result2.add(new ModuleDependency(moduleName, scope, isTestJar));
            ArrayList arrayList = result2;
            if (arrayList == null) {
                MavenModuleImportDependencyProvider.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        if ("system".equals(artifact.getScope())) {
            List<MavenImportDependency<?>> list = List.of(new SystemDependency(artifact, scope));
            if (list == null) {
                MavenModuleImportDependencyProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        if ("bundle".equals(dependencyType)) {
            artifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, mavenProject2.getLocalRepository(), false, false);
        }
        List<MavenImportDependency<?>> list = List.of(new BaseDependency(artifact, scope));
        if (list == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static String getModuleName(MavenProjectImportData data2, boolean isTestJar) {
        SplittedMainAndTestModules modules = data2.getSplittedMainAndTestModules();
        if (modules == null) {
            return data2.getModuleData().getModuleName();
        }
        return isTestJar ? modules.getTestData().getModuleName() : modules.getMainData().getModuleName();
    }

    @Nullable
    private static AttachedJarDependency createAttachArtifactDependency(@NotNull MavenProject mavenproject, @NotNull DependencyScope scope, @NotNull MavenArtifact artifact) {
        Element buildHelperCfg;
        if (mavenproject == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(10);
        }
        if (artifact == null) {
            MavenModuleImportDependencyProvider.$$$reportNull$$$0(11);
        }
        if ((buildHelperCfg = mavenproject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact")) == null) {
            return null;
        }
        ArrayList<Pair<String, LibraryRootTypeId>> roots = new ArrayList<Pair<String, LibraryRootTypeId>>();
        boolean create = false;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !typeString.equals("jar") || StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file")))) continue;
                String classifier = artifactElement.getChildTextTrim("classifier");
                if ("sources".equals(classifier)) {
                    roots.add((Pair<String, LibraryRootTypeId>)new Pair((Object)filePath, (Object)LibraryRootTypeId.Companion.getSOURCES()));
                } else if ("javadoc".equals(classifier)) {
                    roots.add((Pair<String, LibraryRootTypeId>)new Pair((Object)filePath, (Object)WorkspaceModuleImporter.Companion.getJAVADOC_TYPE()));
                } else {
                    roots.add((Pair<String, LibraryRootTypeId>)new Pair((Object)filePath, (Object)LibraryRootTypeId.Companion.getCOMPILED()));
                }
                create = true;
            }
        }
        return create ? new AttachedJarDependency(MavenLegacyModuleImporter.getAttachedJarsLibName(artifact), roots, scope) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleImportDataByMavenId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTree";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/tree/MavenModuleImportDependencyProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenproject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/tree/MavenModuleImportDependencyProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAttachArtifactDependency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

