/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.project.MavenProjectModelReadHelper;
import org.jetbrains.idea.maven.server.MavenServerManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectModelServerModelReadHelper;", "Lorg/jetbrains/idea/maven/project/MavenProjectModelReadHelper;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "assembleInheritance", "Lorg/jetbrains/idea/maven/model/MavenModel;", "projectPomDir", "Ljava/nio/file/Path;", "parent", "model", "interpolate", "basedir", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.maven"})
public final class MavenProjectModelServerModelReadHelper
implements MavenProjectModelReadHelper {
    @NotNull
    private final Project myProject;

    public MavenProjectModelServerModelReadHelper(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @Override
    @NotNull
    public MavenModel interpolate(@NotNull Path basedir, @NotNull VirtualFile file, @NotNull MavenModel model) {
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Path path2 = file.getParent().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
        Path pomDir = path2;
        MavenModel mavenModel = MavenServerManager.getInstance().getConnector(this.myProject, ((Object)basedir).toString()).interpolateAndAlignModel(model, basedir, pomDir);
        Intrinsics.checkNotNullExpressionValue((Object)mavenModel, (String)"interpolateAndAlignModel(...)");
        return mavenModel;
    }

    @Override
    @NotNull
    public MavenModel assembleInheritance(@NotNull Path projectPomDir, @Nullable MavenModel parent, @NotNull MavenModel model) {
        Intrinsics.checkNotNullParameter((Object)projectPomDir, (String)"projectPomDir");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MavenModel mavenModel = MavenServerManager.getInstance().getConnector(this.myProject, ((Object)projectPomDir.toAbsolutePath()).toString()).assembleInheritance(model, parent);
        Intrinsics.checkNotNullExpressionValue((Object)mavenModel, (String)"assembleInheritance(...)");
        return mavenModel;
    }
}

