/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenSystemIndicesManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenInSpecificPath;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.DummyIndexer;
import org.jetbrains.idea.maven.server.DummyMavenServerConnector;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenIndexingConnectorImpl;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerManagerEx;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

final class MavenServerManagerImpl
implements MavenServerManager {
    private final Map<String, MavenServerConnector> myMultimoduleDirToConnectorMap = new HashMap<String, MavenServerConnector>();
    private MavenIndexingConnectorImpl myIndexingConnector = null;
    private MavenIndexerWrapper myIndexerWrapper = null;
    private File eventListenerJar;

    MavenServerManagerImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                MavenServerManagerImpl.this.shutdown(false);
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ("org.jetbrains.idea.maven".equals(pluginDescriptor.getPluginId().getIdString())) {
                    MavenServerManagerImpl.this.shutdown(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/idea/maven/server/MavenServerManagerImpl$2", "beforePluginUnload"));
            }
        });
        connection.subscribe(TrustedProjectsListener.TOPIC, (Object)new TrustedProjectsListener(){

            public void onProjectTrusted(@NotNull Project project2) {
                MavenProjectsManager manager;
                if (project2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((manager = MavenProjectsManager.getInstance(project2)).isMavenizedProject()) {
                    MavenUtil.restartMavenConnectors(project2, true, it -> DummyMavenServerConnector.isDummy(it));
                }
            }

            public void onProjectUntrusted(@NotNull Project project2) {
                MavenProjectsManager manager;
                if (project2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((manager = MavenProjectsManager.getInstance(project2)).isMavenizedProject()) {
                    MavenUtil.restartMavenConnectors(project2, true, it -> !DummyMavenServerConnector.isDummy(it));
                }
            }

            public void onProjectTrustedFromNotification(@NotNull Project project2) {
                MavenProjectsManager manager;
                if (project2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((manager = MavenProjectsManager.getInstance(project2)).isMavenizedProject()) {
                    manager.forceUpdateAllProjectsOrFindAllAvailablePomFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectTrusted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectUntrusted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectTrustedFromNotification";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MavenServerConnector> getAllConnectors() {
        Set<MavenServerConnector> set = Collections.newSetFromMap(new IdentityHashMap());
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            set.addAll(this.myMultimoduleDirToConnectorMap.values());
            if (this.myIndexingConnector != null) {
                set.add(this.myIndexingConnector);
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartMavenConnectors(Project project2, boolean wait, Predicate<MavenServerConnector> condition) {
        ArrayList connectorsToShutDown = new ArrayList();
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            this.getAllConnectors().forEach(it -> {
                if (project2.equals(it.getProject()) && condition.test((MavenServerConnector)it)) {
                    connectorsToShutDown.add(this.removeConnector((MavenServerConnector)it));
                }
            });
        }
        MavenProjectsManager.getInstance(project2).getEmbeddersManager().reset();
        MavenServerManagerEx.stopConnectors(project2, wait, connectorsToShutDown);
    }

    private MavenServerConnector doGetConnector(@NotNull Project project2, @NotNull String workingDirectory) {
        MavenWorkspaceSettings settings;
        Sdk jdk2;
        String multimoduleDirectory;
        MavenServerConnector connector;
        if (project2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(1);
        }
        if ((connector = this.doGetOrCreateConnector(project2, multimoduleDirectory = MavenDistributionsCache.getInstance(project2).getMultimoduleDirectory(workingDirectory), jdk2 = MavenServerManagerImpl.getJdk(project2, settings = MavenWorkspaceSettingsComponent.getInstance(project2).getSettings()))).isNew()) {
            connector.connect();
        } else if (!MavenServerManagerImpl.compatibleParameters(project2, connector, jdk2, multimoduleDirectory)) {
            MavenLog.LOG.info("[connector] " + connector + " is incompatible, restarting");
            this.shutdownConnector(connector, false);
            connector = this.doGetOrCreateConnector(project2, multimoduleDirectory, jdk2);
            connector.connect();
        }
        if (MavenLog.LOG.isTraceEnabled()) {
            MavenLog.LOG.trace("[connector] get " + connector);
        }
        return connector;
    }

    @Override
    public MavenServerConnector getConnector(@NotNull Project project2, @NotNull String workingDirectory) {
        MavenServerConnector connector;
        if (project2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(2);
        }
        if (workingDirectory == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(3);
        }
        if (!(connector = this.doGetConnector(project2, workingDirectory)).ping()) {
            this.shutdownConnector(connector, true);
            connector = this.doGetConnector(project2, workingDirectory);
        }
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenServerConnector doGetOrCreateConnector(@NotNull Project project2, @NotNull String multimoduleDirectory, @NotNull Sdk jdk2) {
        MavenServerConnector connector;
        if (project2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(4);
        }
        if (multimoduleDirectory == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(5);
        }
        if (jdk2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(6);
        }
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            connector = this.myMultimoduleDirToConnectorMap.get(multimoduleDirectory);
            if (connector != null) {
                return connector;
            }
            connector = this.findCompatibleConnector(project2, jdk2, multimoduleDirectory);
            if (connector != null) {
                MavenLog.LOG.debug("[connector] use existing connector for " + connector);
                connector.addMultimoduleDir(multimoduleDirectory);
            } else {
                connector = this.registerNewConnector(project2, jdk2, multimoduleDirectory);
            }
            this.myMultimoduleDirToConnectorMap.put(multimoduleDirectory, connector);
        }
        return connector;
    }

    @Nullable
    private MavenServerConnector findCompatibleConnector(@NotNull Project project2, @NotNull Sdk jdk2, @NotNull String multimoduleDirectory) {
        if (project2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(7);
        }
        if (jdk2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(8);
        }
        if (multimoduleDirectory == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(9);
        }
        MavenDistribution distribution = MavenDistributionsCache.getInstance(project2).getMavenDistribution(multimoduleDirectory);
        String vmOptions = MavenDistributionsCache.getInstance(project2).getVmOptions(multimoduleDirectory);
        for (Map.Entry<String, MavenServerConnector> entry : this.myMultimoduleDirToConnectorMap.entrySet()) {
            if (!entry.getValue().getProject().equals(project2)) continue;
            if (Registry.is((String)"maven.server.per.idea.project")) {
                return entry.getValue();
            }
            if (!entry.getValue().isCompatibleWith(jdk2, vmOptions, distribution)) continue;
            return entry.getValue();
        }
        return null;
    }

    @NotNull
    private MavenServerConnector registerNewConnector(Project project2, Sdk jdk2, String multimoduleDirectory) {
        MavenServerConnector connector;
        MavenDistribution distribution = MavenDistributionsCache.getInstance(project2).getMavenDistribution(multimoduleDirectory);
        String vmOptions = MavenDistributionsCache.getInstance(project2).getVmOptions(multimoduleDirectory);
        Integer debugPort = MavenServerManagerImpl.getFreeDebugPort();
        if (TrustedProjects.isTrusted((Project)project2) || project2.isDefault()) {
            MavenServerManager.MavenServerConnectorFactory connectorFactory = (MavenServerManager.MavenServerConnectorFactory)ApplicationManager.getApplication().getService(MavenServerManager.MavenServerConnectorFactory.class);
            connector = connectorFactory.create(project2, jdk2, vmOptions, debugPort, distribution, multimoduleDirectory);
            MavenLog.LOG.debug("[connector] new maven connector " + connector);
        } else {
            MavenLog.LOG.warn("Project " + project2 + " not trusted enough. Will not start maven for it");
            connector = new DummyMavenServerConnector(project2, jdk2, vmOptions, distribution, multimoduleDirectory);
        }
        this.registerDisposable(project2, connector);
        MavenServerConnector mavenServerConnector = connector;
        if (mavenServerConnector == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(10);
        }
        return mavenServerConnector;
    }

    private void registerDisposable(Project project2, MavenServerConnector connector) {
        Disposer.register((Disposable)MavenDisposable.getInstance(project2), () -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.shutdownConnector(connector, true)));
    }

    public void dispose() {
        this.shutdown(false);
    }

    @Override
    public boolean shutdownConnector(MavenServerConnector connector, boolean wait) {
        MavenServerConnector connectorToStop = this.removeConnector(connector);
        if (connectorToStop == null) {
            return false;
        }
        connectorToStop.stop(wait);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenServerConnector removeConnector(@Nullable MavenServerConnector connector) {
        if (connector == null) {
            return null;
        }
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            if (this.myIndexingConnector == connector) {
                this.myIndexingConnector = null;
                this.myIndexerWrapper = null;
                return connector;
            }
            if (!this.myMultimoduleDirToConnectorMap.containsValue(connector)) {
                return null;
            }
            this.myMultimoduleDirToConnectorMap.entrySet().removeIf(e -> e.getValue() == connector);
        }
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean wait) {
        ArrayList<MavenServerConnector> values;
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            values = new ArrayList<MavenServerConnector>(this.myMultimoduleDirToConnectorMap.values());
        }
        this.shutdownConnector(this.myIndexingConnector, wait);
        values.forEach(c -> this.shutdownConnector((MavenServerConnector)c, wait));
    }

    @Override
    public File getMavenEventListener() {
        return this.getEventListenerJar();
    }

    private File getEventListenerJar() {
        if (this.eventListenerJar != null) {
            return this.eventListenerJar;
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        if (pluginFileOrDir.isDirectory()) {
            this.eventListenerJar = MavenServerManagerImpl.getEventSpyPathForLocalBuild();
            if (!this.eventListenerJar.exists()) {
                MavenLog.LOG.warn("Event listener does not exist: Please run rebuild for maven modules:\ncommunity/plugins/maven/maven-event-listener");
            }
        } else {
            this.eventListenerJar = new File(root, "maven-event-listener.jar");
            if (!this.eventListenerJar.exists()) {
                MavenLog.LOG.warn("Event listener does not exist at " + this.eventListenerJar + ". It should be built as part of plugin layout process and bundled along with maven plugin jars");
            }
        }
        return this.eventListenerJar;
    }

    @Override
    @NotNull
    public MavenEmbedderWrapper createEmbedder(final Project project2, final boolean alwaysOnline, final @NotNull String multiModuleProjectDirectory) {
        if (multiModuleProjectDirectory == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(11);
        }
        return new MavenEmbedderWrapper(project2){
            private MavenServerConnector myConnector;

            @Override
            @NotNull
            protected synchronized MavenServerEmbedder create() throws RemoteException {
                MavenServerSettings settings = MavenServerManagerImpl.convertSettings(project2, MavenProjectsManager.getInstance(project2).getGeneralSettings(), multiModuleProjectDirectory);
                if (alwaysOnline && settings.isOffline()) {
                    settings = settings.clone();
                    settings.setOffline(false);
                }
                RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(project2);
                String sdkPath = MavenUtil.getSdkPath(ProjectRootManager.getInstance((Project)project2).getProjectSdk());
                if (sdkPath != null) {
                    sdkPath = transformer.toRemotePath(sdkPath);
                }
                settings.setProjectJdk(sdkPath);
                boolean forceResolveDependenciesSequentially = Registry.is((String)"maven.server.force.resolve.dependencies.sequentially");
                boolean useCustomDependenciesResolver = Registry.is((String)"maven.server.use.custom.dependencies.resolver");
                this.myConnector = MavenServerManagerImpl.this.getConnector(project2, multiModuleProjectDirectory);
                MavenServerEmbedder mavenServerEmbedder = this.myConnector.createEmbedder(new MavenEmbedderSettings(settings, transformer.toRemotePath(multiModuleProjectDirectory), forceResolveDependenciesSequentially, useCustomDependenciesResolver));
                if (mavenServerEmbedder == null) {
                    4.$$$reportNull$$$0(0);
                }
                return mavenServerEmbedder;
            }

            @Override
            protected synchronized void cleanup() {
                super.cleanup();
                if (this.myConnector != null) {
                    MavenServerManagerImpl.this.shutdownConnector(this.myConnector, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManagerImpl$4", "create"));
            }
        };
    }

    @Override
    public MavenIndexerWrapper createIndexer() {
        return this.createDedicatedIndexer();
    }

    @Override
    public MavenIndexerWrapper createIndexer(@NotNull Project project2) {
        if (project2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(12);
        }
        if (Registry.is((String)"maven.dedicated.indexer")) {
            return this.createDedicatedIndexer();
        }
        return this.createLegacyIndexer(project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenIndexerWrapper createDedicatedIndexer() {
        if (this.myIndexerWrapper != null) {
            return this.myIndexerWrapper;
        }
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            if (this.myIndexerWrapper != null) {
                return this.myIndexerWrapper;
            }
            final String workingDir = SystemUtils.getUserHome().getAbsolutePath();
            this.myIndexerWrapper = new MavenIndexerWrapper(null){

                @Override
                protected MavenIndices createMavenIndices(Project project2) {
                    MavenIndices indices = new MavenIndices(this, MavenSystemIndicesManager.getInstance().getIndicesDir().toFile(), project2);
                    Disposer.register((Disposable)MavenDisposable.getInstance(project2), (Disposable)indices);
                    return indices;
                }

                @Override
                @NotNull
                protected MavenServerIndexer create() throws RemoteException {
                    MavenServerConnector indexingConnector = this.getIndexingConnector();
                    MavenServerIndexer mavenServerIndexer = indexingConnector.createIndexer();
                    if (mavenServerIndexer == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return mavenServerIndexer;
                }

                @Override
                protected synchronized void handleRemoteError(RemoteException e) {
                    MavenIndexingConnectorImpl indexingConnector;
                    super.handleRemoteError(e);
                    if (5.waitIfNotIdeaShutdown() && (indexingConnector = MavenServerManagerImpl.this.myIndexingConnector) != null && !indexingConnector.checkConnected()) {
                        MavenServerManagerImpl.this.shutdownConnector(indexingConnector, true);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private MavenServerConnector getIndexingConnector() {
                    if (MavenServerManagerImpl.this.myIndexingConnector != null) {
                        return MavenServerManagerImpl.this.myIndexingConnector;
                    }
                    Map<String, MavenServerConnector> map = MavenServerManagerImpl.this.myMultimoduleDirToConnectorMap;
                    synchronized (map) {
                        if (MavenServerManagerImpl.this.myIndexingConnector != null) {
                            return MavenServerManagerImpl.this.myIndexingConnector;
                        }
                        MavenServerManagerImpl.this.myIndexingConnector = new MavenIndexingConnectorImpl(JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk(), "", MavenServerManagerImpl.getFreeDebugPort(), (MavenDistribution)MavenDistributionsCache.resolveEmbeddedMavenHome(), workingDir);
                        MavenServerManagerImpl.this.myIndexingConnector.connect();
                    }
                    return MavenServerManagerImpl.this.myIndexingConnector;
                }

                private static boolean waitIfNotIdeaShutdown() {
                    try {
                        Thread.sleep(100L);
                        return true;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManagerImpl$5", "create"));
                }
            };
        }
        return this.myIndexerWrapper;
    }

    private MavenIndexerWrapper createLegacyIndexer(final @NotNull Project project2) {
        String path2;
        if (project2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(13);
        }
        if ((path2 = project2.getBasePath()) == null) {
            path2 = new File(".").getPath();
        }
        final String finalPath = path2;
        if (MavenWslUtil.tryGetWslDistributionForPath(path2) != null) {
            return new MavenIndexerWrapper(null){

                @Override
                protected MavenIndices createMavenIndices(Project project2) {
                    MavenIndices indices = new MavenIndices(this, MavenSystemIndicesManager.getInstance().getIndicesDir().toFile(), project2);
                    Disposer.register((Disposable)MavenDisposable.getInstance(project2), (Disposable)indices);
                    return indices;
                }

                @Override
                @NotNull
                protected MavenServerIndexer create() {
                    return new DummyIndexer();
                }
            };
        }
        return new MavenIndexerWrapper(null){

            @Override
            protected MavenIndices createMavenIndices(Project project22) {
                MavenIndices indices = new MavenIndices(this, MavenSystemIndicesManager.getInstance().getIndicesDir().toFile(), project22);
                Disposer.register((Disposable)MavenDisposable.getInstance(project22), (Disposable)indices);
                return indices;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            protected MavenServerIndexer create() throws RemoteException {
                MavenServerConnector connector;
                Map<String, MavenServerConnector> map = MavenServerManagerImpl.this.myMultimoduleDirToConnectorMap;
                synchronized (map) {
                    connector = (MavenServerConnector)ContainerUtil.find(MavenServerManagerImpl.this.myMultimoduleDirToConnectorMap.values(), c -> ContainerUtil.find(c.getMultimoduleDirectories(), mDir -> FileUtil.isAncestor((String)finalPath, (String)mDir, (boolean)false)) != null);
                }
                if (connector != null) {
                    MavenServerIndexer mavenServerIndexer = connector.createIndexer();
                    if (mavenServerIndexer == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return mavenServerIndexer;
                }
                String workingDirectory = (String)ObjectUtils.chooseNotNull((Object)project2.getBasePath(), (Object)SystemUtils.getUserHome().getAbsolutePath());
                MavenServerIndexer mavenServerIndexer = MavenServerManagerImpl.this.getConnector(project2, workingDirectory).createIndexer();
                if (mavenServerIndexer == null) {
                    7.$$$reportNull$$$0(1);
                }
                return mavenServerIndexer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManagerImpl$7", "create"));
            }
        };
    }

    private static Integer getFreeDebugPort() {
        if (Registry.is((String)"maven.server.debug")) {
            try {
                return NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static Sdk getJdk(Project project2, MavenWorkspaceSettings settings) {
        Sdk jdk2;
        String jdkForImporterName = settings.getImportingSettings().getJdkForImporter();
        try {
            jdk2 = MavenUtil.getJdk(project2, jdkForImporterName);
        }
        catch (ExternalSystemJdkException e) {
            jdk2 = MavenUtil.getJdk(project2, "#USE_PROJECT_JDK");
            MavenProjectsManager.getInstance(project2).getSyncConsole().addWarning(SyncBundle.message("importing.jdk.changed", new Object[0]), SyncBundle.message("importing.jdk.changed.description", jdkForImporterName, jdk2.getName()));
        }
        if (JavaSdkVersionUtil.isAtLeast((Sdk)jdk2, (JavaSdkVersion)JavaSdkVersion.JDK_1_8)) {
            Sdk sdk = jdk2;
            if (sdk == null) {
                MavenServerManagerImpl.$$$reportNull$$$0(14);
            }
            return sdk;
        }
        MavenLog.LOG.info("Selected jdk [" + jdk2.getName() + "] is not JDK1.8+ Will use internal jdk instead");
        Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        if (sdk == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(15);
        }
        return sdk;
    }

    private static boolean compatibleParameters(Project project2, MavenServerConnector connector, Sdk jdk2, String multimoduleDirectory) {
        if (Registry.is((String)"maven.server.per.idea.project")) {
            return true;
        }
        MavenDistributionsCache cache = MavenDistributionsCache.getInstance(project2);
        MavenDistribution distribution = cache.getMavenDistribution(multimoduleDirectory);
        String vmOptions = cache.getVmOptions(multimoduleDirectory);
        return connector.isCompatibleWith(jdk2, vmOptions, distribution);
    }

    private static File getEventSpyPathForLocalBuild() {
        File root = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        return new File(root.getParent(), "intellij.maven.server.eventListener");
    }

    private static MavenServerSettings convertSettings(@NotNull Project project2, @Nullable MavenGeneralSettings settings, @NotNull String multiModuleProjectDirectory) {
        if (project2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(16);
        }
        if (multiModuleProjectDirectory == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(17);
        }
        if (settings == null) {
            settings = MavenWorkspaceSettingsComponent.getInstance(project2).getSettings().getGeneralSettings();
        }
        RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(project2);
        MavenServerSettings result2 = new MavenServerSettings();
        result2.setLoggingLevel(settings.getOutputLevel().getLevel());
        result2.setOffline(settings.isWorkOffline());
        result2.setUpdateSnapshots(settings.isAlwaysUpdateSnapshots());
        MavenDistribution mavenDistribution = MavenDistributionsCache.getInstance(project2).getMavenDistribution(multiModuleProjectDirectory);
        String remotePath = transformer.toRemotePath(mavenDistribution.getMavenHome().toString());
        result2.setMavenHomePath(remotePath);
        File userSettings = MavenWslUtil.getUserSettings(project2, settings.getUserSettingsFile(), settings.getMavenConfig());
        String userSettingsPath = userSettings.toPath().toAbsolutePath().toString();
        result2.setUserSettingsPath(transformer.toRemotePath(userSettingsPath));
        String localRepository2 = MavenWslUtil.getLocalRepo(project2, settings.getLocalRepository(), new MavenInSpecificPath(mavenDistribution.getMavenHome().toFile()), settings.getUserSettingsFile(), settings.getMavenConfig()).getAbsolutePath();
        result2.setLocalRepositoryPath(transformer.toRemotePath(localRepository2));
        File file = MavenServerManagerImpl.getGlobalConfigFromMavenConfig(project2, settings, transformer);
        if (file == null) {
            file = MavenUtil.resolveGlobalSettingsFile(mavenDistribution.getMavenHome().toFile());
        }
        result2.setGlobalSettingsPath(transformer.toRemotePath(file.getAbsolutePath()));
        return result2;
    }

    @Nullable
    private static File getGlobalConfigFromMavenConfig(@NotNull Project project2, @NotNull MavenGeneralSettings settings, RemotePathTransformerFactory.Transformer transformer) {
        MavenConfig mavenConfig;
        if (project2 == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(18);
        }
        if (settings == null) {
            MavenServerManagerImpl.$$$reportNull$$$0(19);
        }
        if ((mavenConfig = settings.getMavenConfig()) == null) {
            return null;
        }
        String filePath = mavenConfig.getFilePath(MavenConfigSettings.ALTERNATE_GLOBAL_SETTINGS);
        if (filePath == null) {
            return null;
        }
        return new File(filePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multimoduleDirectory";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerManagerImpl";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiModuleProjectDirectory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManagerImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "registerNewConnector";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetConnector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConnector";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doGetOrCreateConnector";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCompatibleConnector";
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEmbedder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createIndexer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLegacyIndexer";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertSettings";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalConfigFromMavenConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 15 -> new IllegalStateException(string);
        };
    }
}

