/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public final class MavenProjectNamer {
    public static Map<MavenProject, String> generateNameMap(Collection<MavenProject> mavenProjects2) {
        MultiMap artifactIdMap = new MultiMap();
        for (MavenProject project2 : mavenProjects2) {
            artifactIdMap.putValue((Object)project2.getMavenId().getArtifactId(), (Object)project2);
        }
        HashMap<MavenProject, String> res = new HashMap<MavenProject, String>();
        for (Map.Entry entry : artifactIdMap.entrySet()) {
            List projectList = (List)entry.getValue();
            String artifactId = (String)entry.getKey();
            if (projectList.size() == 1) {
                res.put((MavenProject)projectList.get(0), artifactId);
                continue;
            }
            if (MavenProjectNamer.allGroupsAreDifferent(projectList)) {
                for (MavenProject mavenProject2 : projectList) {
                    res.put(mavenProject2, mavenProject2.getMavenId().getGroupId() + ":" + mavenProject2.getMavenId().getArtifactId());
                }
                continue;
            }
            if (MavenProjectNamer.allGroupsEqual(mavenProjects2)) {
                for (MavenProject mavenProject2 : projectList) {
                    res.put(mavenProject2, mavenProject2.getMavenId().getArtifactId() + ":" + mavenProject2.getMavenId().getVersion());
                }
                continue;
            }
            for (MavenProject mavenProject2 : projectList) {
                MavenId mavenId2 = mavenProject2.getMavenId();
                res.put(mavenProject2, mavenId2.getGroupId() + ":" + mavenId2.getArtifactId() + ":" + mavenId2.getVersion());
            }
        }
        return res;
    }

    private static boolean allGroupsEqual(Collection<MavenProject> mavenProjects2) {
        Iterator<MavenProject> itr = mavenProjects2.iterator();
        if (!itr.hasNext()) {
            return true;
        }
        String groupId = itr.next().getMavenId().getGroupId();
        while (itr.hasNext()) {
            MavenProject mavenProject2 = itr.next();
            if (Objects.equals(groupId, mavenProject2.getMavenId().getGroupId())) continue;
            return false;
        }
        return true;
    }

    private static boolean allGroupsAreDifferent(Collection<MavenProject> mavenProjects2) {
        HashSet<String> exitingGroups = new HashSet<String>();
        for (MavenProject mavenProject2 : mavenProjects2) {
            if (exitingGroups.add(mavenProject2.getMavenId().getGroupId())) continue;
            return false;
        }
        return true;
    }

    private static void doBuildProjectTree(MavenProjectsManager manager, Map<MavenProject, Integer> res, List<MavenProject> rootProjects, int depth) {
        MavenProject[] rootProjectArray = rootProjects.toArray(new MavenProject[0]);
        Arrays.sort(rootProjectArray, new MavenProjectComparator());
        for (MavenProject project2 : rootProjectArray) {
            if (res.containsKey(project2)) continue;
            res.put(project2, depth);
            MavenProjectNamer.doBuildProjectTree(manager, res, manager.getModules(project2), depth + 1);
        }
    }

    public static Map<MavenProject, Integer> buildProjectTree(MavenProjectsManager manager) {
        LinkedHashMap<MavenProject, Integer> res = new LinkedHashMap<MavenProject, Integer>();
        MavenProjectNamer.doBuildProjectTree(manager, res, manager.getRootProjects(), 0);
        return res;
    }

    public static class MavenProjectComparator
    implements Comparator<MavenProject> {
        @Override
        public int compare(MavenProject o1, MavenProject o2) {
            MavenId id1 = o1.getMavenId();
            MavenId id2 = o2.getMavenId();
            int res = Comparing.compare((Comparable)((Object)id1.getGroupId()), (Comparable)((Object)id2.getGroupId()));
            if (res != 0) {
                return res;
            }
            res = Comparing.compare((Comparable)((Object)id1.getArtifactId()), (Comparable)((Object)id2.getArtifactId()));
            if (res != 0) {
                return res;
            }
            res = Comparing.compare((Comparable)((Object)id1.getVersion()), (Comparable)((Object)id2.getVersion()));
            return res;
        }
    }
}

