/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RunViaSudoInfo;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SudoCliInteractionKt;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.process.SshExecProcess;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ssh/ProcessBuilder;", "", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lcom/intellij/ssh/ConnectionBuilder;Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "allocatePty", "", "changeDir", "sudoBundle", "Lcom/intellij/ssh/ProcessBuilder$SudoBundle;", "start", "Lcom/intellij/ssh/process/SshExecProcess;", "timeoutInSeconds", "", "withAllocatePty", "value", "withChangeDir", "withSudo", "passwordProvider", "Lcom/intellij/ssh/PasswordStringProvider;", "SudoBundle", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nremoteCredentialsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 remoteCredentialsUtil.kt\ncom/intellij/ssh/ProcessBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
public final class ProcessBuilder {
    @NotNull
    private final ConnectionBuilder connectionBuilder;
    @NotNull
    private final GeneralCommandLine commandLine;
    @Nullable
    private SudoBundle sudoBundle;
    private boolean changeDir;
    private boolean allocatePty;

    public ProcessBuilder(@NotNull ConnectionBuilder connectionBuilder2, @NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)connectionBuilder2, (String)"connectionBuilder");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        this.connectionBuilder = connectionBuilder2;
        this.commandLine = commandLine;
        this.changeDir = true;
        this.allocatePty = true;
    }

    @NotNull
    public final ProcessBuilder withChangeDir(boolean value) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$withChangeDir_u24lambda_u240 = processBuilder = this;
        boolean bl = false;
        $this$withChangeDir_u24lambda_u240.changeDir = value;
        return processBuilder;
    }

    @NotNull
    public final ProcessBuilder withSudo(@Nullable PasswordStringProvider passwordProvider) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$withSudo_u24lambda_u241 = processBuilder = this;
        boolean bl = false;
        $this$withSudo_u24lambda_u241.sudoBundle = passwordProvider != null ? new SudoBundle(RunViaSudoInfo.Companion.random(), passwordProvider) : null;
        return processBuilder;
    }

    @NotNull
    public final ProcessBuilder withAllocatePty(boolean value) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$withAllocatePty_u24lambda_u242 = processBuilder = this;
        boolean bl = false;
        $this$withAllocatePty_u24lambda_u242.allocatePty = value;
        return processBuilder;
    }

    @JvmOverloads
    @NotNull
    public final SshExecProcess start(int timeoutInSeconds) throws SshException {
        SudoBundle sudoBundleCopy;
        SudoBundle sudoBundle = sudoBundleCopy = this.sudoBundle;
        ExecBuilder execBuilder = RemoteCredentialsUtil.access$execBuilder(this.connectionBuilder, this.commandLine, this.changeDir, sudoBundle != null ? sudoBundle.getRunViaSudoInfo() : null, this.allocatePty);
        if (sudoBundleCopy != null) {
            execBuilder.withExecChannelWrapperFactory((Function1<? super ExecChannel, ? extends ExecChannel>)((Function1)new Function1<ExecChannel, ExecChannel>(sudoBundleCopy){
                final /* synthetic */ SudoBundle $sudoBundleCopy;
                {
                    this.$sudoBundleCopy = $sudoBundleCopy;
                    super(1);
                }

                @NotNull
                public final ExecChannel invoke(@NotNull ExecChannel it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return SudoCliInteractionKt.interactWithSudoOverSsh(it, this.$sudoBundleCopy.getRunViaSudoInfo(), this.$sudoBundleCopy.getPasswordProvider());
                }
            }));
        }
        SshExecProcess process2 = execBuilder.execute(timeoutInSeconds, this.commandLine.isRedirectErrorStream());
        return process2;
    }

    public static /* synthetic */ SshExecProcess start$default(ProcessBuilder processBuilder, int n, int n2, Object object) throws SshException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return processBuilder.start(n);
    }

    @JvmOverloads
    @NotNull
    public final SshExecProcess start() throws SshException {
        return ProcessBuilder.start$default(this, 0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ssh/ProcessBuilder$SudoBundle;", "", "runViaSudoInfo", "Lcom/intellij/ssh/RunViaSudoInfo;", "passwordProvider", "Lcom/intellij/ssh/PasswordStringProvider;", "(Lcom/intellij/ssh/RunViaSudoInfo;Lcom/intellij/ssh/PasswordStringProvider;)V", "getPasswordProvider", "()Lcom/intellij/ssh/PasswordStringProvider;", "getRunViaSudoInfo", "()Lcom/intellij/ssh/RunViaSudoInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ssh"})
    private static final class SudoBundle {
        @NotNull
        private final RunViaSudoInfo runViaSudoInfo;
        @NotNull
        private final PasswordStringProvider passwordProvider;

        public SudoBundle(@NotNull RunViaSudoInfo runViaSudoInfo, @NotNull PasswordStringProvider passwordProvider) {
            Intrinsics.checkNotNullParameter((Object)runViaSudoInfo, (String)"runViaSudoInfo");
            Intrinsics.checkNotNullParameter((Object)passwordProvider, (String)"passwordProvider");
            this.runViaSudoInfo = runViaSudoInfo;
            this.passwordProvider = passwordProvider;
        }

        @NotNull
        public final RunViaSudoInfo getRunViaSudoInfo() {
            return this.runViaSudoInfo;
        }

        @NotNull
        public final PasswordStringProvider getPasswordProvider() {
            return this.passwordProvider;
        }

        @NotNull
        public final RunViaSudoInfo component1() {
            return this.runViaSudoInfo;
        }

        @NotNull
        public final PasswordStringProvider component2() {
            return this.passwordProvider;
        }

        @NotNull
        public final SudoBundle copy(@NotNull RunViaSudoInfo runViaSudoInfo, @NotNull PasswordStringProvider passwordProvider) {
            Intrinsics.checkNotNullParameter((Object)runViaSudoInfo, (String)"runViaSudoInfo");
            Intrinsics.checkNotNullParameter((Object)passwordProvider, (String)"passwordProvider");
            return new SudoBundle(runViaSudoInfo, passwordProvider);
        }

        public static /* synthetic */ SudoBundle copy$default(SudoBundle sudoBundle, RunViaSudoInfo runViaSudoInfo, PasswordStringProvider passwordStringProvider, int n, Object object) {
            if ((n & 1) != 0) {
                runViaSudoInfo = sudoBundle.runViaSudoInfo;
            }
            if ((n & 2) != 0) {
                passwordStringProvider = sudoBundle.passwordProvider;
            }
            return sudoBundle.copy(runViaSudoInfo, passwordStringProvider);
        }

        @NotNull
        public String toString() {
            return "SudoBundle(runViaSudoInfo=" + this.runViaSudoInfo + ", passwordProvider=" + this.passwordProvider + ")";
        }

        public int hashCode() {
            int result2 = this.runViaSudoInfo.hashCode();
            result2 = result2 * 31 + this.passwordProvider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SudoBundle)) {
                return false;
            }
            SudoBundle sudoBundle = (SudoBundle)other;
            if (!Intrinsics.areEqual((Object)this.runViaSudoInfo, (Object)sudoBundle.runViaSudoInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.passwordProvider, (Object)sudoBundle.passwordProvider);
        }
    }
}

