/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.task.GradleTaskResultListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleProjectOutputsUpdater;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskResultListener;", "()V", "onSuccess", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "projectPath", "", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleProjectOutputsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectOutputsUpdater.kt\norg/jetbrains/plugins/gradle/service/GradleProjectOutputsUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n1360#2:45\n1446#2,5:46\n1549#2:51\n1620#2,3:52\n1603#2,9:55\n1855#2:64\n1856#2:66\n1612#2:67\n1#3:65\n37#4,2:68\n10#5:70\n*S KotlinDebug\n*F\n+ 1 GradleProjectOutputsUpdater.kt\norg/jetbrains/plugins/gradle/service/GradleProjectOutputsUpdater\n*L\n32#1:45\n32#1:46,5\n33#1:51\n33#1:52,3\n35#1:55,9\n35#1:64\n35#1:66\n35#1:67\n35#1:65\n37#1:68,2\n42#1:70\n*E\n"})
public final class GradleProjectOutputsUpdater
implements GradleTaskResultListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public void onSuccess(@NotNull ExternalSystemTaskId id, @NotNull String projectPath) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable list$iv$iv;
        DataNode it;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (!Registry.is((String)"gradle.refresh.project.outputs")) {
            return;
        }
        Project ideaProject = id.findProject();
        if (ideaProject == null) {
            LOG.warn("Project path [" + projectPath + "] does not belong to any open Gradle projects");
            return;
        }
        IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(ideaProject);
        DataNode dataNode = ExternalSystemApiUtil.findProjectNode((Project)ideaProject, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
        if (dataNode == null) {
            return;
        }
        DataNode projectNode = dataNode;
        Collection collection = ExternalSystemApiUtil.findAll((DataNode)projectNode, (Key)ProjectKeys.MODULE);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
        Collection moduleNodes = collection;
        String[] $this$flatMap$iv = (String[])moduleNodes;
        boolean $i$f$flatMap = false;
        String[] stringArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (DataNode)element$iv$iv;
            boolean bl = false;
            Collection collection2 = ExternalSystemApiUtil.findAll((DataNode)it, (Key)GradleSourceSetData.KEY);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findAll(...)");
            list$iv$iv = CollectionsKt.plus((Collection)collection2, (Object)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (DataNode)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add((ModuleData)it.getData());
        }
        $this$map$iv = CollectionsKt.filterIsInstance((Iterable)((List)destination$iv$iv), ModuleData.class);
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Module it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ModuleData it2 = (ModuleData)element$iv$iv;
            boolean bl2 = false;
            if (modelsProvider.findIdeModule(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List affectedModules = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = affectedModules;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = CompilerPaths.getOutputPaths((Module[])thisCollection$iv.toArray(new Module[0]));
        HashSet hashSet = ContainerUtil.newHashSet((Object[])Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        HashSet affectedRoots = hashSet;
        CompilerUtil.refreshOutputRoots((Collection)affectedRoots);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleProjectOutputsUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleProjectOutputsUpdater$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

