/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Namer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.metaobject.ConfigureDelegate;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.ConfigureUtil;

public abstract class AbstractNamedDomainObjectContainer<T>
extends DefaultNamedDomainObjectSet<T>
implements NamedDomainObjectContainer<T>,
HasPublicType {
    protected AbstractNamedDomainObjectContainer(Class<T> type, Instantiator instantiator2, Namer<? super T> namer, CollectionCallbackActionDecorator callbackDecorator) {
        super(type, instantiator2, namer, callbackDecorator);
    }

    protected AbstractNamedDomainObjectContainer(Class<T> type, Instantiator instantiator2, CollectionCallbackActionDecorator callbackActionDecorator) {
        super(type, instantiator2, Named.Namer.forType(type), callbackActionDecorator);
    }

    protected abstract T doCreate(String var1);

    @Override
    public T create(String name) {
        this.assertMutable("create(String)");
        return this.create(name, Actions.doNothing());
    }

    @Override
    public T maybeCreate(String name) {
        Object item = this.findByName(name);
        if (item != null) {
            return item;
        }
        return this.create(name);
    }

    @Override
    public T create(String name, Closure configureClosure) {
        this.assertMutable("create(String, Closure)");
        return this.create(name, ConfigureUtil.configureUsing(configureClosure));
    }

    @Override
    public T create(String name, Action<? super T> configureAction) throws InvalidUserDataException {
        this.assertMutable("create(String, Action)");
        this.assertCanAdd(name);
        T object = this.doCreate(name);
        this.add(object);
        configureAction.execute(object);
        return object;
    }

    protected ConfigureDelegate createConfigureDelegate(Closure configureClosure) {
        return new NamedDomainObjectContainerConfigureDelegate(configureClosure, this);
    }

    @Override
    public AbstractNamedDomainObjectContainer<T> configure(Closure configureClosure) {
        ConfigureDelegate delegate = this.createConfigureDelegate(configureClosure);
        ConfigureUtil.configureSelf(configureClosure, this, delegate);
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.getTypeDisplayName() + " container";
    }

    @Override
    public TypeOf<?> getPublicType() {
        return TypeOf.parameterizedTypeOf(new TypeOf<NamedDomainObjectContainer<?>>(){}, TypeOf.typeOf(this.getType()));
    }

    @Override
    public NamedDomainObjectProvider<T> register(String name) throws InvalidUserDataException {
        this.assertMutable("register(String)");
        return this.createDomainObjectProvider(name, null);
    }

    @Override
    public NamedDomainObjectProvider<T> register(String name, Action<? super T> configurationAction) throws InvalidUserDataException {
        this.assertMutable("register(String, Action)");
        return this.createDomainObjectProvider(name, configurationAction);
    }

    protected NamedDomainObjectProvider<T> createDomainObjectProvider(String name, @Nullable Action<? super T> configurationAction) {
        this.assertCanAdd(name);
        NamedDomainObjectProvider provider = (NamedDomainObjectProvider)Cast.uncheckedCast(this.getInstantiator().newInstance(NamedDomainObjectCreatingProvider.class, this, name, this.getType(), configurationAction));
        this.addLater(provider);
        return provider;
    }

    public class NamedDomainObjectCreatingProvider<I extends T>
    extends DefaultNamedDomainObjectCollection.AbstractDomainObjectCreatingProvider<I> {
        public NamedDomainObjectCreatingProvider(String name, @Nullable Class<I> type, Action<? super I> configureAction) {
            super(AbstractNamedDomainObjectContainer.this, name, type, configureAction);
        }

        @Override
        protected I createDomainObject() {
            return (I)Cast.uncheckedCast(AbstractNamedDomainObjectContainer.this.doCreate(this.getName()));
        }
    }
}

