/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

class DefaultRepositoryContentDescriptor
implements RepositoryContentDescriptorInternal {
    private Set<String> includedConfigurations;
    private Set<String> excludedConfigurations;
    private Set<ContentSpec> includeSpecs;
    private Set<ContentSpec> excludeSpecs;
    private Map<Attribute<Object>, Set<Object>> requiredAttributes;
    private boolean locked;
    private Action<? super ArtifactResolutionDetails> cachedAction;
    private final Supplier<String> repositoryNameSupplier;
    private final VersionSelectorScheme versionSelectorScheme;
    private final ConcurrentHashMap<String, VersionSelector> versionSelectors = new ConcurrentHashMap();
    private final VersionParser versionParser;

    public DefaultRepositoryContentDescriptor(Supplier<String> repositoryNameSupplier, VersionParser versionParser) {
        this.versionSelectorScheme = new DefaultVersionSelectorScheme(new DefaultVersionComparator(), versionParser);
        this.repositoryNameSupplier = repositoryNameSupplier;
        this.versionParser = versionParser;
    }

    protected VersionParser getVersionParser() {
        return this.versionParser;
    }

    private void assertMutable() {
        if (this.locked) {
            throw new IllegalStateException("Cannot mutate content repository descriptor '" + this.repositoryNameSupplier.get() + "' after repository has been used");
        }
    }

    @Override
    public Action<? super ArtifactResolutionDetails> toContentFilter() {
        if (this.cachedAction != null) {
            return this.cachedAction;
        }
        this.locked = true;
        if (this.includedConfigurations == null && this.excludedConfigurations == null && this.includeSpecs == null && this.excludeSpecs == null && this.requiredAttributes == null) {
            return Actions.doNothing();
        }
        this.cachedAction = new RepositoryFilterAction(DefaultRepositoryContentDescriptor.createSpecMatchers(this.includeSpecs), DefaultRepositoryContentDescriptor.createSpecMatchers(this.excludeSpecs));
        return this.cachedAction;
    }

    @Override
    public RepositoryContentDescriptorInternal asMutableCopy() {
        DefaultRepositoryContentDescriptor copy = new DefaultRepositoryContentDescriptor(this.repositoryNameSupplier, this.getVersionParser());
        if (this.includedConfigurations != null) {
            copy.includedConfigurations = Sets.newHashSet(this.includedConfigurations);
        }
        if (this.excludedConfigurations != null) {
            copy.excludedConfigurations = Sets.newHashSet(this.excludedConfigurations);
        }
        if (this.includeSpecs != null) {
            copy.includeSpecs = Sets.newHashSet(this.includeSpecs);
        }
        if (this.excludeSpecs != null) {
            copy.excludeSpecs = Sets.newHashSet(this.excludeSpecs);
        }
        if (this.requiredAttributes != null) {
            copy.requiredAttributes = Maps.newHashMap(this.requiredAttributes);
        }
        return copy;
    }

    @Nullable
    private static ImmutableList<SpecMatcher> createSpecMatchers(@Nullable Set<ContentSpec> specs) {
        ImmutableList matchers = null;
        if (specs != null) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)specs.size());
            for (ContentSpec spec : specs) {
                builder.add((Object)spec.toMatcher());
            }
            matchers = builder.build();
        }
        return matchers;
    }

    private static void checkNotNull(@Nullable String value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void includeGroup(String group) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        this.addInclude(group, null, null, MatcherKind.SIMPLE);
    }

    @Override
    public void includeGroupAndSubgroups(String groupPrefix) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupPrefix, "Group prefix cannot be null");
        this.addInclude(groupPrefix, null, null, MatcherKind.SUB_GROUP);
    }

    @Override
    public void includeGroupByRegex(String groupRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group regex cannot be null");
        this.addInclude(groupRegex, null, null, MatcherKind.REGEX);
    }

    @Override
    public void includeModule(String group, String moduleName) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        this.addInclude(group, moduleName, null, MatcherKind.REGEX);
    }

    @Override
    public void includeModuleByRegex(String groupRegex, String moduleNameRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group regex cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name regex cannot be null");
        this.addInclude(groupRegex, moduleNameRegex, null, MatcherKind.REGEX);
    }

    @Override
    public void includeVersion(String group, String moduleName, String version) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(version, "Version cannot be null");
        this.addInclude(group, moduleName, version, MatcherKind.SIMPLE);
    }

    @Override
    public void includeVersionByRegex(String groupRegex, String moduleNameRegex, String versionRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group regex cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name regex cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(versionRegex, "Version regex cannot be null");
        this.addInclude(groupRegex, moduleNameRegex, versionRegex, MatcherKind.REGEX);
    }

    private void addInclude(String group, @Nullable String moduleName, @Nullable String version, MatcherKind matcherKind) {
        this.assertMutable();
        if (this.includeSpecs == null) {
            this.includeSpecs = Sets.newHashSet();
        }
        this.includeSpecs.add(new ContentSpec(matcherKind, group, moduleName, version, this.versionSelectorScheme, this.versionSelectors, true));
    }

    @Override
    public void excludeGroup(String group) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        this.addExclude(group, null, null, MatcherKind.SIMPLE);
    }

    @Override
    public void excludeGroupAndSubgroups(String groupPrefix) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupPrefix, "Group prefix cannot be null");
        this.addExclude(groupPrefix, null, null, MatcherKind.SUB_GROUP);
    }

    @Override
    public void excludeGroupByRegex(String groupRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group regex cannot be null");
        this.addExclude(groupRegex, null, null, MatcherKind.REGEX);
    }

    @Override
    public void excludeModule(String group, String moduleName) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        this.addExclude(group, moduleName, null, MatcherKind.SIMPLE);
    }

    @Override
    public void excludeModuleByRegex(String groupRegex, String moduleNameRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group regex cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name regex cannot be null");
        this.addExclude(groupRegex, moduleNameRegex, null, MatcherKind.REGEX);
    }

    @Override
    public void excludeVersion(String group, String moduleName, String version) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(version, "Version cannot be null");
        this.addExclude(group, moduleName, version, MatcherKind.SIMPLE);
    }

    @Override
    public void excludeVersionByRegex(String groupRegex, String moduleNameRegex, String versionRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group regex cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name regex cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(versionRegex, "Version regex cannot be null");
        this.addExclude(groupRegex, moduleNameRegex, versionRegex, MatcherKind.REGEX);
    }

    private void addExclude(String group, @Nullable String moduleName, @Nullable String version, MatcherKind matcherKind) {
        this.assertMutable();
        if (this.excludeSpecs == null) {
            this.excludeSpecs = Sets.newHashSet();
        }
        this.excludeSpecs.add(new ContentSpec(matcherKind, group, moduleName, version, this.versionSelectorScheme, this.versionSelectors, false));
    }

    @Override
    public void onlyForConfigurations(String ... configurationNames) {
        if (this.includedConfigurations == null) {
            this.includedConfigurations = Sets.newHashSet();
        }
        Collections.addAll(this.includedConfigurations, configurationNames);
    }

    @Override
    public void notForConfigurations(String ... configurationNames) {
        if (this.excludedConfigurations == null) {
            this.excludedConfigurations = Sets.newHashSet();
        }
        Collections.addAll(this.excludedConfigurations, configurationNames);
    }

    @Override
    public <T> void onlyForAttribute(Attribute<T> attribute, T ... validValues) {
        if (this.requiredAttributes == null) {
            this.requiredAttributes = Maps.newHashMap();
        }
        this.requiredAttributes.put((Attribute)Cast.uncheckedCast(attribute), (Set<Object>)ImmutableSet.copyOf((Object[])validValues));
    }

    Supplier<String> getRepositoryNameSupplier() {
        return this.repositoryNameSupplier;
    }

    @Nullable
    Set<String> getIncludedConfigurations() {
        return this.includedConfigurations;
    }

    void setIncludedConfigurations(@Nullable Set<String> includedConfigurations) {
        this.includedConfigurations = includedConfigurations;
    }

    @Nullable
    Set<String> getExcludedConfigurations() {
        return this.excludedConfigurations;
    }

    void setExcludedConfigurations(@Nullable Set<String> excludedConfigurations) {
        this.excludedConfigurations = excludedConfigurations;
    }

    @Nullable
    Set<ContentSpec> getIncludeSpecs() {
        return this.includeSpecs;
    }

    void setIncludeSpecs(@Nullable Set<ContentSpec> includeSpecs) {
        this.includeSpecs = includeSpecs;
    }

    @Nullable
    Set<ContentSpec> getExcludeSpecs() {
        return this.excludeSpecs;
    }

    void setExcludeSpecs(@Nullable Set<ContentSpec> excludeSpecs) {
        this.excludeSpecs = excludeSpecs;
    }

    @Nullable
    Map<Attribute<Object>, Set<Object>> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    void setRequiredAttributes(@Nullable Map<Attribute<Object>, Set<Object>> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
    }

    private class RepositoryFilterAction
    implements Action<ArtifactResolutionDetails> {
        private final ImmutableList<SpecMatcher> includeMatchers;
        private final ImmutableList<SpecMatcher> excludeMatchers;

        public RepositoryFilterAction(@Nullable ImmutableList<SpecMatcher> includeMatchers, ImmutableList<SpecMatcher> excludeMatchers) {
            this.includeMatchers = includeMatchers;
            this.excludeMatchers = excludeMatchers;
        }

        @Override
        public void execute(ArtifactResolutionDetails details) {
            if (DefaultRepositoryContentDescriptor.this.includedConfigurations != null && !DefaultRepositoryContentDescriptor.this.includedConfigurations.contains(details.getConsumerName())) {
                details.notFound();
                return;
            }
            if (DefaultRepositoryContentDescriptor.this.excludedConfigurations != null && DefaultRepositoryContentDescriptor.this.excludedConfigurations.contains(details.getConsumerName())) {
                details.notFound();
                return;
            }
            if (this.includeMatchers != null && !this.anyMatch(this.includeMatchers, details)) {
                details.notFound();
                return;
            }
            if (this.excludeMatchers != null && this.anyMatch(this.excludeMatchers, details)) {
                details.notFound();
                return;
            }
            if (this.anyAttributesExcludes(details)) {
                details.notFound();
            }
        }

        private boolean anyAttributesExcludes(ArtifactResolutionDetails details) {
            if (DefaultRepositoryContentDescriptor.this.requiredAttributes != null) {
                AttributeContainer consumerAttributes = details.getConsumerAttributes();
                for (Map.Entry entry : DefaultRepositoryContentDescriptor.this.requiredAttributes.entrySet()) {
                    Object value;
                    Attribute key = (Attribute)entry.getKey();
                    Set allowedValues = (Set)entry.getValue();
                    if (allowedValues.contains(value = consumerAttributes.getAttribute(key))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean anyMatch(ImmutableList<SpecMatcher> matchers, ArtifactResolutionDetails details) {
            for (SpecMatcher matcher : matchers) {
                boolean matches = details.isVersionListing() ? matcher.matches(details.getModuleId()) : matcher.matches(details.getComponentId());
                if (!matches) continue;
                return true;
            }
            return false;
        }
    }

    private static class PatternSpecMatcher
    implements SpecMatcher {
        private final Pattern groupPattern;
        private final Pattern modulePattern;
        private final Pattern versionPattern;
        private final boolean inclusive;

        private PatternSpecMatcher(String group, @Nullable String module, @Nullable String version, boolean inclusive) {
            this.groupPattern = Pattern.compile(group);
            this.modulePattern = module == null ? null : Pattern.compile(module);
            this.versionPattern = version == null ? null : Pattern.compile(version);
            this.inclusive = inclusive;
        }

        @Override
        public boolean matches(ModuleIdentifier id) {
            return !(!this.groupPattern.matcher(id.getGroup()).matches() || this.modulePattern != null && !this.modulePattern.matcher(id.getName()).matches() || !this.inclusive && this.versionPattern != null);
        }

        @Override
        public boolean matches(ModuleComponentIdentifier id) {
            return !(!this.groupPattern.matcher(id.getGroup()).matches() || this.modulePattern != null && !this.modulePattern.matcher(id.getModule()).matches() || this.versionPattern != null && !this.versionPattern.matcher(id.getVersion()).matches());
        }
    }

    private static class SimpleSpecMatcher
    implements SpecMatcher {
        private final String group;
        private final String module;
        private final String version;
        private final VersionSelector versionSelector;
        private final boolean inclusive;
        private final boolean includeSubGroups;

        private SimpleSpecMatcher(String group, @Nullable String module, @Nullable String version, VersionSelectorScheme versionSelectorScheme, ConcurrentHashMap<String, VersionSelector> versionSelectors, boolean inclusive, boolean includeSubGroups) {
            this.group = group;
            this.module = module;
            this.version = version;
            this.inclusive = inclusive;
            this.includeSubGroups = includeSubGroups;
            this.versionSelector = this.getVersionSelector(versionSelectors, versionSelectorScheme, version);
        }

        private boolean groupMatches(String checkTarget) {
            if (!checkTarget.startsWith(this.group)) {
                return false;
            }
            if (checkTarget.length() == this.group.length()) {
                return true;
            }
            return this.includeSubGroups && checkTarget.charAt(this.group.length()) == '.';
        }

        @Override
        public boolean matches(ModuleIdentifier id) {
            return !(!this.groupMatches(id.getGroup()) || this.module != null && !this.module.equals(id.getName()) || !this.inclusive && this.version != null);
        }

        @Override
        public boolean matches(ModuleComponentIdentifier id) {
            return !(!this.groupMatches(id.getGroup()) || this.module != null && !this.module.equals(id.getModule()) || this.version != null && !this.version.equals(id.getVersion()) && !this.versionSelector.accept(id.getVersion()));
        }

        @Nullable
        private VersionSelector getVersionSelector(ConcurrentHashMap<String, VersionSelector> versionSelectors, VersionSelectorScheme versionSelectorScheme, @Nullable String version) {
            return version != null ? versionSelectors.computeIfAbsent(version, s -> versionSelectorScheme.parseSelector(version)) : null;
        }
    }

    private static interface SpecMatcher {
        public boolean matches(ModuleIdentifier var1);

        public boolean matches(ModuleComponentIdentifier var1);
    }

    private static class ContentSpec {
        private final MatcherKind matcherKind;
        private final String group;
        private final String module;
        private final String version;
        private final VersionSelectorScheme versionSelectorScheme;
        private final ConcurrentHashMap<String, VersionSelector> versionSelectors;
        private final boolean inclusive;
        private final int hashCode;

        private ContentSpec(MatcherKind matcherKind, String group, @Nullable String module, @Nullable String version, VersionSelectorScheme versionSelectorScheme, ConcurrentHashMap<String, VersionSelector> versionSelectors, boolean inclusive) {
            this.matcherKind = matcherKind;
            this.group = group;
            this.module = module;
            this.version = version;
            this.versionSelectorScheme = versionSelectorScheme;
            this.versionSelectors = versionSelectors;
            this.inclusive = inclusive;
            this.hashCode = Objects.hashCode((Object[])new Object[]{matcherKind, group, module, version, inclusive});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentSpec that = (ContentSpec)o;
            return this.matcherKind == that.matcherKind && this.hashCode == that.hashCode && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.inclusive, (Object)that.inclusive);
        }

        public int hashCode() {
            return this.hashCode;
        }

        SpecMatcher toMatcher() {
            switch (this.matcherKind) {
                case SIMPLE: 
                case SUB_GROUP: {
                    return new SimpleSpecMatcher(this.group, this.module, this.version, this.versionSelectorScheme, this.versionSelectors, this.inclusive, this.matcherKind == MatcherKind.SUB_GROUP);
                }
                case REGEX: {
                    return new PatternSpecMatcher(this.group, this.module, this.version, this.inclusive);
                }
            }
            throw new AssertionError((Object)("Unknown matcher kind: " + (Object)((Object)this.matcherKind)));
        }
    }

    private static enum MatcherKind {
        SIMPLE,
        REGEX,
        SUB_GROUP;

    }
}

