/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RelativePath;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public interface TransformExecutionResult {
    public ImmutableList<File> resolveOutputsForInputArtifact(File var1);

    public void visitOutputs(OutputVisitor var1);

    public int size();

    public static OutputTypeInferringBuilder builderFor(File inputArtifact, File outputDir) {
        return new OutputTypeInferringBuilder(inputArtifact, outputDir);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class OutputTypeInferringBuilder {
        private final File inputArtifact;
        private final File workspaceDir;
        private final String inputArtifactPrefix;
        private final String workspaceDirPrefix;
        private final Builder delegate = TransformExecutionResult.builder();

        public OutputTypeInferringBuilder(File inputArtifact, File workspaceDir) {
            this.inputArtifact = inputArtifact;
            this.workspaceDir = workspaceDir;
            this.inputArtifactPrefix = inputArtifact.getPath() + File.separator;
            this.workspaceDirPrefix = workspaceDir.getPath() + File.separator;
        }

        public void addOutput(File output, Consumer<File> workspaceAction) {
            if (output.equals(this.inputArtifact)) {
                this.delegate.addEntireInputArtifact();
            } else if (output.equals(this.workspaceDir) || output.getPath().startsWith(this.workspaceDirPrefix)) {
                this.delegate.addProducedOutput(output);
                workspaceAction.accept(output);
            } else if (output.getPath().startsWith(this.inputArtifactPrefix)) {
                String relativePath = RelativePath.parse(true, output.getPath().substring(this.inputArtifactPrefix.length())).getPathString();
                this.delegate.addPartOfInputArtifact(relativePath);
            } else {
                throw new InvalidUserDataException("Transform output " + output.getPath() + " must be a part of the input artifact or refer to a relative path.");
            }
        }

        public TransformExecutionResult build() {
            return this.delegate.build();
        }
    }

    public static interface OutputVisitor {
        public void visitEntireInputArtifact();

        public void visitPartOfInputArtifact(String var1);

        public void visitProducedOutput(File var1);
    }

    public static class Builder {
        private final ImmutableList.Builder<TransformOutput> builder = ImmutableList.builder();
        private boolean onlyProducedOutputs = true;

        public void addEntireInputArtifact() {
            this.onlyProducedOutputs = false;
            this.builder.add((Object)EntireInputArtifact.INSTANCE);
        }

        public void addPartOfInputArtifact(String relativePath) {
            this.onlyProducedOutputs = false;
            this.builder.add((Object)new PartOfInputArtifact(relativePath));
        }

        public void addProducedOutput(File outputLocation) {
            this.builder.add((Object)new ProducedOutput(outputLocation));
        }

        public TransformExecutionResult build() {
            ImmutableList transformOutputs = this.builder.build();
            return this.onlyProducedOutputs ? new ProducedOutputOnlyResult(Builder.convertToProducedOutputLocations((ImmutableList<TransformOutput>)transformOutputs)) : new FilteredResult((ImmutableList<TransformOutput>)transformOutputs);
        }

        private static ImmutableList<File> convertToProducedOutputLocations(ImmutableList<TransformOutput> transformOutputs) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            transformOutputs.forEach(output -> builder.add((Object)((ProducedOutput)output).getOutputLocation()));
            return builder.build();
        }

        private static class ProducedOutput
        implements TransformOutput {
            private final File outputFile;

            public ProducedOutput(File outputFile) {
                this.outputFile = outputFile;
            }

            public File getOutputLocation() {
                return this.outputFile;
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return this.outputFile;
            }

            @Override
            public void visitOutput(OutputVisitor visitor) {
                visitor.visitProducedOutput(this.outputFile);
            }
        }

        private static class EntireInputArtifact
        implements TransformOutput {
            public static final EntireInputArtifact INSTANCE = new EntireInputArtifact();

            private EntireInputArtifact() {
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return inputArtifact;
            }

            @Override
            public void visitOutput(OutputVisitor visitor) {
                visitor.visitEntireInputArtifact();
            }
        }

        private static class PartOfInputArtifact
        implements TransformOutput {
            private final String relativePath;

            public PartOfInputArtifact(String relativePath) {
                this.relativePath = relativePath;
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return new File(inputArtifact, this.relativePath);
            }

            @Override
            public void visitOutput(OutputVisitor visitor) {
                visitor.visitPartOfInputArtifact(this.relativePath);
            }
        }

        private static interface TransformOutput {
            public File resolveForInputArtifact(File var1);

            public void visitOutput(OutputVisitor var1);
        }

        private static class FilteredResult
        implements TransformExecutionResult {
            private final ImmutableList<TransformOutput> transformOutputs;

            public FilteredResult(ImmutableList<TransformOutput> transformOutputs) {
                this.transformOutputs = transformOutputs;
            }

            @Override
            public ImmutableList<File> resolveOutputsForInputArtifact(File inputArtifact) {
                ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.transformOutputs.size());
                this.transformOutputs.forEach(output -> builder.add((Object)output.resolveForInputArtifact(inputArtifact)));
                return builder.build();
            }

            @Override
            public void visitOutputs(OutputVisitor visitor) {
                this.transformOutputs.forEach(output -> output.visitOutput(visitor));
            }

            @Override
            public int size() {
                return this.transformOutputs.size();
            }
        }

        private static class ProducedOutputOnlyResult
        implements TransformExecutionResult {
            private final ImmutableList<File> producedOutputLocations;

            public ProducedOutputOnlyResult(ImmutableList<File> producedOutputLocations) {
                this.producedOutputLocations = producedOutputLocations;
            }

            @Override
            public ImmutableList<File> resolveOutputsForInputArtifact(File inputArtifact) {
                return this.producedOutputLocations;
            }

            @Override
            public void visitOutputs(OutputVisitor visitor) {
                this.producedOutputLocations.forEach(visitor::visitProducedOutput);
            }

            @Override
            public int size() {
                return this.producedOutputLocations.size();
            }
        }
    }
}

