/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.state.ModelObject;

public abstract class AbstractProperty<T, S extends ValueSupplier>
extends AbstractMinimalProvider<T>
implements PropertyInternal<T> {
    private static final FinalizedValue<Object> FINALIZED_VALUE = new FinalizedValue();
    private static final DisplayName DEFAULT_DISPLAY_NAME = Describables.of("this property");
    private static final DisplayName DEFAULT_VALIDATION_DISPLAY_NAME = Describables.of("a property");
    private ModelObject producer;
    private DisplayName displayName;
    private FinalizationState<S> state;
    private S value;

    public AbstractProperty(PropertyHost host) {
        this.state = new NonFinalizedValue(host);
    }

    protected void init(S initialValue, S convention) {
        this.value = initialValue;
        this.state.setConvention(convention);
    }

    protected void init(S initialValue) {
        this.init(initialValue, initialValue);
    }

    public boolean isFinalized() {
        return this.state instanceof FinalizedValue;
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        this.beforeRead(this.producer, consumer);
        try {
            return this.getSupplier().calculatePresence(consumer);
        }
        catch (Exception e) {
            if (this.displayName != null) {
                throw new PropertyQueryException(String.format("Failed to query the value of %s.", this.displayName), e);
            }
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    @Override
    public void attachOwner(@Nullable ModelObject owner, DisplayName displayName) {
        this.displayName = displayName;
    }

    @Override
    @Nullable
    protected DisplayName getDeclaredDisplayName() {
        return this.displayName;
    }

    @Override
    protected DisplayName getTypedDisplayName() {
        return DEFAULT_DISPLAY_NAME;
    }

    @Override
    protected DisplayName getDisplayName() {
        if (this.displayName == null) {
            return DEFAULT_DISPLAY_NAME;
        }
        return this.displayName;
    }

    protected DisplayName getValidationDisplayName() {
        if (this.displayName == null) {
            return DEFAULT_VALIDATION_DISPLAY_NAME;
        }
        return this.displayName;
    }

    @Override
    public void attachProducer(ModelObject owner) {
        if (this.producer == null) {
            this.producer = owner;
        } else if (this.producer != owner) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(this.getDisplayName().getCapitalizedDisplayName());
            formatter.append(" is already declared as an output property of ");
            this.format(this.producer, formatter);
            formatter.append(". Cannot also declare it as an output property of ");
            this.format(owner, formatter);
            formatter.append(".");
            throw new IllegalStateException(formatter.toString());
        }
    }

    protected S getSupplier() {
        return this.value;
    }

    protected ValueSupplier.Value<? extends T> calculateOwnValueNoProducer(ValueSupplier.ValueConsumer consumer) {
        this.beforeRead(null, consumer);
        return this.doCalculateValue(consumer);
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        this.beforeRead(this.producer, consumer);
        return this.doCalculateValue(consumer);
    }

    @Nonnull
    private ValueSupplier.Value<? extends T> doCalculateValue(ValueSupplier.ValueConsumer consumer) {
        try {
            return this.calculateValueFrom(this.value, consumer);
        }
        catch (Exception e) {
            if (this.displayName != null) {
                throw new PropertyQueryException(String.format("Failed to query the value of %s.", this.displayName), e);
            }
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    protected abstract ValueSupplier.Value<? extends T> calculateValueFrom(S var1, ValueSupplier.ValueConsumer var2);

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue<T> value = this.calculateOwnExecutionTimeValue(this.value);
        if (this.getProducerTask() == null) {
            return value;
        }
        return value.withChangingContent();
    }

    protected abstract ValueSupplier.ExecutionTimeValue<? extends T> calculateOwnExecutionTimeValue(S var1);

    protected abstract String describeContents();

    @Override
    public final String toString() {
        if (this.displayName != null) {
            return this.displayName.toString();
        }
        return this.describeContents();
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        Task task = this.getProducerTask();
        if (task != null) {
            return ValueSupplier.ValueProducer.task(task);
        }
        return this.getSupplier().getProducer();
    }

    @Override
    public void finalizeValue() {
        if (this.state.shouldFinalize(this.getDisplayName(), this.producer)) {
            this.finalizeNow(ValueSupplier.ValueConsumer.IgnoreUnsafeRead);
        }
    }

    @Override
    public void disallowChanges() {
        this.state.disallowChanges();
    }

    @Override
    public void finalizeValueOnRead() {
        this.state.finalizeOnNextGet();
    }

    @Override
    public void implicitFinalizeValue() {
        this.state.disallowChanges();
        this.state.finalizeOnNextGet();
    }

    @Override
    public void disallowUnsafeRead() {
        this.state.disallowUnsafeRead();
    }

    protected abstract S finalValue(S var1, ValueSupplier.ValueConsumer var2);

    protected void setSupplier(S supplier) {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.explicitValue(supplier);
    }

    protected void setConvention(S convention) {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.applyConvention(this.value, convention);
    }

    protected void beforeRead(ValueSupplier.ValueConsumer consumer) {
        this.beforeRead(this.producer, consumer);
    }

    private void beforeRead(@Nullable ModelObject effectiveProducer, ValueSupplier.ValueConsumer consumer) {
        if (this.state.maybeFinalizeOnRead(this.getDisplayName(), effectiveProducer, consumer)) {
            this.finalizeNow(this.state.forUpstream(consumer));
        }
    }

    private void finalizeNow(ValueSupplier.ValueConsumer consumer) {
        try {
            this.value = this.finalValue(this.value, this.state.forUpstream(consumer));
        }
        catch (Exception e) {
            if (this.displayName != null) {
                throw new PropertyQueryException(String.format("Failed to calculate the value of %s.", this.displayName), e);
            }
            throw UncheckedException.throwAsUncheckedException(e);
        }
        this.state = this.state.finalState();
    }

    protected S getExplicitValue(S defaultValue) {
        return (S)((ValueSupplier)this.state.explicitValue(this.value, defaultValue));
    }

    protected void discardValue() {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.implicitValue();
    }

    protected void assertCanMutate() {
        this.state.beforeMutate(this.getDisplayName());
    }

    @Nullable
    private Task getProducerTask() {
        if (this.producer == null) {
            return null;
        }
        Task task = this.producer.getTaskThatOwnsThisObject();
        if (task == null) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(this.getDisplayName().getCapitalizedDisplayName());
            formatter.append(" is declared as an output property of ");
            this.format(this.producer, formatter);
            formatter.append(" but does not have a task associated with it.");
            throw new IllegalStateException(formatter.toString());
        }
        return task;
    }

    private void format(ModelObject modelObject, TreeFormatter formatter) {
        if (modelObject.getModelIdentityDisplayName() != null) {
            formatter.append(modelObject.getModelIdentityDisplayName().getDisplayName());
            formatter.append(" (type ");
            formatter.appendType(modelObject.getClass());
            formatter.append(")");
        } else if (modelObject.hasUsefulDisplayName()) {
            formatter.append(modelObject.toString());
            formatter.append(" (type ");
            formatter.appendType(modelObject.getClass());
            formatter.append(")");
        } else {
            formatter.append("an object with type ");
            formatter.appendType(modelObject.getClass());
        }
    }

    private static class FinalizedValue<S>
    extends FinalizationState<S> {
        private FinalizedValue() {
        }

        @Override
        public boolean shouldFinalize(DisplayName displayName, @Nullable ModelObject producer) {
            return false;
        }

        @Override
        public void disallowChanges() {
        }

        @Override
        public void finalizeOnNextGet() {
        }

        @Override
        public void disallowUnsafeRead() {
        }

        @Override
        public boolean maybeFinalizeOnRead(DisplayName displayName, @Nullable ModelObject producer, ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public void beforeMutate(DisplayName displayName) {
            throw new IllegalStateException(String.format("The value for %s is final and cannot be changed any further.", displayName.getDisplayName()));
        }

        @Override
        public ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer consumer) {
            throw this.unexpected();
        }

        @Override
        public S explicitValue(S value) {
            throw this.unexpected();
        }

        @Override
        public S explicitValue(S value, S defaultValue) {
            throw this.unexpected();
        }

        @Override
        public S applyConvention(S value, S convention) {
            throw this.unexpected();
        }

        @Override
        public S implicitValue() {
            throw this.unexpected();
        }

        @Override
        public FinalizationState<S> finalState() {
            return this;
        }

        @Override
        void setConvention(S convention) {
            throw this.unexpected();
        }

        private UnsupportedOperationException unexpected() {
            return new UnsupportedOperationException("This property is in an unexpected state.");
        }
    }

    private static class NonFinalizedValue<S>
    extends FinalizationState<S> {
        private final PropertyHost host;
        private boolean explicitValue;
        private boolean finalizeOnNextGet;
        private boolean disallowChanges;
        private boolean disallowUnsafeRead;
        private S convention;

        public NonFinalizedValue(PropertyHost host) {
            this.host = host;
        }

        @Override
        public boolean shouldFinalize(DisplayName displayName, @Nullable ModelObject producer) {
            String reason;
            if (this.disallowUnsafeRead && (reason = this.host.beforeRead(producer)) != null) {
                throw new IllegalStateException(this.cannotFinalizeValueOf(displayName, reason));
            }
            return true;
        }

        @Override
        public FinalizationState<S> finalState() {
            return (FinalizationState)Cast.uncheckedCast(FINALIZED_VALUE);
        }

        @Override
        public boolean maybeFinalizeOnRead(DisplayName displayName, @Nullable ModelObject producer, ValueSupplier.ValueConsumer consumer) {
            String reason;
            if ((this.disallowUnsafeRead || consumer == ValueSupplier.ValueConsumer.DisallowUnsafeRead) && (reason = this.host.beforeRead(producer)) != null) {
                throw new IllegalStateException(this.cannotQueryValueOf(displayName, reason));
            }
            return this.finalizeOnNextGet || consumer == ValueSupplier.ValueConsumer.DisallowUnsafeRead;
        }

        @Override
        public ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer consumer) {
            if (this.disallowUnsafeRead) {
                return ValueSupplier.ValueConsumer.DisallowUnsafeRead;
            }
            return consumer;
        }

        @Override
        public void beforeMutate(DisplayName displayName) {
            if (this.disallowChanges) {
                throw new IllegalStateException(String.format("The value for %s cannot be changed any further.", displayName.getDisplayName()));
            }
        }

        @Override
        public void disallowChanges() {
            this.disallowChanges = true;
        }

        @Override
        public void finalizeOnNextGet() {
            this.finalizeOnNextGet = true;
        }

        @Override
        public void disallowUnsafeRead() {
            this.disallowUnsafeRead = true;
            this.finalizeOnNextGet = true;
        }

        @Override
        public S explicitValue(S value) {
            this.explicitValue = true;
            return value;
        }

        @Override
        public S explicitValue(S value, S defaultValue) {
            if (!this.explicitValue) {
                return defaultValue;
            }
            return value;
        }

        @Override
        public S implicitValue() {
            this.explicitValue = false;
            return this.convention;
        }

        @Override
        public S applyConvention(S value, S convention) {
            this.convention = convention;
            if (!this.explicitValue) {
                return convention;
            }
            return value;
        }

        @Override
        void setConvention(S convention) {
            this.convention = convention;
        }

        private String cannotFinalizeValueOf(DisplayName displayName, String reason) {
            return this.cannot("finalize", displayName, reason);
        }

        private String cannotQueryValueOf(DisplayName displayName, String reason) {
            return this.cannot("query", displayName, reason);
        }

        private String cannot(String what, DisplayName displayName, String reason) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Cannot " + what + " the value of ");
            formatter.append(displayName.getDisplayName());
            formatter.append(" because ");
            formatter.append(reason);
            formatter.append(".");
            return formatter.toString();
        }
    }

    private static abstract class FinalizationState<S> {
        private FinalizationState() {
        }

        public abstract boolean shouldFinalize(DisplayName var1, @Nullable ModelObject var2);

        public abstract FinalizationState<S> finalState();

        abstract void setConvention(S var1);

        public abstract void disallowChanges();

        public abstract void finalizeOnNextGet();

        public abstract void disallowUnsafeRead();

        public abstract S explicitValue(S var1);

        public abstract S explicitValue(S var1, S var2);

        public abstract S applyConvention(S var1, S var2);

        public abstract S implicitValue();

        public abstract boolean maybeFinalizeOnRead(DisplayName var1, @Nullable ModelObject var2, ValueSupplier.ValueConsumer var3);

        public abstract void beforeMutate(DisplayName var1);

        public abstract ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer var1);
    }

    @Contextual
    public static class PropertyQueryException
    extends RuntimeException {
        public PropertyQueryException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

