/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemBuilder;
import org.gradle.api.problems.ProblemBuilderDefiningDocumentation;
import org.gradle.api.problems.ProblemBuilderDefiningGroup;
import org.gradle.api.problems.ProblemBuilderDefiningLabel;
import org.gradle.api.problems.ProblemBuilderDefiningLocation;
import org.gradle.api.problems.ProblemBuilderDefiningType;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DefaultProblemLocation;
import org.gradle.api.problems.internal.DefaultReportableProblem;
import org.gradle.api.problems.internal.InternalProblems;

@Incubating
public class DefaultProblemBuilder
implements ProblemBuilder,
ProblemBuilderDefiningDocumentation,
ProblemBuilderDefiningLocation,
ProblemBuilderDefiningGroup,
ProblemBuilderDefiningLabel,
ProblemBuilderDefiningType {
    private ProblemGroup problemGroup;
    private String label;
    private String problemType;
    private final InternalProblems problemsService;
    private Severity severity;
    private String path;
    private Integer line;
    private Integer column;
    private boolean noLocation = false;
    private String description;
    private DocLink documentationUrl;
    private boolean explicitlyUndocumented = false;
    private List<String> solution;
    private RuntimeException exception;
    protected final Map<String, String> additionalMetadata = new HashMap<String, String>();

    public DefaultProblemBuilder(InternalProblems problemsService) {
        this.problemsService = problemsService;
    }

    @Override
    public ProblemBuilder group(String group) {
        if (this.problemsService != null) {
            ProblemGroup existingGroup = this.problemsService.getProblemGroup(group);
            if (existingGroup == null) {
                throw new GradleException("Problem group " + group + " does not exist, either use existing group or register a new one");
            }
            this.problemGroup = existingGroup;
        }
        return this;
    }

    @Override
    public ProblemBuilderDefiningDocumentation label(String label, Object ... args) {
        this.label = String.format(label, args);
        return this;
    }

    @Override
    public ProblemBuilder severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public ProblemBuilderDefiningType location(String path, Integer line) {
        this.path = path;
        this.line = line;
        return this;
    }

    @Override
    public ProblemBuilderDefiningType location(String path, Integer line, Integer column) {
        this.path = path;
        this.line = line;
        this.column = column;
        return this;
    }

    @Override
    public ProblemBuilderDefiningType noLocation() {
        this.noLocation = true;
        return this;
    }

    @Override
    public ProblemBuilder details(String details) {
        this.description = details;
        return this;
    }

    @Override
    public ProblemBuilderDefiningLocation documentedAt(DocLink doc) {
        this.documentationUrl = doc;
        return this;
    }

    @Override
    public ProblemBuilderDefiningLocation undocumented() {
        this.explicitlyUndocumented = true;
        return this;
    }

    @Override
    public ProblemBuilderDefiningGroup type(String problemType) {
        this.problemType = problemType;
        return this;
    }

    @Override
    public ProblemBuilder solution(@Nullable String solution) {
        if (this.solution == null) {
            this.solution = new ArrayList<String>();
        }
        this.solution.add(solution);
        return this;
    }

    @Override
    public ProblemBuilder additionalData(String key, String value) {
        this.additionalMetadata.put(key, value);
        return this;
    }

    @Override
    public ProblemBuilder withException(RuntimeException e) {
        this.exception = e;
        return this;
    }

    @Override
    public ReportableProblem build() {
        return this.buildInternal(null, true);
    }

    @Nonnull
    private ReportableProblem buildInternal(@Nullable Severity severity, boolean reportable) {
        if (!this.explicitlyUndocumented && this.documentationUrl == null) {
            throw new IllegalStateException("Problem is not documented: " + this.label);
        }
        if (!this.noLocation) {
            if (this.path == null) {
                throw new IllegalStateException("Problem location path is not set: " + this.label);
            }
            if (this.line == null) {
                throw new IllegalStateException("Problem location line is not set: " + this.label);
            }
        }
        return new DefaultReportableProblem(this.problemGroup, this.label, this.getSeverity(severity), this.getProblemLocation(), this.documentationUrl, this.description, this.solution, this.exception, this.problemType, this.additionalMetadata, reportable ? this.problemsService : null);
    }

    @Nullable
    private ProblemLocation getProblemLocation() {
        return this.path == null ? null : new DefaultProblemLocation(this.path, this.line, this.column);
    }

    @Nonnull
    private Severity getSeverity(@Nullable Severity severity) {
        if (severity != null) {
            return severity;
        }
        return this.getSeverity();
    }

    private Severity getSeverity() {
        if (this.severity == null) {
            return Severity.WARNING;
        }
        return this.severity;
    }

    public void report() {
        ReportableProblem problem2 = this.build();
        this.report(problem2);
    }

    private void report(Problem problem2) {
        this.problemsService.reportAsProgressEvent(problem2);
    }

    RuntimeException getException() {
        return this.exception;
    }
}

