/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;
import org.gradle.internal.impldep.org.apache.maven.settings.Settings;
import org.gradle.internal.impldep.org.apache.maven.settings.building.SettingsBuildingException;
import org.gradle.internal.impldep.org.gradleinternal.buildinit.plugins.internal.maven.Maven2GradleWorkAction;
import org.gradle.internal.impldep.org.gradleinternal.buildinit.plugins.internal.maven.MavenConversionException;
import org.gradle.util.internal.IncubationLogger;
import org.gradle.workers.WorkerExecutor;

public class PomProjectInitDescriptor
implements BuildConverter {
    private static final String MAVEN_VERSION = "3.9.3";
    private static final String MAVEN_WAGON_VERSION = "3.5.3";
    private static final String MAVEN_RESOLVER_VERSION = "1.9.13";
    private final MavenSettingsProvider settingsProvider;
    private final DocumentationRegistry documentationRegistry;
    private final WorkerExecutor executor;
    private FileCollection mavenClasspath;

    public PomProjectInitDescriptor(MavenSettingsProvider mavenSettingsProvider, DocumentationRegistry documentationRegistry, WorkerExecutor executor) {
        this.settingsProvider = mavenSettingsProvider;
        this.documentationRegistry = documentationRegistry;
        this.executor = executor;
    }

    @Override
    public String getId() {
        return "pom";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.BASIC;
    }

    @Override
    public Language getLanguage() {
        return Language.NONE;
    }

    @Override
    public boolean supportsJavaTargets() {
        return false;
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return Collections.singleton(ModularizationOption.SINGLE_PROJECT);
    }

    @Override
    public String getSourceBuildDescription() {
        return "Maven";
    }

    @Override
    public void configureClasspath(ProjectInternal.DetachedResolver detachedResolver, ObjectFactory objects, JvmPluginServices jvmPluginServices) {
        DependencyHandler dependencies = detachedResolver.getDependencies();
        Configuration config = detachedResolver.getConfigurations().detachedConfiguration(dependencies.create("org.apache.maven:maven-core:3.9.3"), dependencies.create("org.apache.maven:maven-plugin-api:3.9.3"), dependencies.create("org.apache.maven:maven-compat:3.9.3"), dependencies.create("org.apache.maven.wagon:wagon-http:3.5.3"), dependencies.create("org.apache.maven.wagon:wagon-provider-api:3.5.3"), dependencies.create("org.apache.maven.resolver:maven-resolver-connector-basic:1.9.13"), dependencies.create("org.apache.maven.resolver:maven-resolver-transport-wagon:1.9.13"));
        jvmPluginServices.configureAsRuntimeClasspath(config);
        detachedResolver.getRepositories().mavenCentral();
        this.mavenClasspath = config;
    }

    @Override
    public void generate(InitSettings initSettings) {
        IncubationLogger.incubatingFeatureUsed("Maven to Gradle conversion");
        try {
            Settings settings = this.settingsProvider.buildSettings();
            this.executor.classLoaderIsolation(config -> config.getClasspath().from(this.mavenClasspath)).submit(Maven2GradleWorkAction.class, params -> {
                params.getWorkingDir().set(initSettings.getTarget());
                params.getDsl().set(initSettings.getDsl());
                params.getUseIncubatingAPIs().set(initSettings.isUseIncubatingAPIs());
                params.getMavenSettings().set(settings);
                params.getInsecureProtocolOption().set(initSettings.getInsecureProtocolOption());
            });
        }
        catch (SettingsBuildingException exception) {
            throw new MavenConversionException(String.format("Could not convert Maven POM %s to a Gradle build.", initSettings.getTarget().file("pom.xml").getAsFile()), (Throwable)exception);
        }
    }

    @Override
    public boolean supportsProjectName() {
        return false;
    }

    @Override
    public boolean canApplyToCurrentDirectory(Directory current) {
        return current.file("pom.xml").getAsFile().isFile();
    }

    @Override
    public Set<BuildInitDsl> getDsls() {
        return new TreeSet<BuildInitDsl>(Arrays.asList(BuildInitDsl.values()));
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return BuildInitDsl.KOTLIN;
    }

    @Override
    public boolean supportsPackage() {
        return false;
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.NONE;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.NONE);
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return Optional.of(this.documentationRegistry.getDocumentationRecommendationFor("information", "migrating_from_maven"));
    }
}

