/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.services;

import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.internal.NextGenBuildCacheService;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.DefaultNextGenBuildCacheAccess;
import org.gradle.caching.internal.controller.GZipNextGenBuildCacheAccess;
import org.gradle.caching.internal.controller.NextGenBuildCacheController;
import org.gradle.caching.internal.controller.RemoteNextGenBuildCacheServiceHandler;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.services.AbstractBuildCacheControllerFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.H2BuildCacheService;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.file.BufferProvider;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.util.internal.IncubationLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public final class NextGenBuildCacheControllerFactory
extends AbstractBuildCacheControllerFactory<H2BuildCacheService> {
    private final Deleter deleter;
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final ExecutorFactory executorFactory;
    private final BufferProvider bufferProvider;
    private static final RemoteNextGenBuildCacheServiceHandler DISABLED_BUILD_CACHE_SERVICE_HANDLER = new RemoteNextGenBuildCacheServiceHandler(){

        @Override
        public boolean canLoad() {
            return false;
        }

        @Override
        public boolean canStore() {
            return false;
        }

        @Override
        public void disableOnError() {
        }

        @Override
        public boolean contains(BuildCacheKey key) {
            return false;
        }

        @Override
        public boolean load(BuildCacheKey key, BuildCacheEntryReader reader2) throws BuildCacheException {
            return false;
        }

        @Override
        public void store(BuildCacheKey key, NextGenBuildCacheService.NextGenWriter writer2) throws BuildCacheException {
        }

        @Override
        public void close() {
        }
    };

    public NextGenBuildCacheControllerFactory(StartParameter startParameter, BuildOperationExecutor buildOperationExecutor, OriginMetadataFactory originMetadataFactory, FileSystemAccess fileSystemAccess, StringInterner stringInterner, Deleter deleter, BuildInvocationScopeId buildInvocationScopeId, ExecutorFactory executorFactory, BufferProvider bufferProvider) {
        super(startParameter, buildOperationExecutor, originMetadataFactory, fileSystemAccess, stringInterner);
        this.deleter = deleter;
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.executorFactory = executorFactory;
        this.bufferProvider = bufferProvider;
    }

    @Override
    protected BuildCacheController doCreateController(@Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<DirectoryBuildCache, H2BuildCacheService> localDescribedService, @Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<BuildCache, BuildCacheService> remoteDescribedService) {
        IncubationLogger.incubatingFeatureUsed("Next generation build cache");
        if (localDescribedService == null) {
            throw new NullPointerException("Local cache shouldn't be null");
        }
        NextGenBuildCacheService local = (NextGenBuildCacheService)localDescribedService.service;
        RemoteNextGenBuildCacheServiceHandler remote = NextGenBuildCacheControllerFactory.resolveRemoteService(remoteDescribedService);
        NOPLogger logger = this.startParameter.isBuildCacheDebugLogging() ? LoggerFactory.getLogger(NextGenBuildCacheController.class) : NOPLogger.NOP_LOGGER;
        return new NextGenBuildCacheController(this.buildInvocationScopeId.getId().asString(), (Logger)logger, this.deleter, this.fileSystemAccess, this.bufferProvider, this.stringInterner, this.buildOperationExecutor, new GZipNextGenBuildCacheAccess(new DefaultNextGenBuildCacheAccess(local, remote, this.bufferProvider, this.executorFactory, (Logger)logger), this.bufferProvider));
    }

    private static RemoteNextGenBuildCacheServiceHandler resolveRemoteService(@Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<? extends BuildCache, ? extends BuildCacheService> describedService) {
        return describedService != null && ((BuildCache)describedService.config).isEnabled() ? new DefaultRemoteNextGenBuildCacheServiceHandler(NextGenBuildCacheControllerFactory.makeCompatible((BuildCacheService)describedService.service), ((BuildCache)describedService.config).isPush()) : DISABLED_BUILD_CACHE_SERVICE_HANDLER;
    }

    private static NextGenBuildCacheService makeCompatible(final BuildCacheService service) {
        if (service instanceof NextGenBuildCacheService) {
            return (NextGenBuildCacheService)service;
        }
        return new NextGenBuildCacheService(){

            @Override
            public boolean contains(BuildCacheKey key) {
                return this.load(key, __ -> {});
            }

            @Override
            public boolean load(BuildCacheKey key, BuildCacheEntryReader reader2) throws BuildCacheException {
                return service.load(key, reader2);
            }

            @Override
            public void store(BuildCacheKey key, BuildCacheEntryWriter legacyWriter) throws BuildCacheException {
                service.store(key, legacyWriter);
            }

            @Override
            public void store(BuildCacheKey key, NextGenBuildCacheService.NextGenWriter writer2) throws BuildCacheException {
                service.store(key, writer2);
            }

            @Override
            public void close() throws IOException {
                service.close();
            }
        };
    }

    private static class DefaultRemoteNextGenBuildCacheServiceHandler
    implements RemoteNextGenBuildCacheServiceHandler {
        private final NextGenBuildCacheService service;
        private final boolean pushEnabled;
        private volatile boolean disabledOnError;

        public DefaultRemoteNextGenBuildCacheServiceHandler(NextGenBuildCacheService service, boolean pushEnabled) {
            this.service = service;
            this.pushEnabled = pushEnabled;
        }

        @Override
        public boolean canLoad() {
            return !this.disabledOnError;
        }

        @Override
        public boolean canStore() {
            return !this.disabledOnError && this.pushEnabled;
        }

        @Override
        public void disableOnError() {
            this.disabledOnError = true;
        }

        @Override
        public boolean contains(BuildCacheKey key) {
            return this.canLoad() && this.service.contains(key);
        }

        @Override
        public boolean load(BuildCacheKey key, BuildCacheEntryReader reader2) throws BuildCacheException {
            return this.canLoad() && this.service.load(key, reader2);
        }

        @Override
        public void store(BuildCacheKey key, NextGenBuildCacheService.NextGenWriter writer2) throws BuildCacheException {
            if (this.canStore()) {
                this.service.store(key, writer2);
            }
        }

        @Override
        public void close() throws IOException {
            this.service.close();
        }
    }
}

