/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.problems.DocLink;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class DocumentedFailure {
    public static Builder builder() {
        return new Builder();
    }

    @Contextual
    public static class DocumentedExceptionWithCause
    extends GradleException {
        public DocumentedExceptionWithCause(String message, @Nullable Throwable cause) {
            super(message, cause);
        }
    }

    public static class Builder
    extends Documentation.AbstractBuilder<Builder> {
        private String summary;
        private String advice;
        private String contextualAdvice;
        private DocLink documentation;

        private Builder() {
        }

        public Builder withSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder withContext(String contextualAdvice) {
            this.contextualAdvice = contextualAdvice;
            return this;
        }

        public Builder withAdvice(String advice) {
            this.advice = advice;
            return this;
        }

        @Override
        public Builder withDocumentation(DocLink documentation) {
            this.documentation = documentation;
            return this;
        }

        public GradleException build() {
            return this.build(null);
        }

        public GradleException build(@Nullable Throwable cause) {
            StringBuilder outputBuilder = new StringBuilder(this.summary);
            Builder.append(outputBuilder, this.contextualAdvice);
            Builder.append(outputBuilder, this.advice);
            Builder.append(outputBuilder, this.documentation.getConsultDocumentationMessage());
            return cause == null ? new GradleException(outputBuilder.toString()) : new DocumentedExceptionWithCause(outputBuilder.toString(), cause);
        }

        private static void append(StringBuilder outputBuilder, @Nullable String message) {
            if (!StringUtils.isEmpty((String)message)) {
                outputBuilder.append(" ").append(message);
            }
        }
    }
}

