/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Arrays;
import java.util.EnumMap;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.jvm.inspection.MetadataProbe;
import org.gradle.internal.jvm.inspection.ProbedSystemProperty;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.util.internal.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJvmMetadataDetector
implements JvmMetadataDetector {
    private final ExecHandleFactory execHandleFactory;
    private final TemporaryFileProvider temporaryFileProvider;
    private final Logger logger = LoggerFactory.getLogger(DefaultJvmMetadataDetector.class);

    @Inject
    public DefaultJvmMetadataDetector(ExecHandleFactory execHandleFactory, TemporaryFileProvider temporaryFileProvider) {
        this.execHandleFactory = execHandleFactory;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    @Override
    public JvmInstallationMetadata getMetadata(InstallationLocation javaInstallationLocation) {
        File javaHome = javaInstallationLocation.getLocation();
        if (javaHome == null || !javaHome.exists()) {
            return this.failure(javaHome, "No such directory: " + javaHome);
        }
        if (Jvm.current().getJavaHome().equals(javaHome)) {
            return this.getMetadataFromCurrentJvm(javaHome);
        }
        return this.getMetadataFromInstallation(javaHome);
    }

    private JvmInstallationMetadata getMetadataFromCurrentJvm(File javaHome) {
        EnumMap<ProbedSystemProperty, String> result2 = new EnumMap<ProbedSystemProperty, String>(ProbedSystemProperty.class);
        for (ProbedSystemProperty type : ProbedSystemProperty.values()) {
            if (type == ProbedSystemProperty.Z_ERROR) continue;
            result2.put(type, System.getProperty(type.getSystemPropertyKey()));
        }
        this.logger.info("Received JVM installation metadata from '{}': {}", (Object)javaHome.getAbsolutePath(), result2);
        return this.asMetadata(javaHome, result2);
    }

    private JvmInstallationMetadata asMetadata(File javaHome, EnumMap<ProbedSystemProperty, String> metadata) {
        String javaVersion = metadata.get((Object)ProbedSystemProperty.JAVA_VERSION);
        if (javaVersion == null) {
            return this.failure(javaHome, metadata.get((Object)ProbedSystemProperty.Z_ERROR));
        }
        try {
            JavaVersion.toVersion(javaVersion);
        }
        catch (IllegalArgumentException e) {
            return this.failure(javaHome, "Cannot parse version number: " + javaVersion);
        }
        String javaVendor = metadata.get((Object)ProbedSystemProperty.JAVA_VENDOR);
        String runtimeName = metadata.get((Object)ProbedSystemProperty.RUNTIME_NAME);
        String runtimeVersion = metadata.get((Object)ProbedSystemProperty.RUNTIME_VERSION);
        String jvmName = metadata.get((Object)ProbedSystemProperty.VM_NAME);
        String jvmVersion = metadata.get((Object)ProbedSystemProperty.VM_VERSION);
        String jvmVendor = metadata.get((Object)ProbedSystemProperty.VM_VENDOR);
        String architecture = metadata.get((Object)ProbedSystemProperty.OS_ARCH);
        return JvmInstallationMetadata.from(javaHome, javaVersion, javaVendor, runtimeName, runtimeVersion, jvmName, jvmVersion, jvmVendor, architecture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JvmInstallationMetadata getMetadataFromInstallation(File jdkPath) {
        File tmpDir = this.temporaryFileProvider.createTemporaryDirectory("jvm", "probe", new String[0]);
        File probe = this.writeProbeClass(tmpDir);
        ExecHandleBuilder exec = this.execHandleFactory.newExec();
        exec.setWorkingDir(probe.getParentFile());
        exec.executable(DefaultJvmMetadataDetector.javaExecutable(jdkPath));
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream errorOutput = new ByteArrayOutputStream();
            String mainClassname = Files.getNameWithoutExtension((String)probe.getName());
            exec.args("-Xmx32m", "-Xms32m", "-cp", ".", mainClassname);
            exec.setStandardOutput(out);
            exec.setErrorOutput(errorOutput);
            exec.setIgnoreExitValue(true);
            ExecResult result2 = exec.build().start().waitForFinish();
            int exitValue = result2.getExitValue();
            if (exitValue == 0) {
                JvmInstallationMetadata jvmInstallationMetadata = this.parseExecOutput(jdkPath, out.toString());
                return jvmInstallationMetadata;
            }
            String errorMessage = "Command returned unexpected result code: " + exitValue + "\nError output:\n" + errorOutput;
            this.logger.info("Failed to get metadata from JVM installation at '" + jdkPath + "'. " + errorMessage);
            JvmInstallationMetadata jvmInstallationMetadata = this.failure(jdkPath, errorMessage);
            return jvmInstallationMetadata;
        }
        catch (ExecException ex) {
            this.logger.info("Failed to get metadata from JVM installation at '" + jdkPath + "'.", (Throwable)ex);
            JvmInstallationMetadata jvmInstallationMetadata = this.failure(jdkPath, ex);
            return jvmInstallationMetadata;
        }
        finally {
            GFileUtils.deleteQuietly(tmpDir);
        }
    }

    private static File javaExecutable(File jdkPath) {
        return new File(new File(jdkPath, "bin"), OperatingSystem.current().getExecutableName("java"));
    }

    private JvmInstallationMetadata parseExecOutput(File jdkPath, String probeResult) {
        String[] split = (String[])Arrays.stream(probeResult.split(System.getProperty("line.separator"))).filter(line -> line.startsWith("GRADLE_PROBE_VALUE:")).map(line -> line.substring("GRADLE_PROBE_VALUE:".length())).toArray(String[]::new);
        if (split.length != ProbedSystemProperty.values().length - 1) {
            String errorMessage = "Unexpected command output: \n" + probeResult;
            this.logger.info("Failed to parse JVM installation metadata output at '" + jdkPath + "'. " + errorMessage);
            return this.failure(jdkPath, errorMessage);
        }
        EnumMap<ProbedSystemProperty, String> result2 = new EnumMap<ProbedSystemProperty, String>(ProbedSystemProperty.class);
        for (ProbedSystemProperty type : ProbedSystemProperty.values()) {
            if (type == ProbedSystemProperty.Z_ERROR) continue;
            result2.put(type, split[type.ordinal()].trim());
        }
        this.logger.info("Received JVM installation metadata from '{}': {}", (Object)jdkPath.getAbsolutePath(), result2);
        return this.asMetadata(jdkPath, result2);
    }

    private JvmInstallationMetadata failure(File jdkPath, String errorMessage) {
        return JvmInstallationMetadata.failure(jdkPath, errorMessage);
    }

    private JvmInstallationMetadata failure(File jdkPath, Exception cause) {
        return JvmInstallationMetadata.failure(jdkPath, cause);
    }

    private File writeProbeClass(File tmpDir) {
        return new MetadataProbe().writeClass(tmpDir);
    }
}

