/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.management;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.initialization.resolve.MutableVersionCatalogContainer;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.dsl.dependencies.UnknownProjectFinder;
import org.gradle.api.internal.catalog.DefaultVersionCatalogBuilder;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.problems.Problems;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.TypeOf;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Interners;
import org.gradle.internal.reflect.Instantiator;

public class DefaultVersionCatalogBuilderContainer
extends AbstractNamedDomainObjectContainer<VersionCatalogBuilder>
implements MutableVersionCatalogContainer {
    private static final String VALID_EXTENSION_NAME = "[a-z]([a-zA-Z0-9])+";
    private static final Pattern VALID_EXTENSION_PATTERN = Pattern.compile("[a-z]([a-zA-Z0-9])+");
    private final Interner<String> strings = Interners.newStrongInterner();
    private final Interner<ImmutableVersionConstraint> versions = Interners.newStrongInterner();
    private final Supplier<DependencyResolutionServices> dependencyResolutionServices;
    private final Problems problemService;
    private final ObjectFactory objects;
    private final ProviderFactory providers;
    private final UserCodeApplicationContext context;

    @Inject
    public DefaultVersionCatalogBuilderContainer(Instantiator instantiator2, CollectionCallbackActionDecorator callbackActionDecorator, ObjectFactory objects, ProviderFactory providers, Supplier<DependencyResolutionServices> dependencyResolutionServices, UserCodeApplicationContext context, Problems problemService) {
        super(VersionCatalogBuilder.class, instantiator2, callbackActionDecorator);
        this.objects = objects;
        this.providers = providers;
        this.context = context;
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.problemService = problemService;
    }

    private static void validateName(String name) {
        if (!VALID_EXTENSION_PATTERN.matcher(name).matches()) {
            throw new InvalidUserDataException("Invalid model name '" + name + "': it must match the following regular expression: " + VALID_EXTENSION_NAME);
        }
    }

    @Override
    public VersionCatalogBuilder create(String name, Action<? super VersionCatalogBuilder> configureAction) throws InvalidUserDataException {
        DefaultVersionCatalogBuilderContainer.validateName(name);
        return super.create(name, (? super T model) -> {
            UserCodeApplicationContext.Application current = this.context.current();
            DefaultVersionCatalogBuilder builder = (DefaultVersionCatalogBuilder)model;
            builder.withContext(current == null ? "Settings" : current.getDisplayName().getDisplayName(), () -> configureAction.execute((VersionCatalogBuilder)model));
        });
    }

    private static ProjectFinder makeUnknownProjectFinder() {
        return new UnknownProjectFinder("Project dependencies are not allowed in shared dependency resolution services");
    }

    @Override
    protected VersionCatalogBuilder doCreate(String name) {
        return this.objects.newInstance(DefaultVersionCatalogBuilder.class, name, this.strings, this.versions, this.objects, this.dependencyResolutionServices);
    }

    @Override
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(MutableVersionCatalogContainer.class);
    }
}

