/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.xml;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.util.IndentPrinter;
import groovy.util.Node;
import groovy.xml.XmlNodePrinter;
import groovy.xml.XmlParser;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.DomNode;
import org.gradle.internal.IoActions;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.xml.XmlFactories;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GUtil;
import org.gradle.util.internal.TextUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlTransformer
implements Transformer<String, String> {
    private final List<Action<? super XmlProvider>> actions = new ArrayList<Action<? super XmlProvider>>();
    private final List<Action<? super XmlProvider>> finalizers = Lists.newArrayListWithExpectedSize((int)2);
    private String indentation = "  ";

    public void addAction(Action<? super XmlProvider> provider) {
        this.actions.add(provider);
    }

    public void addFinalizer(Action<? super XmlProvider> provider) {
        this.finalizers.add(provider);
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    public void addAction(@DelegatesTo(value=XmlProvider.class) Closure closure) {
        this.actions.add(ConfigureUtil.configureUsing(closure));
    }

    public void transform(File destination, final String encoding, final Action<? super Writer> generator) {
        IoActions.writeTextFile(destination, encoding, (Action<? super BufferedWriter>)new Action<Writer>(){

            @Override
            public void execute(Writer writer2) {
                XmlTransformer.this.transform(writer2, encoding, (Action<? super Writer>)generator);
            }
        });
    }

    public void transform(File destination, final Action<? super Writer> generator) {
        IoActions.writeTextFile(destination, (Action<? super BufferedWriter>)new Action<Writer>(){

            @Override
            public void execute(Writer writer2) {
                XmlTransformer.this.transform(writer2, (Action<? super Writer>)generator);
            }
        });
    }

    public void transform(Writer destination, Action<? super Writer> generator) {
        StringWriter stringWriter = new StringWriter();
        generator.execute(stringWriter);
        this.transform(stringWriter.toString(), destination);
    }

    public void transform(Writer destination, String encoding, Action<? super Writer> generator) {
        StringWriter stringWriter = new StringWriter();
        generator.execute(stringWriter);
        this.doTransform(stringWriter.toString()).writeTo(destination, encoding);
    }

    @Override
    public String transform(String original) {
        return this.doTransform(original).toString();
    }

    public void transform(String original, Writer destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(String original, OutputStream destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(Node original, Writer destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(Node original, OutputStream destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(Node original, File destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(DomNode original, Writer destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(DomNode original, OutputStream destination) {
        this.doTransform(original).writeTo(destination);
    }

    private XmlProviderImpl doTransform(String original) {
        return this.doTransform(new XmlProviderImpl(original));
    }

    private XmlProviderImpl doTransform(Node original) {
        return this.doTransform(new XmlProviderImpl(original));
    }

    private XmlProviderImpl doTransform(DomNode original) {
        return this.doTransform(new XmlProviderImpl(original));
    }

    private XmlProviderImpl doTransform(XmlProviderImpl provider) {
        provider.apply(this.actions);
        provider.apply(this.finalizers);
        return provider;
    }

    private class XmlProviderImpl
    implements XmlProvider {
        private StringBuilder builder;
        private Node node;
        private String stringValue;
        private Element element;
        private String publicId;
        private String systemId;

        public XmlProviderImpl(String original) {
            this.stringValue = original;
        }

        public XmlProviderImpl(Node original) {
            this.node = original;
        }

        public XmlProviderImpl(DomNode original) {
            this.node = original;
            this.publicId = original.getPublicId();
            this.systemId = original.getSystemId();
        }

        public void apply(Iterable<Action<? super XmlProvider>> actions) {
            for (Action<? super XmlProvider> action : actions) {
                action.execute(this);
            }
        }

        public String toString() {
            StringWriter writer2 = new StringWriter();
            this.writeTo(writer2);
            return writer2.toString();
        }

        public void writeTo(Writer writer2) {
            this.doWriteTo(writer2, null);
        }

        public void writeTo(Writer writer2, String encoding) {
            this.doWriteTo(writer2, encoding);
        }

        public void writeTo(File file) {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                this.writeTo(outputStream);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        public void writeTo(OutputStream stream) {
            try (BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
                this.doWriteTo(writer2, "UTF-8");
                ((Writer)writer2).flush();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        @Override
        public StringBuilder asString() {
            if (this.builder == null) {
                this.builder = new StringBuilder(this.toString());
                this.node = null;
                this.element = null;
            }
            return this.builder;
        }

        @Override
        public Node asNode() {
            if (this.node == null) {
                try {
                    this.node = new XmlParser().parseText(this.toString());
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
                this.builder = null;
                this.element = null;
            }
            return this.node;
        }

        @Override
        public Element asElement() {
            if (this.element == null) {
                Document document;
                try {
                    document = XmlFactories.newDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new StringReader(this.toString())));
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
                this.element = document.getDocumentElement();
                this.builder = null;
                this.node = null;
            }
            return this.element;
        }

        private void doWriteTo(Writer writer2, String encoding) {
            this.writeXmlDeclaration(writer2, encoding);
            try {
                if (this.node != null) {
                    this.printNode(this.node, writer2);
                } else if (this.element != null) {
                    this.printDomNode(this.element, writer2);
                } else if (this.builder != null) {
                    writer2.append(TextUtil.toPlatformLineSeparators(this.stripXmlDeclaration(this.builder)));
                } else {
                    writer2.append(TextUtil.toPlatformLineSeparators(this.stripXmlDeclaration(this.stringValue)));
                }
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        private void printNode(Node node, Writer writer2) {
            final PrintWriter printWriter = new PrintWriter(writer2);
            if (GUtil.isTrue(this.publicId)) {
                printWriter.format("<!DOCTYPE %s PUBLIC \"%s\" \"%s\">%n", node.name(), this.publicId, this.systemId);
            }
            IndentPrinter indentPrinter = new IndentPrinter(printWriter, XmlTransformer.this.indentation){

                public void println() {
                    printWriter.println();
                }

                public void flush() {
                }
            };
            XmlNodePrinter nodePrinter = new XmlNodePrinter(indentPrinter);
            nodePrinter.setPreserveWhitespace(true);
            nodePrinter.print(node);
            printWriter.flush();
        }

        private void printDomNode(org.w3c.dom.Node node, Writer destination) {
            this.removeEmptyTextNodes(node);
            int indentAmount = this.determineIndentAmount();
            try {
                TransformerFactory factory = XmlFactories.newTransformerFactory();
                try {
                    factory.setAttribute("indent-number", indentAmount);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                javax.xml.transform.Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                if (GUtil.isTrue(this.publicId)) {
                    transformer.setOutputProperty("doctype-public", this.publicId);
                    transformer.setOutputProperty("doctype-system", this.systemId);
                }
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentAmount));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                transformer.transform(new DOMSource(node), new StreamResult(destination));
            }
            catch (TransformerException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        private int determineIndentAmount() {
            if (XmlTransformer.this.indentation.equals("\t")) {
                return 2;
            }
            return XmlTransformer.this.indentation.length();
        }

        private void removeEmptyTextNodes(org.w3c.dom.Node node) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                org.w3c.dom.Node child = children.item(i);
                if (child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) {
                    node.removeChild(child);
                    --i;
                    continue;
                }
                this.removeEmptyTextNodes(child);
            }
        }

        private void writeXmlDeclaration(Writer writer2, String encoding) {
            try {
                writer2.write("<?xml version=\"1.0\"");
                if (encoding != null) {
                    writer2.write(" encoding=\"");
                    writer2.write(encoding);
                    writer2.write("\"");
                }
                writer2.write("?>");
                writer2.write(SystemProperties.getInstance().getLineSeparator());
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        private boolean hasXmlDeclaration(String xml) {
            return xml.startsWith("<?xml");
        }

        private String stripXmlDeclaration(CharSequence sequence2) {
            String str = sequence2.toString();
            if (this.hasXmlDeclaration(str)) {
                str = str.substring(str.indexOf("?>") + 2);
                str = StringUtils.stripStart((String)str, null);
            }
            return str;
        }
    }
}

