/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.toolchain.JavaToolchainRepository;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainRepositoryHandler;
import org.gradle.jvm.toolchain.internal.JavaToolchainRepositoryHandlerInternal;
import org.gradle.jvm.toolchain.internal.JavaToolchainRepositoryInternal;
import org.gradle.jvm.toolchain.internal.JavaToolchainResolverRegistryInternal;
import org.gradle.jvm.toolchain.internal.RealizedJavaToolchainRepository;

public abstract class DefaultJavaToolchainResolverRegistry
implements JavaToolchainResolverRegistryInternal {
    private static final Action<BuildServiceSpec<BuildServiceParameters.None>> EMPTY_CONFIGURE_ACTION = buildServiceSpec -> {};
    private final BuildServiceRegistry sharedServices;
    private final DefaultJavaToolchainRepositoryHandler repositoryHandler;
    private final List<RealizedJavaToolchainRepository> realizedRepositories = new ArrayList<RealizedJavaToolchainRepository>();
    private final Map<Class<? extends JavaToolchainResolver>, Provider<? extends JavaToolchainResolver>> registrations = new HashMap<Class<? extends JavaToolchainResolver>, Provider<? extends JavaToolchainResolver>>();

    @Inject
    public DefaultJavaToolchainResolverRegistry(Gradle gradle, Instantiator instantiator2, ObjectFactory objectFactory, ProviderFactory providerFactory, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
        this.sharedServices = gradle.getSharedServices();
        this.repositoryHandler = objectFactory.newInstance(DefaultJavaToolchainRepositoryHandler.class, instantiator2, objectFactory, providerFactory, authenticationSchemeRegistry);
    }

    @Override
    public JavaToolchainRepositoryHandlerInternal getRepositories() {
        return this.repositoryHandler;
    }

    @Override
    public <T extends JavaToolchainResolver> void register(Class<T> implementationType) {
        if (this.registrations.containsKey(implementationType)) {
            throw new GradleException("Duplicate registration for '" + implementationType.getName() + "'.");
        }
        Provider<T> provider = this.sharedServices.registerIfAbsent(implementationType.getName(), implementationType, EMPTY_CONFIGURE_ACTION);
        this.registrations.put(implementationType, provider);
    }

    public List<RealizedJavaToolchainRepository> requestedRepositories() {
        if (this.realizedRepositories.size() != this.repositoryHandler.size()) {
            this.realizeRepositories();
        }
        return this.realizedRepositories;
    }

    @Override
    public void preventFromFurtherMutation() {
        this.repositoryHandler.preventFromFurtherMutation();
        this.realizeRepositories();
    }

    private void realizeRepositories() {
        this.realizedRepositories.clear();
        HashSet<Class> resolvers = new HashSet<Class>();
        for (JavaToolchainRepository repository : this.repositoryHandler.getAsList()) {
            if (!resolvers.add((Class)repository.getResolverClass().get())) {
                throw new GradleException("Duplicate configuration for repository implementation '" + ((Class)repository.getResolverClass().get()).getName() + "'.");
            }
            this.realizedRepositories.add(this.realize(repository));
        }
    }

    private RealizedJavaToolchainRepository realize(JavaToolchainRepository repository) {
        Class<? extends JavaToolchainResolver> repositoryClass = DefaultJavaToolchainResolverRegistry.getResolverClass(repository);
        Provider<? extends JavaToolchainResolver> provider = this.findProvider(repositoryClass);
        return new RealizedJavaToolchainRepository(provider, (JavaToolchainRepositoryInternal)repository);
    }

    private Provider<? extends JavaToolchainResolver> findProvider(Class<? extends JavaToolchainResolver> repositoryClass) {
        Provider<? extends JavaToolchainResolver> provider = this.registrations.get(repositoryClass);
        if (provider == null) {
            throw new GradleException("Class " + repositoryClass.getName() + " hasn't been registered as a Java toolchain repository");
        }
        return provider;
    }

    private static Class<? extends JavaToolchainResolver> getResolverClass(JavaToolchainRepository repository) {
        Property<Class<? extends JavaToolchainResolver>> resolverClassProperty = repository.getResolverClass();
        resolverClassProperty.finalizeValueOnRead();
        if (!resolverClassProperty.isPresent()) {
            throw new GradleException("Java toolchain repository `" + repository.getName() + "` must have the `resolverClass` property set");
        }
        return (Class)resolverClassProperty.get();
    }
}

