/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal;

import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.plugin.management.PluginResolveDetails;
import org.gradle.plugin.management.internal.DefaultPluginResolveDetails;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginResolutionStrategyInternal;
import org.gradle.plugin.use.PluginId;

public class DefaultPluginResolutionStrategy
implements PluginResolutionStrategyInternal {
    private final MutableActionSet<PluginResolveDetails> resolutionRules = new MutableActionSet();
    private final Map<PluginId, String> pluginVersions = Maps.newHashMap();
    private boolean locked;

    public DefaultPluginResolutionStrategy(ListenerManager listenerManager) {
        listenerManager.addListener(new InternalBuildAdapter(){

            @Override
            public void projectsLoaded(Gradle gradle) {
                DefaultPluginResolutionStrategy.this.locked = true;
            }
        });
    }

    @Override
    public void eachPlugin(Action<? super PluginResolveDetails> rule) {
        if (this.locked) {
            throw new IllegalStateException("Cannot change the plugin resolution strategy after projects have been loaded.");
        }
        this.resolutionRules.add(rule);
    }

    @Override
    public PluginRequestInternal applyTo(PluginRequestInternal pluginRequest) {
        String version;
        DefaultPluginResolveDetails details = new DefaultPluginResolveDetails(pluginRequest);
        if (details.getRequested().getVersion() == null && (version = this.pluginVersions.get(details.getRequested().getId())) != null) {
            details.useVersion(version);
        }
        this.resolutionRules.execute(details);
        return details.getTarget();
    }

    @Override
    public void setDefaultPluginVersion(PluginId id, String version) {
        String existing = this.pluginVersions.get(id);
        if (existing != null && !existing.equals(version)) {
            throw new IllegalArgumentException("Cannot provide multiple default versions for the same plugin.");
        }
        this.pluginVersions.put(id, version);
    }
}

