/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.generator;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.api.internal.PropertyListTransformer;
import org.gradle.internal.impldep.com.dd.plist.NSObject;
import org.gradle.internal.impldep.com.dd.plist.PropertyListParser;
import org.gradle.plugins.ide.internal.generator.AbstractPersistableConfigurationObject;
import org.gradle.util.internal.ConfigureUtil;

public abstract class PropertyListPersistableConfigurationObject<T extends NSObject>
extends AbstractPersistableConfigurationObject {
    private final Class<T> clazz;
    private final PropertyListTransformer<T> transformer;
    private T rootObject;

    protected PropertyListPersistableConfigurationObject(Class<T> clazz, PropertyListTransformer<T> transformer) {
        this.clazz = clazz;
        this.transformer = transformer;
    }

    protected abstract T newRootObject();

    @Override
    public void load(InputStream inputStream) throws Exception {
        this.rootObject = (NSObject)this.clazz.cast(PropertyListParser.parse((InputStream)inputStream));
        if (this.rootObject == null) {
            this.rootObject = this.newRootObject();
        }
        this.load(this.rootObject);
    }

    @Override
    public void store(OutputStream outputStream) {
        this.store(this.rootObject);
        this.transformer.transform(this.rootObject, outputStream);
    }

    protected abstract void store(T var1);

    protected abstract void load(T var1);

    public void transformAction(@DelegatesTo(value=NSObject.class) Closure<?> action) {
        this.transformAction(ConfigureUtil.configureUsing(action));
    }

    public void transformAction(Action<? super T> action) {
        this.transformer.addAction(action);
    }
}

