/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecSpec;
import org.gradle.process.internal.DefaultProcessForkOptions;
import org.gradle.process.internal.ProcessArgumentsSpec;
import org.gradle.process.internal.ProcessStreamsSpec;

public class DefaultExecSpec
extends DefaultProcessForkOptions
implements ExecSpec,
ProcessArgumentsSpec.HasExecutable {
    private boolean ignoreExitValue;
    private final ProcessStreamsSpec streamsSpec = new ProcessStreamsSpec();
    private final ProcessArgumentsSpec argumentsSpec = new ProcessArgumentsSpec(this);

    @Inject
    public DefaultExecSpec(PathToFileResolver resolver) {
        super(resolver);
    }

    public void copyTo(ExecSpec targetSpec) {
        super.copyTo(targetSpec);
        DefaultExecSpec.copyBaseExecSpecTo(this, targetSpec);
        targetSpec.setArgs(this.getArgs());
        targetSpec.getArgumentProviders().addAll(this.getArgumentProviders());
    }

    static void copyBaseExecSpecTo(BaseExecSpec source, BaseExecSpec target) {
        target.setIgnoreExitValue(source.isIgnoreExitValue());
        if (source.getStandardInput() != null) {
            target.setStandardInput(source.getStandardInput());
        }
        if (source.getStandardOutput() != null) {
            target.setStandardOutput(source.getStandardOutput());
        }
        if (source.getErrorOutput() != null) {
            target.setErrorOutput(source.getErrorOutput());
        }
    }

    @Override
    public List<String> getCommandLine() {
        return this.argumentsSpec.getCommandLine();
    }

    @Override
    public ExecSpec commandLine(Object ... arguments) {
        this.argumentsSpec.commandLine(arguments);
        return this;
    }

    @Override
    public ExecSpec commandLine(Iterable<?> args) {
        this.argumentsSpec.commandLine(args);
        return this;
    }

    @Override
    public void setCommandLine(List<String> args) {
        this.argumentsSpec.commandLine(args);
    }

    @Override
    public void setCommandLine(Object ... args) {
        this.argumentsSpec.commandLine(args);
    }

    @Override
    public void setCommandLine(Iterable<?> args) {
        this.argumentsSpec.commandLine(args);
    }

    @Override
    public ExecSpec args(Object ... args) {
        this.argumentsSpec.args(args);
        return this;
    }

    @Override
    public ExecSpec args(Iterable<?> args) {
        this.argumentsSpec.args(args);
        return this;
    }

    @Override
    public ExecSpec setArgs(List<String> arguments) {
        this.argumentsSpec.setArgs(arguments);
        return this;
    }

    @Override
    public ExecSpec setArgs(Iterable<?> arguments) {
        this.argumentsSpec.setArgs(arguments);
        return this;
    }

    @Override
    public List<String> getArgs() {
        return this.argumentsSpec.getArgs();
    }

    @Override
    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentsSpec.getArgumentProviders();
    }

    @Override
    public ExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExitValue = ignoreExitValue;
        return this;
    }

    @Override
    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    @Override
    public BaseExecSpec setStandardInput(InputStream inputStream) {
        this.streamsSpec.setStandardInput(inputStream);
        return this;
    }

    @Override
    public InputStream getStandardInput() {
        return this.streamsSpec.getStandardInput();
    }

    @Override
    public BaseExecSpec setStandardOutput(OutputStream outputStream) {
        this.streamsSpec.setStandardOutput(outputStream);
        return this;
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.streamsSpec.getStandardOutput();
    }

    @Override
    public BaseExecSpec setErrorOutput(OutputStream outputStream) {
        this.streamsSpec.setErrorOutput(outputStream);
        return this;
    }

    @Override
    public OutputStream getErrorOutput() {
        return this.streamsSpec.getErrorOutput();
    }
}

