/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.operations.TestListenerBuildOperationAdapter;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.build.event.types.DefaultTestOutputDescriptor;
import org.gradle.internal.build.event.types.DefaultTestOutputEvent;
import org.gradle.internal.build.event.types.DefaultTestOutputResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.test.Destination;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

@NonNullApi
class ClientForwardingTestOutputOperationListener
implements BuildOperationListener {
    private final ProgressEventConsumer eventConsumer;
    private final BuildOperationIdFactory idFactory;

    ClientForwardingTestOutputOperationListener(ProgressEventConsumer eventConsumer, BuildOperationIdFactory idFactory) {
        this.eventConsumer = eventConsumer;
        this.idFactory = idFactory;
    }

    @Override
    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
    }

    @Override
    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
        Object details = progressEvent.getDetails();
        if (details instanceof TestListenerBuildOperationAdapter.OutputProgress) {
            TestListenerBuildOperationAdapter.OutputProgress progress = (TestListenerBuildOperationAdapter.OutputProgress)details;
            DefaultTestOutputDescriptor descriptor = new DefaultTestOutputDescriptor(new OperationIdentifier(this.idFactory.nextId()), buildOperationId);
            int destination = ClientForwardingTestOutputOperationListener.getDestination(progress.getOutput().getDestination());
            DefaultTestOutputResult result2 = new DefaultTestOutputResult(progressEvent.getTime(), progressEvent.getTime(), destination, progress.getOutput().getMessage());
            this.eventConsumer.progress(new DefaultTestOutputEvent(progressEvent.getTime(), descriptor, result2));
        }
    }

    private static int getDestination(TestOutputEvent.Destination destination) {
        switch (destination) {
            case StdOut: {
                return Destination.StdOut.getCode();
            }
            case StdErr: {
                return Destination.StdErr.getCode();
            }
        }
        throw new IllegalStateException("Unknown output destination type: " + (Object)((Object)destination));
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
    }
}

