/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.config.SettingsSyncOpenSettingsAction;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.SettingsSyncIcons;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u00012\u00020\u00022\u00020\u0003:\u0003\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncStatusAction;", "Lcom/intellij/settingsSync/config/SettingsSyncOpenSettingsAction;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$NoDots;", "Lcom/intellij/settingsSync/SettingsSyncStatusTracker$Listener;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getStyledStatus", "", "Lorg/jetbrains/annotations/Nls;", "status", "Lcom/intellij/settingsSync/config/SettingsSyncStatusAction$SyncStatus;", "syncStatusChanged", "", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "IconCustomizer", "SyncStatus", "intellij.settingsSync"})
public final class SettingsSyncStatusAction
extends SettingsSyncOpenSettingsAction
implements SettingsEntryPointAction.NoDots,
SettingsSyncStatusTracker.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SettingsSyncStatusAction() {
        super(SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]));
        SettingsSyncStatusTracker.Companion.getInstance().addListener(this);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation p = presentation;
        if (!SettingsSyncMainKt.isSettingsSyncEnabledByKey()) {
            p.setEnabledAndVisible(false);
            return;
        }
        SyncStatus status = SettingsSyncStatusAction.Companion.getStatus();
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                p.setIcon(SettingsSyncIcons.StatusEnabled);
                break;
            }
            case 2: {
                p.setIcon(SettingsSyncIcons.StatusDisabled);
                break;
            }
            case 3: {
                p.setIcon(AllIcons.General.Error);
            }
        }
        p.setText(this.getStyledStatus(status));
    }

    private final String getStyledStatus(SyncStatus status) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>").append(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync", new Object[0])).append(" ").append("<font color='#");
        String hexColor = UIUtil.colorToHex((Color)JBUI.CurrentTheme.Popup.mnemonicForeground());
        builder.append(hexColor).append("'>");
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                builder.append(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.is.on", new Object[0]));
                break;
            }
            case 2: {
                builder.append(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.is.off", new Object[0]));
                break;
            }
            case 3: {
                builder.append(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.failed", new Object[0]));
            }
        }
        builder.append("</font>");
        return String.valueOf(builder);
    }

    @Override
    public void syncStatusChanged() {
        SettingsEntryPointAction.updateState();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncStatusAction$Companion;", "", "()V", "getStatus", "Lcom/intellij/settingsSync/config/SettingsSyncStatusAction$SyncStatus;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        private final SyncStatus getStatus() {
            if (SettingsSyncSettings.Companion.getInstance().getSyncEnabled() && SettingsSyncAuthService.Companion.getInstance().isLoggedIn()) {
                return SettingsSyncStatusTracker.Companion.getInstance().isSyncSuccessful() ? SyncStatus.ON : SyncStatus.FAILED;
            }
            return SyncStatus.OFF;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncStatusAction$IconCustomizer;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$IconCustomizer;", "()V", "getCustomIcon", "Ljavax/swing/Icon;", "supplier", "Lcom/intellij/ui/BadgeIconSupplier;", "intellij.settingsSync"})
    public static final class IconCustomizer
    implements SettingsEntryPointAction.IconCustomizer {
        @Nullable
        public Icon getCustomIcon(@NotNull BadgeIconSupplier supplier) {
            Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
            return Companion.getStatus() == SyncStatus.FAILED ? supplier.getErrorIcon(true) : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncStatusAction$SyncStatus;", "", "(Ljava/lang/String;I)V", "ON", "OFF", "FAILED", "intellij.settingsSync"})
    private static final class SyncStatus
    extends Enum<SyncStatus> {
        public static final /* enum */ SyncStatus ON = new SyncStatus();
        public static final /* enum */ SyncStatus OFF = new SyncStatus();
        public static final /* enum */ SyncStatus FAILED = new SyncStatus();
        private static final /* synthetic */ SyncStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SyncStatus[] values() {
            return (SyncStatus[])$VALUES.clone();
        }

        public static SyncStatus valueOf(String value) {
            return Enum.valueOf(SyncStatus.class, value);
        }

        @NotNull
        public static EnumEntries<SyncStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = syncStatusArray = new SyncStatus[]{SyncStatus.ON, SyncStatus.OFF, SyncStatus.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyncStatus.values().length];
            try {
                nArray[SyncStatus.ON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncStatus.OFF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncStatus.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

