/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ide;

import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.images.ide.ImagePasteProviderKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Lorg/intellij/images/ide/ImagePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "imageFilePasted", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "imageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isEnabledForDataContext", "", "isPasteEnabled", "isPastePossible", "performPaste", "intellij.platform.images"})
@SourceDebugExtension(value={"SMAP\nImagePasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePasteProvider.kt\norg/intellij/images/ide/ImagePasteProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,122:1\n10#2:123\n*S KotlinDebug\n*F\n+ 1 ImagePasteProvider.kt\norg/intellij/images/ide/ImagePasteProvider\n*L\n43#1:123\n*E\n"})
public class ImagePasteProvider
implements PasteProvider {
    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public final boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
        return CopyPasteManager.getInstance().areDataFlavorsAvailable(dataFlavorArray) && dataContext.getData(CommonDataKeys.VIRTUAL_FILE) != null && this.isEnabledForDataContext(dataContext);
    }

    public boolean isEnabledForDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public final void performPaste(@NotNull DataContext dataContext) {
        BufferedImage imageToPaste;
        BufferedImage bufferedImage;
        Object object;
        VirtualFile newFileParent;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile currentFile = virtualFile;
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable == null) {
            return;
        }
        Transferable pasteContents = transferable;
        VirtualFile virtualFile2 = newFileParent = currentFile.isDirectory() ? currentFile : currentFile.getParent();
        if (newFileParent == null || !newFileParent.isDirectory()) {
            return;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImagePasteProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        try {
            object = pasteContents.getTransferData(DataFlavor.imageFlavor);
        }
        catch (IOException ioException) {
            logger2.error("Failed to get data from the clipboard. Data is no longer available. Aborting operation.", (Throwable)ioException);
            return;
        }
        Object it = object;
        boolean bl = false;
        Object object2 = it;
        if (object2 instanceof MultiResolutionImage) {
            List<Image> list = ((MultiResolutionImage)it).getResolutionVariants();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getResolutionVariants(...)");
            Image image = (Image)CollectionsKt.firstOrNull(list);
            bufferedImage = image != null ? ImagePasteProviderKt.access$toBufferedImage(image) : null;
        } else if (object2 instanceof BufferedImage) {
            bufferedImage = (BufferedImage)it;
        } else if (object2 instanceof Image) {
            Intrinsics.checkNotNull((Object)it);
            bufferedImage = ImagePasteProviderKt.access$toBufferedImage((Image)it);
        } else {
            bufferedImage = null;
        }
        if ((imageToPaste = bufferedImage) == null) {
            logger2.error("Failed to get data from the clipboard. Nothing to paste. Aborting operation.");
            return;
        }
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(newFileParent, this, logger2, dataContext, imageToPaste){
            final /* synthetic */ VirtualFile $newFileParent;
            final /* synthetic */ ImagePasteProvider this$0;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ DataContext $dataContext;
            final /* synthetic */ BufferedImage $imageToPaste;
            {
                this.$newFileParent = $newFileParent;
                this.this$0 = $receiver;
                this.$logger = $logger;
                this.$dataContext = $dataContext;
                this.$imageToPaste = $imageToPaste;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object;
                Object object2;
                String string = VfsUtil.getNextAvailableName((VirtualFile)this.$newFileParent, (String)"img", (String)"png");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNextAvailableName(...)");
                String nextAvailableName = string;
                try {
                    object2 = this.$newFileParent.createChildData((Object)this.this$0, nextAvailableName);
                }
                catch (IOException ioException) {
                    this.$logger.error("Failed to create a pasted image file due to I/O error. Aborting operation.", (Throwable)ioException);
                    object2 = null;
                }
                VirtualFile virtualFile = object = object2;
                if (virtualFile == null) {
                    return;
                }
                VirtualFile imageFile = virtualFile;
                try {
                    Closeable closeable = imageFile.getOutputStream((Object)this.this$0);
                    object = this.$imageToPaste;
                    object2 = null;
                    try {
                        OutputStream it = (OutputStream)closeable;
                        boolean bl = false;
                        boolean bl2 = ImageIO.write((RenderedImage)object, "png", it);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                    }
                }
                catch (IOException ioException) {
                    this.$logger.error("Failed to save a pasted image to a file due to I/O error. Aborting operation", (Throwable)ioException);
                    try {
                        imageFile.delete((Object)this.this$0);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                this.this$0.imageFilePasted(this.$dataContext, imageFile);
            }
        }));
    }

    public void imageFilePasted(@NotNull DataContext dataContext, @NotNull VirtualFile imageFile) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
    }
}

