/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;

public class SvnFileRevision
implements VcsFileRevision {
    private static final Logger LOG = Logger.getInstance(SvnFileRevision.class);
    private final Date myDate;
    private String myCommitMessage;
    private final String myAuthor;
    @NotNull
    private final SvnRevisionNumber myRevisionNumber;
    @NotNull
    private final SvnVcs myVCS;
    @NotNull
    private final Url myURL;
    private final Revision myPegRevision;
    private final String myCopyFromPath;
    @NotNull
    private final List<SvnFileRevision> myMergeSources;

    public SvnFileRevision(@NotNull SvnVcs vcs, Revision pegRevision, @NotNull Revision revision, @NotNull Url url, String author, Date date, String commitMessage, String copyFromPath) {
        if (vcs == null) {
            SvnFileRevision.$$$reportNull$$$0(0);
        }
        if (revision == null) {
            SvnFileRevision.$$$reportNull$$$0(1);
        }
        if (url == null) {
            SvnFileRevision.$$$reportNull$$$0(2);
        }
        this.myMergeSources = new ArrayList<SvnFileRevision>();
        this.myRevisionNumber = new SvnRevisionNumber(revision);
        this.myPegRevision = pegRevision;
        this.myAuthor = author;
        this.myDate = date;
        this.myCommitMessage = commitMessage;
        this.myCopyFromPath = copyFromPath;
        this.myVCS = vcs;
        this.myURL = url;
    }

    public SvnFileRevision(@NotNull SvnVcs vcs, Revision pegRevision, LogEntry logEntry, @NotNull Url url, String copyFromPath) {
        if (vcs == null) {
            SvnFileRevision.$$$reportNull$$$0(3);
        }
        if (url == null) {
            SvnFileRevision.$$$reportNull$$$0(4);
        }
        this.myMergeSources = new ArrayList<SvnFileRevision>();
        this.myRevisionNumber = new SvnRevisionNumber(Revision.of(logEntry.getRevision()));
        this.myPegRevision = pegRevision;
        this.myAuthor = logEntry.getAuthor();
        this.myDate = logEntry.getDate();
        this.myCommitMessage = logEntry.getMessage();
        this.myCopyFromPath = copyFromPath;
        this.myVCS = vcs;
        this.myURL = url;
    }

    @NotNull
    public CommitInfo getCommitInfo() {
        CommitInfo commitInfo = new CommitInfo.Builder(this.myRevisionNumber.getRevision().getNumber(), this.myDate, this.myAuthor).build();
        if (commitInfo == null) {
            SvnFileRevision.$$$reportNull$$$0(5);
        }
        return commitInfo;
    }

    @NotNull
    public Url getURL() {
        Url url = this.myURL;
        if (url == null) {
            SvnFileRevision.$$$reportNull$$$0(6);
        }
        return url;
    }

    public Revision getPegRevision() {
        return this.myPegRevision;
    }

    @NotNull
    public SvnRevisionNumber getRevisionNumber() {
        SvnRevisionNumber svnRevisionNumber = this.myRevisionNumber;
        if (svnRevisionNumber == null) {
            SvnFileRevision.$$$reportNull$$$0(7);
        }
        return svnRevisionNumber;
    }

    public String getBranchName() {
        return null;
    }

    @Nullable
    public SvnRepositoryLocation getChangedRepositoryPath() {
        return new SvnRepositoryLocation(this.myURL);
    }

    public Date getRevisionDate() {
        return this.myDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    public void addMergeSource(@NotNull SvnFileRevision source) {
        if (source == null) {
            SvnFileRevision.$$$reportNull$$$0(8);
        }
        this.myMergeSources.add(source);
    }

    @NotNull
    public List<SvnFileRevision> getMergeSources() {
        List<SvnFileRevision> list = this.myMergeSources;
        if (list == null) {
            SvnFileRevision.$$$reportNull$$$0(9);
        }
        return list;
    }

    private byte[] loadRevisionContent() throws VcsException {
        ContentLoader loader = new ContentLoader();
        if (ApplicationManager.getApplication().isDispatchThread() && !this.getRevision().isLocal()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, this.myVCS.getProject());
        } else {
            loader.run();
        }
        VcsException exception = loader.getException();
        if (exception == null) {
            byte[] contents = loader.getContents();
            ContentRevisionCache.checkContentsSize((String)this.myURL.toDecodedString(), (long)contents.length);
            return contents;
        }
        LOG.info("Failed to load file '" + this.myURL.toDecodedString() + "' content at revision: " + this.getRevision() + "\n" + exception.getMessage(), (Throwable)exception);
        throw exception;
    }

    public byte @NotNull [] loadContent() throws IOException, VcsException {
        byte[] result = Revision.HEAD.equals(this.getRevision()) ? this.loadRevisionContent() : ContentRevisionCache.getOrLoadAsBytes((Project)this.myVCS.getProject(), (FilePath)VcsUtil.getFilePathOnNonLocal((String)this.myURL.toDecodedString(), (boolean)false), (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVCS.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REMOTE_CONTENT, () -> this.loadRevisionContent());
        if (result == null) {
            SvnFileRevision.$$$reportNull$$$0(10);
        }
        return result;
    }

    public byte[] getContent() throws IOException, VcsException {
        return this.loadContent();
    }

    public String getCopyFromPath() {
        return this.myCopyFromPath;
    }

    public void setCommitMessage(String message) {
        this.myCommitMessage = message;
    }

    @NotNull
    public Revision getRevision() {
        Revision revision = this.myRevisionNumber.getRevision();
        if (revision == null) {
            SvnFileRevision.$$$reportNull$$$0(11);
        }
        return revision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnFileRevision";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnFileRevision";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getURL";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeSources";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMergeSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private class ContentLoader
    implements Runnable {
        private VcsException myException;
        private byte[] myContents;

        private ContentLoader() {
        }

        public VcsException getException() {
            return this.myException;
        }

        private byte[] getContents() {
            return this.myContents;
        }

        @Override
        public void run() {
            ProgressManager.progress((String)SvnBundle.message("progress.text.loading.contents", SvnFileRevision.this.myURL.toDecodedString()), (String)SvnBundle.message("progress.text2.revision.information", SvnFileRevision.this.getRevision()));
            try {
                this.myContents = SvnUtil.getFileContents(SvnFileRevision.this.myVCS, Target.on(SvnFileRevision.this.myURL), SvnFileRevision.this.getRevision(), SvnFileRevision.this.myPegRevision);
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }
    }
}

