/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListEnterHandlerDelegate$postProcessEnter$;
import org.intellij.plugins.markdown.editor.lists.MarkdownListItemUnindentHandler;
import org.intellij.plugins.markdown.editor.lists.MarkdownListMarkerBackspaceHandlerDelegate;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListNumber;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JF\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "()V", "codeInsightSettings", "Lorg/intellij/plugins/markdown/settings/MarkdownCodeInsightSettings$State;", "getCodeInsightSettings", "()Lorg/intellij/plugins/markdown/settings/MarkdownCodeInsightSettings$State;", "emptyItem", "", "handleEmptyItem", "", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invokeInsideIndent", "", "newLineCharOffset", "", "isInCodeFence", "caretOffset", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "preprocessEnter", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "Companion", "intellij.markdown.core"})
@ExperimentalStdlibApi
@SourceDebugExtension(value={"SMAP\nMarkdownListEnterHandlerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListEnterHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,182:1\n60#2,2:183\n61#2:185\n61#2:186\n473#3:187\n*S KotlinDebug\n*F\n+ 1 MarkdownListEnterHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate\n*L\n98#1:183,2\n121#1:185\n129#1:186\n163#1:187\n*E\n"})
public final class MarkdownListEnterHandlerDelegate
implements EnterHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String emptyItem;

    private final MarkdownCodeInsightSettings.State getCodeInsightSettings() {
        return (MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState();
    }

    public boolean invokeInsideIndent(int newLineCharOffset, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (!this.getCodeInsightSettings().getSmartEnterAndBackspace()) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument());
        return file instanceof MarkdownFile;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        block17: {
            block16: {
                block15: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
                    Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
                    Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                    this.emptyItem = null;
                    if (!this.getCodeInsightSettings().getSmartEnterAndBackspace()) {
                        return EnterHandlerDelegate.Result.Continue;
                    }
                    if (!(file instanceof MarkdownFile)) break block15;
                    v0 = caretOffset.get();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                    if (!this.isInCodeFence(((Number)v0).intValue(), file)) break block16;
                }
                return EnterHandlerDelegate.Result.Continue;
            }
            if (Intrinsics.areEqual((Object)DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY), (Object)true)) {
                editor.putUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY, (Object)true);
                return EnterHandlerDelegate.Result.Continue;
            }
            v1 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDocument(...)");
            document = v1;
            PsiDocumentManager.getInstance((Project)((MarkdownFile)file).getProject()).commitDocument(document);
            v2 = caretOffset.get();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
            line = document.getLineNumber(((Number)v2).intValue());
            if (line <= 0) break block17;
            indentRange = ListUtils.INSTANCE.getLineIndentRange(document, line);
            if (indentRange.isEmpty()) ** GOTO lbl-1000
            v3 = caretOffset.get();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
            if (((Number)v3).intValue() <= indentRange.getEndOffset()) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            insideIndent = v4;
            v5 = prevLineBlank = ListUtils.INSTANCE.getLineIndentRange(document, line - 1).getEndOffset() == document.getLineEndOffset(line - 1);
            if (insideIndent && prevLineBlank) {
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        v6 = (MarkdownFile)file;
        v7 = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"get(...)");
        v8 = ListUtils.INSTANCE.getListItemAt(v6, ((Number)v7).intValue(), document);
        if (v8 == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        item = v8;
        v9 = item.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getChildren(...)");
        if (((Object[])v9).length == 0) {
            this.handleEmptyItem(item, editor, file, originalHandler, dataContext);
            caretOffset.set((Object)editor.getCaretModel().getOffset());
            return EnterHandlerDelegate.Result.Stop;
        }
        v10 = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"get(...)");
        v11 = MarkdownPsiUtil.INSTANCE.findNonWhiteSpacePrevSibling(file, ((Number)v10).intValue());
        if (v11 != null) {
            $this$parentOfType_u24default$iv = v11;
            withSelf$iv = false;
            $i$f$parentOfType = false;
            v12 = (MarkdownBlockQuote)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownBlockQuote.class, (boolean)true);
        } else {
            v12 = blockQuote = null;
        }
        if (blockQuote != null && PsiTreeUtilKt.isAncestor$default((PsiElement)((PsiElement)item), (PsiElement)((PsiElement)blockQuote), (boolean)false, (int)2, null)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        itemLine = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)item)));
        v13 = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)v13);
        markerElement = v13;
        v14 = ListUtils.INSTANCE.getLineIndentRange(document, itemLine).union(markerElement.getTextRange());
        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"union(...)");
        indentWithMakerRange = v14;
        v15 = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"get(...)");
        if (indentWithMakerRange.contains(((Number)v15).intValue())) {
            caretOffset.set((Object)UtilsKt.getEndOffset((PsiElement)markerElement));
        }
        if ((v16 = ListUtils.INSTANCE.getLineIndentSpaces(document, itemLine, file)) == null) {
            v16 = "";
        }
        indentSpaces = v16;
        this.emptyItem = indentSpaces + ListUtils.INSTANCE.getNormalizedMarker(item);
        return EnterHandlerDelegate.Result.Default;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInCodeFence(int caretOffset, PsiFile file) {
        void $this$parentOfType$iv;
        PsiElement element2;
        if (caretOffset == 0) {
            return false;
        }
        PsiElement psiElement = file.findElementAt(caretOffset - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = element2 = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        MarkdownCodeFence fence = (MarkdownCodeFence)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownCodeFence.class, (boolean)false);
        return fence != null;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleEmptyItem(MarkdownListItem item, Editor editor2, PsiFile file, EditorActionHandler originalHandler, DataContext dataContext) {
        void $this$parentOfType$iv;
        PsiElement psiElement = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement markerElement = psiElement;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiElement psiElement2 = (PsiElement)item;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListItem.class, (boolean)true) == null) {
            MarkdownListMarkerBackspaceHandlerDelegate backspaceHandler = new MarkdownListMarkerBackspaceHandlerDelegate();
            int markerEnd = UtilsKt.getEndOffset((PsiElement)markerElement);
            editor2.getCaretModel().moveToOffset(markerEnd);
            char c = editor2.getDocument().getCharsSequence().charAt(markerEnd - 1);
            backspaceHandler.beforeCharDeleted(c, file, editor2);
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(document2, markerEnd){
                final /* synthetic */ Document $document;
                final /* synthetic */ int $markerEnd;
                {
                    this.$document = $document;
                    this.$markerEnd = $markerEnd;
                    super(0);
                }

                public final void invoke() {
                    this.$document.deleteString(this.$markerEnd - 1, this.$markerEnd);
                }
            }));
            backspaceHandler.charDeleted(c, file, editor2);
        } else {
            MarkdownListItemUnindentHandler unindentHandler = new MarkdownListItemUnindentHandler(originalHandler);
            unindentHandler.execute(editor2, editor2.getCaretModel().getCurrentCaret(), dataContext);
        }
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (Intrinsics.areEqual((Object)editor2.getUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY), (Object)true)) {
            editor2.putUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY, null);
            return EnterHandlerDelegate.Result.Continue;
        }
        String string = this.emptyItem;
        if (string == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        String emptyItem = string;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)emptyItem);
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
        MarkdownListItem markdownListItem = ListUtils.INSTANCE.getListItemAt((MarkdownFile)file, editor2.getCaretModel().getOffset(), document2);
        Intrinsics.checkNotNull((Object)markdownListItem);
        MarkdownListItem item = markdownListItem;
        if (this.getCodeInsightSettings().getRenumberListsOnType()) {
            ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, ListUtils.INSTANCE.getList(item), document2, false, false, false, 8, null);
        } else {
            Integer previousNumber;
            MarkdownListItem previousItem;
            Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)item), (boolean)false, (boolean)false);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)postProcessEnter$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            MarkdownListItem markdownListItem2 = previousItem = (MarkdownListItem)SequencesKt.firstOrNull((Sequence)sequence);
            Integer n = previousNumber = markdownListItem2 != null ? ListRenumberUtils.INSTANCE.obtainMarkerNumber(markdownListItem2) : null;
            if (previousNumber != null) {
                MarkdownListNumber marker2;
                PsiElement psiElement = item.getMarkerElement();
                MarkdownListNumber markdownListNumber = marker2 = psiElement instanceof MarkdownListNumber ? (MarkdownListNumber)psiElement : null;
                if (markdownListNumber != null) {
                    MarkdownListEnterHandlerDelegate.Companion.replaceWithOtherNumber(markdownListNumber, previousNumber + 1);
                }
            }
        }
        this.emptyItem = null;
        return EnterHandlerDelegate.Result.Stop;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate$Companion;", "", "()V", "replaceWithOtherNumber", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListNumber;", "number", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final MarkdownListNumber replaceWithOtherNumber(MarkdownListNumber $this$replaceWithOtherNumber, int number) {
            LeafElement leafElement = $this$replaceWithOtherNumber.replaceWithText("" + number + $this$replaceWithOtherNumber.getDelimiter() + " ");
            Intrinsics.checkNotNull((Object)leafElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownListNumber");
            return (MarkdownListNumber)leafElement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

