/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.ColumnSelectionKt;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a:\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u00a8\u0006\u0012"}, d2={"obtainCellSelectionRange", "Lcom/intellij/openapi/util/TextRange;", "cell", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "withBorders", "", "selectColumn", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "columnIndex", "", "withHeader", "withSeparator", "setSelectionFromRange", "Lcom/intellij/openapi/editor/Caret;", "textRange", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nColumnSelection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnSelection.kt\norg/intellij/plugins/markdown/editor/tables/ColumnSelectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class ColumnSelectionKt {
    public static final void selectColumn(@NotNull MarkdownTable $this$selectColumn, @NotNull Editor editor2, int columnIndex, boolean withHeader, boolean withSeparator, boolean withBorders) {
        Intrinsics.checkNotNullParameter((Object)$this$selectColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$selectColumn, columnIndex, withHeader);
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        caretModel2.removeSecondaryCarets();
        Caret caret = caretModel2.getCurrentCaret();
        Caret $this$selectColumn_u24lambda_u240 = caret;
        boolean bl = false;
        TextRange textRange = ColumnSelectionKt.obtainCellSelectionRange((MarkdownTableCell)CollectionsKt.first(cells), withBorders);
        $this$selectColumn_u24lambda_u240.moveToOffset(textRange.getStartOffset());
        Intrinsics.checkNotNull((Object)$this$selectColumn_u24lambda_u240);
        ColumnSelectionKt.setSelectionFromRange($this$selectColumn_u24lambda_u240, textRange);
        if (withSeparator) {
            TextRange range;
            TextRange textRange2;
            if (withBorders) {
                MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$selectColumn);
                textRange2 = markdownTableSeparatorRow != null ? MarkdownTableSeparatorRow.getCellRangeWithPipes$default(markdownTableSeparatorRow, columnIndex, false, 2, null) : null;
            } else {
                MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$selectColumn);
                textRange2 = markdownTableSeparatorRow != null ? MarkdownTableSeparatorRow.getCellRange$default(markdownTableSeparatorRow, columnIndex, false, 2, null) : null;
            }
            TextRange textRange3 = range = textRange2;
            if (textRange3 != null) {
                Caret caret2;
                TextRange textRange4 = textRange3;
                boolean bl2 = false;
                Caret caret3 = caret2 = caretModel2.addCaret(editor2.offsetToVisualPosition(textRange4.getStartOffset()));
                if (caret3 != null) {
                    ColumnSelectionKt.setSelectionFromRange(caret3, textRange4);
                }
            }
        }
        for (MarkdownTableCell cell : SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)cells), (int)1)) {
            Caret caret4;
            TextRange textRange5 = ColumnSelectionKt.obtainCellSelectionRange(cell, withBorders);
            Caret caret5 = caret4 = caretModel2.addCaret(editor2.offsetToVisualPosition(textRange5.getStartOffset()));
            if (caret5 == null) continue;
            ColumnSelectionKt.setSelectionFromRange(caret5, textRange5);
        }
    }

    public static /* synthetic */ void selectColumn$default(MarkdownTable markdownTable, Editor editor2, int n, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        ColumnSelectionKt.selectColumn(markdownTable, editor2, n, bl, bl2, bl3);
    }

    private static final TextRange obtainCellSelectionRange(MarkdownTableCell cell, boolean withBorders) {
        Object v3;
        PsiElement leftPipe2;
        TextRange range;
        block4: {
            Object v1;
            Object object2;
            block3: {
                range = cell.getTextRange();
                if (!withBorders) {
                    Intrinsics.checkNotNull((Object)range);
                    return range;
                }
                Sequence sequence = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings((PsiElement)((PsiElement)cell), (boolean)false, (boolean)false), (Function1)obtainCellSelectionRange.leftPipe.1.INSTANCE);
                for (Object object2 : sequence) {
                    PsiElement it = (PsiElement)object2;
                    boolean bl = false;
                    IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
                    if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                    v1 = object2;
                    break block3;
                }
                v1 = null;
            }
            leftPipe2 = v1;
            Iterator iterator = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings((PsiElement)((PsiElement)cell), (boolean)true, (boolean)false), (Function1)obtainCellSelectionRange.rightPipe.1.INSTANCE);
            object2 = iterator.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
                if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                v3 = e;
                break block4;
            }
            v3 = null;
        }
        PsiElement rightPipe2 = v3;
        PsiElement psiElement = leftPipe2;
        int left = psiElement != null ? UtilsKt.getStartOffset((PsiElement)psiElement) : range.getStartOffset();
        PsiElement psiElement2 = rightPipe2;
        int right = psiElement2 != null ? UtilsKt.getEndOffset((PsiElement)psiElement2) : range.getEndOffset();
        return new TextRange(left, right);
    }

    private static final void setSelectionFromRange(Caret $this$setSelectionFromRange, TextRange textRange) {
        $this$setSelectionFromRange.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
    }
}

