/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "Center", "Left", "Right", "intellij.markdown.core"})
public abstract class SetColumnAlignmentAction
extends ToggleAction {
    @NotNull
    private final MarkdownTableSeparatorRow.CellAlignment alignment;

    public SetColumnAlignmentAction(@NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        this.alignment = alignment;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        Integer offset;
        PsiFile file;
        Editor editor2;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
                file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
                Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
                Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
                if (editor2 == null || file == null || offset == null) break block3;
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) break block4;
            }
            event.getPresentation().setEnabledAndVisible(false);
            return false;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, document2, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        MarkdownTable markdownTable = table;
        event.getPresentation().setEnabledAndVisible(markdownTable != null ? TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTable) : false);
        return table == null || columnIndex == null ? false : TableUtils.INSTANCE.getColumnAlignment(table, columnIndex) == this.alignment;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Integer offset;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
        if (editor2 == null || file == null || offset == null) {
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, document2, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        if (table != null && columnIndex != null) {
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(table, state, this, editor2, columnIndex){
                final /* synthetic */ MarkdownTable $table;
                final /* synthetic */ boolean $state;
                final /* synthetic */ SetColumnAlignmentAction this$0;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ Integer $columnIndex;
                {
                    this.$table = $table;
                    this.$state = $state;
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    this.$columnIndex = $columnIndex;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void project$iv;
                    Project project = this.$table.getProject();
                    boolean bl = this.$state;
                    SetColumnAlignmentAction setColumnAlignmentAction = this.this$0;
                    MarkdownTable markdownTable = this.$table;
                    Editor editor2 = this.$editor;
                    Integer n = this.$columnIndex;
                    String name$iv = null;
                    Object groupId$iv = null;
                    boolean $i$f$executeCommand = false;
                    CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(bl, setColumnAlignmentAction, markdownTable, editor2, n){
                        final /* synthetic */ boolean $state$inlined;
                        final /* synthetic */ SetColumnAlignmentAction this$0;
                        final /* synthetic */ MarkdownTable $table$inlined;
                        final /* synthetic */ Editor $editor$inlined;
                        final /* synthetic */ Integer $columnIndex$inlined;
                        {
                            this.$state$inlined = bl;
                            this.this$0 = setColumnAlignmentAction;
                            this.$table$inlined = markdownTable;
                            this.$editor$inlined = editor2;
                            this.$columnIndex$inlined = n;
                        }

                        public final void run() {
                            boolean bl = false;
                            MarkdownTableSeparatorRow.CellAlignment actualAlignment = this.$state$inlined ? SetColumnAlignmentAction.access$getAlignment$p(this.this$0) : MarkdownTableSeparatorRow.CellAlignment.NONE;
                            Document document = this.$editor$inlined.getDocument();
                            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                            TableModificationUtils.INSTANCE.updateColumnAlignment(this.$table$inlined, document, this.$columnIndex$inlined, actualAlignment);
                        }
                    }, name$iv, groupId$iv);
                }
            }));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public static final /* synthetic */ MarkdownTableSeparatorRow.CellAlignment access$getAlignment$p(SetColumnAlignmentAction $this) {
        return $this.alignment;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Center;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown.core"})
    public static final class Center
    extends SetColumnAlignmentAction {
        public Center() {
            super(MarkdownTableSeparatorRow.CellAlignment.CENTER);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Left;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown.core"})
    public static final class Left
    extends SetColumnAlignmentAction {
        public Left() {
            super(MarkdownTableSeparatorRow.CellAlignment.LEFT);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Right;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown.core"})
    public static final class Right
    extends SetColumnAlignmentAction {
        public Right() {
            super(MarkdownTableSeparatorRow.CellAlignment.RIGHT);
        }
    }
}

