/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.calls.tower.NewAbstractResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u00030\n\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f*\u0006\u0012\u0002\b\u00030\n\u001a\u000e\u0010\u0010\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n\u001a\u000e\u0010\u0012\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n\u001a\u001c\u0010\u0013\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002\u001a\u0016\u0010\u0015\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u0016\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n\u001a\n\u0010\u0017\u001a\u00020\u0011*\u00020\u0018\u001a&\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u0006\u0012\u0002\b\u00030\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0014\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u001e\u00a8\u0006\u001f"}, d2={"getArgumentByParameterIndex", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "index", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDispatchReceiverWithSmartCast", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getExplicitReceiverValue", "getImplicitReceiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "getImplicitReceivers", "", "hasBothReceivers", "", "hasInferredReturnType", "hasSafeNullableReceiver", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "hasThisOrNoDispatchReceiver", "isNewNotCompleted", "isNotSimpleCall", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "makeNullableTypeIfSafeReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "toResolutionStatus", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "frontend"})
@SourceDebugExtension(value={"SMAP\nresolvedCallUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolvedCallUtil.kt\norg/jetbrains/kotlin/resolve/calls/util/ResolvedCallUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class ResolvedCallUtilKt {
    public static final boolean hasThisOrNoDispatchReceiver(@NotNull ResolvedCall<?> $this$hasThisOrNoDispatchReceiver, @NotNull BindingContext context) {
        KtExpression expression2;
        Intrinsics.checkNotNullParameter($this$hasThisOrNoDispatchReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReceiverValue dispatchReceiverValue = $this$hasThisOrNoDispatchReceiver.getDispatchReceiver();
        if ($this$hasThisOrNoDispatchReceiver.getResultingDescriptor().getDispatchReceiverParameter() == null || dispatchReceiverValue == null) {
            return true;
        }
        DeclarationDescriptor dispatchReceiverDescriptor = null;
        ReceiverValue receiverValue = dispatchReceiverValue;
        if (receiverValue instanceof ImplicitReceiver) {
            dispatchReceiverDescriptor = ((ImplicitReceiver)dispatchReceiverValue).getDeclarationDescriptor();
        } else if (receiverValue instanceof ClassValueReceiver) {
            dispatchReceiverDescriptor = ((ClassValueReceiver)dispatchReceiverValue).getClassQualifier().getDescriptor();
        } else if (receiverValue instanceof ExpressionReceiver && (expression2 = KtPsiUtil.deparenthesize((KtExpression)((ExpressionReceiver)dispatchReceiverValue).getExpression())) instanceof KtThisExpression) {
            dispatchReceiverDescriptor = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression2).getInstanceReference());
        }
        Object obj = $this$hasThisOrNoDispatchReceiver.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        return Intrinsics.areEqual((Object)dispatchReceiverDescriptor, (Object)DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter(obj));
    }

    @Nullable
    public static final ReceiverValue getExplicitReceiverValue(@NotNull ResolvedCall<?> $this$getExplicitReceiverValue) {
        ReceiverValue receiverValue;
        Intrinsics.checkNotNullParameter($this$getExplicitReceiverValue, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getExplicitReceiverValue.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                ReceiverValue receiverValue2 = $this$getExplicitReceiverValue.getDispatchReceiver();
                receiverValue = receiverValue2;
                Intrinsics.checkNotNull((Object)receiverValue2);
                break;
            }
            case 2: 
            case 3: {
                ReceiverValue receiverValue3 = $this$getExplicitReceiverValue.getExtensionReceiver();
                receiverValue = receiverValue3;
                Intrinsics.checkNotNull((Object)receiverValue3);
                break;
            }
            default: {
                receiverValue = null;
            }
        }
        return receiverValue;
    }

    @Nullable
    public static final ImplicitReceiver getImplicitReceiverValue(@NotNull ResolvedCall<?> $this$getImplicitReceiverValue) {
        Intrinsics.checkNotNullParameter($this$getImplicitReceiverValue, (String)"<this>");
        Object object = CollectionsKt.firstOrNull((Iterable)ResolvedCallUtilKt.getImplicitReceivers($this$getImplicitReceiverValue));
        return object instanceof ImplicitReceiver ? (ImplicitReceiver)object : null;
    }

    @NotNull
    public static final Collection<ReceiverValue> getImplicitReceivers(@NotNull ResolvedCall<?> $this$getImplicitReceivers) {
        Collection collection;
        Intrinsics.checkNotNullParameter($this$getImplicitReceivers, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getImplicitReceivers.getExplicitReceiverKind().ordinal()]) {
            case 4: {
                Object[] objectArray = new ReceiverValue[]{$this$getImplicitReceivers.getExtensionReceiver(), $this$getImplicitReceivers.getDispatchReceiver()};
                collection = CollectionsKt.listOfNotNull((Object[])objectArray);
                break;
            }
            case 1: {
                collection = CollectionsKt.listOfNotNull((Object)$this$getImplicitReceivers.getExtensionReceiver());
                break;
            }
            case 2: {
                collection = CollectionsKt.listOfNotNull((Object)$this$getImplicitReceivers.getDispatchReceiver());
                break;
            }
            case 3: {
                collection = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return collection;
    }

    private static final boolean hasSafeNullableReceiver(ResolvedCall<?> $this$hasSafeNullableReceiver, CallResolutionContext<?> context) {
        Object object;
        block5: {
            block4: {
                Call call2 = $this$hasSafeNullableReceiver.getCall();
                Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
                if (!CallUtilKt.isSafeCall(call2)) {
                    return false;
                }
                object = ResolvedCallUtilKt.getExplicitReceiverValue($this$hasSafeNullableReceiver);
                if (object == null) break block4;
                ReceiverValue it = object;
                boolean bl = false;
                DataFlowValue dataFlowValue = context.dataFlowValueFactory.createDataFlowValue(it, (ResolutionContext)context);
                object = dataFlowValue;
                if (dataFlowValue != null) break block5;
            }
            return false;
        }
        Object receiverValue = object;
        return context.dataFlowInfo.getStableNullability((DataFlowValue)receiverValue).canBeNull();
    }

    @Nullable
    public static final KotlinType makeNullableTypeIfSafeReceiver(@NotNull ResolvedCall<?> $this$makeNullableTypeIfSafeReceiver, @Nullable KotlinType type2, @NotNull CallResolutionContext<?> context) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$makeNullableTypeIfSafeReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            kotlinType = TypeUtils.makeNullableIfNeeded(type2, ResolvedCallUtilKt.hasSafeNullableReceiver($this$makeNullableTypeIfSafeReceiver, context));
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    public static final boolean hasBothReceivers(@NotNull ResolvedCall<?> $this$hasBothReceivers) {
        Intrinsics.checkNotNullParameter($this$hasBothReceivers, (String)"<this>");
        return $this$hasBothReceivers.getDispatchReceiver() != null && $this$hasBothReceivers.getExtensionReceiver() != null;
    }

    @Nullable
    public static final ReceiverValue getDispatchReceiverWithSmartCast(@NotNull ResolvedCall<?> $this$getDispatchReceiverWithSmartCast) {
        Intrinsics.checkNotNullParameter($this$getDispatchReceiverWithSmartCast, (String)"<this>");
        return SmartCastUtilKt.getReceiverValueWithSmartCast($this$getDispatchReceiverWithSmartCast.getDispatchReceiver(), $this$getDispatchReceiverWithSmartCast.getSmartCastDispatchReceiverType());
    }

    @NotNull
    public static final List<ValueArgument> getArgumentByParameterIndex(@NotNull KtCallElement $this$getArgumentByParameterIndex, int index2, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$getArgumentByParameterIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)$this$getArgumentByParameterIndex, context);
        if (resolvedCall2 == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        List<ValueParameterDescriptor> list2 = resolvedCall3.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.getOrNull(list2, (int)index2);
        if (valueParameterDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ValueParameterDescriptor parameterToProcess = valueParameterDescriptor;
        ResolvedValueArgument resolvedValueArgument = resolvedCall3.getValueArguments().get(parameterToProcess);
        List list3 = resolvedValueArgument != null ? resolvedValueArgument.getArguments() : null;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotSimpleCall(@NotNull CallableDescriptor $this$isNotSimpleCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotSimpleCall, (String)"<this>");
        List<TypeParameterDescriptor> list2 = $this$isNotSimpleCall.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
        if (!((Collection)list2).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        KotlinType kotlinType = $this$isNotSimpleCall.getReturnType();
        if (kotlinType == null) return false;
        KotlinType type2 = kotlinType;
        boolean bl2 = false;
        boolean bl3 = TypeUtilsKt.contains(type2, (Function1<? super UnwrappedType, Boolean>)((Function1)isNotSimpleCall.1.1.INSTANCE));
        if (!bl3) return false;
        return true;
    }

    public static final boolean isNewNotCompleted(@NotNull ResolvedCall<?> $this$isNewNotCompleted) {
        Intrinsics.checkNotNullParameter($this$isNewNotCompleted, (String)"<this>");
        return $this$isNewNotCompleted instanceof NewAbstractResolvedCall ? !((NewAbstractResolvedCall)$this$isNewNotCompleted).isCompleted() : false;
    }

    public static final boolean hasInferredReturnType(@NotNull ResolvedCall<?> $this$hasInferredReturnType) {
        Intrinsics.checkNotNullParameter($this$hasInferredReturnType, (String)"<this>");
        if (ResolvedCallUtilKt.isNewNotCompleted($this$hasInferredReturnType)) {
            return false;
        }
        KotlinType kotlinType = $this$hasInferredReturnType.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType2 = kotlinType;
        return !TypeUtilsKt.contains(returnType2, (Function1<? super UnwrappedType, Boolean>)((Function1)hasInferredReturnType.1.INSTANCE));
    }

    @NotNull
    public static final ResolutionStatus toResolutionStatus(@NotNull CandidateApplicability $this$toResolutionStatus) {
        ResolutionStatus resolutionStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toResolutionStatus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toResolutionStatus.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                resolutionStatus = ResolutionStatus.SUCCESS;
                break;
            }
            case 5: {
                resolutionStatus = ResolutionStatus.RECEIVER_TYPE_ERROR;
                break;
            }
            case 6: {
                resolutionStatus = ResolutionStatus.UNSAFE_CALL_ERROR;
                break;
            }
            default: {
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            }
        }
        return resolutionStatus;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            try {
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CandidateApplicability.values().length];
            try {
                nArray[CandidateApplicability.RESOLVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.RESOLVED_LOW_PRIORITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.RESOLVED_WITH_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.RESOLVED_NEED_PRESERVE_COMPATIBILITY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.INAPPLICABLE_WRONG_RECEIVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.UNSAFE_CALL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

